/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.topology.CdpInterface;
import org.opennms.netmgt.model.topology.IsisISAdjInterface;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.model.topology.LldpRemInterface;
import org.opennms.netmgt.model.topology.OspfNbrInterface;
import org.opennms.netmgt.model.topology.RouterInterface;
import org.springframework.util.Assert;

public class LinkableNode {
    private final String m_packageName;
    private final LinkableSnmpNode m_snmpnode;
    private String m_cdpDeviceId;
    private List<CdpInterface> m_cdpinterfaces = new ArrayList<CdpInterface>();
    private String m_lldpSysname;
    private String m_lldpChassisId;
    private Integer m_lldpChassisIdSubtype;
    private List<LldpRemInterface> m_lldpreminterfaces = new ArrayList<LldpRemInterface>();
    private InetAddress m_ospfRouterId;
    private List<OspfNbrInterface> m_ospfinterfaces = new ArrayList<OspfNbrInterface>();
    private String m_isisSysId;
    private List<IsisISAdjInterface> m_isisinterfaces = new ArrayList<IsisISAdjInterface>();
    private List<RouterInterface> m_routeinterfaces = new ArrayList<RouterInterface>();
    private Map<Integer, String> m_macIdentifiers = new HashMap<Integer, String>();
    private Map<Integer, List<OnmsStpInterface>> m_vlanStpInterfaces = new HashMap<Integer, List<OnmsStpInterface>>();
    private Map<Integer, String> m_vlanBridgeIdentifier = new HashMap<Integer, String>();
    private Map<Integer, Set<String>> m_portMacs = new HashMap<Integer, Set<String>>();
    private Map<Integer, String> m_vlanStpRoot = new HashMap<Integer, String>();
    private Map<Integer, Integer> m_bridgePortIfindex = new HashMap<Integer, Integer>();
    private Map<Integer, Set<String>> m_wifiIfIndexMac = new HashMap<Integer, Set<String>>();

    public LinkableNode(LinkableSnmpNode snmpnode, String packageName) {
        this.m_snmpnode = snmpnode;
        this.m_packageName = packageName;
    }

    public String getIsisSysId() {
        return this.m_isisSysId;
    }

    public void setIsisSysId(String isisSysId) {
        this.m_isisSysId = isisSysId;
    }

    public String getCdpDeviceId() {
        return this.m_cdpDeviceId;
    }

    public void setCdpDeviceId(String cdpDeviceId) {
        this.m_cdpDeviceId = cdpDeviceId;
    }

    public InetAddress getOspfRouterId() {
        return this.m_ospfRouterId;
    }

    public void setOspfRouterId(InetAddress ospfRouterId) {
        this.m_ospfRouterId = ospfRouterId;
    }

    public void setLldpSysname(String lldpSysname) {
        this.m_lldpSysname = lldpSysname;
    }

    public void setLldpChassisId(String lldpChassisId) {
        this.m_lldpChassisId = lldpChassisId;
    }

    public void setLldpChassisIdSubtype(Integer lldpChassisIdSubtype) {
        this.m_lldpChassisIdSubtype = lldpChassisIdSubtype;
    }

    public String getLldpSysname() {
        return this.m_lldpSysname;
    }

    public String getLldpChassisId() {
        return this.m_lldpChassisId;
    }

    public Integer getLldpChassisIdSubtype() {
        return this.m_lldpChassisIdSubtype;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public LinkableSnmpNode getLinkableSnmpNode() {
        return this.m_snmpnode;
    }

    public List<LldpRemInterface> getLldpRemInterfaces() {
        return this.m_lldpreminterfaces;
    }

    public void setLldpRemInterfaces(List<LldpRemInterface> lldpreminterfaces) {
        this.m_lldpreminterfaces = lldpreminterfaces;
    }

    public List<OspfNbrInterface> getOspfinterfaces() {
        return this.m_ospfinterfaces;
    }

    public void setOspfinterfaces(List<OspfNbrInterface> ospfinterfaces) {
        this.m_ospfinterfaces = ospfinterfaces;
    }

    public List<IsisISAdjInterface> getIsisInterfaces() {
        return this.m_isisinterfaces;
    }

    public void setIsisInterfaces(List<IsisISAdjInterface> isisinterfaces) {
        this.m_isisinterfaces = isisinterfaces;
    }

    public List<CdpInterface> getCdpInterfaces() {
        return this.m_cdpinterfaces;
    }

    public void setCdpInterfaces(List<CdpInterface> cdpinterfaces) {
        if (cdpinterfaces == null || cdpinterfaces.isEmpty()) {
            return;
        }
        this.m_cdpinterfaces = cdpinterfaces;
    }

    public boolean hasCdpInterfaces() {
        return !this.m_cdpinterfaces.isEmpty();
    }

    public List<RouterInterface> getRouteInterfaces() {
        return this.m_routeinterfaces;
    }

    public void setRouteInterfaces(List<RouterInterface> routeinterfaces) {
        if (routeinterfaces == null || routeinterfaces.isEmpty()) {
            return;
        }
        this.m_routeinterfaces = routeinterfaces;
    }

    public boolean hasRouteInterfaces() {
        return !this.m_routeinterfaces.isEmpty();
    }

    public boolean isBridgeNode() {
        return !this.m_vlanBridgeIdentifier.isEmpty();
    }

    public Collection<String> getBridgeIdentifiers() {
        return this.m_vlanBridgeIdentifier.values();
    }

    public void addBridgeIdentifier(String bridge, Integer vlan) {
        this.m_vlanBridgeIdentifier.put(vlan, bridge);
    }

    public boolean isBridgeIdentifier(String bridge) {
        return this.m_vlanBridgeIdentifier.containsValue(bridge);
    }

    public String getBridgeIdentifier(Integer vlan) {
        return this.m_vlanBridgeIdentifier.get(vlan);
    }

    public void setMacIdentifiers(Map<Integer, String> macIdentifiers) {
        this.m_macIdentifiers = macIdentifiers;
    }

    public Map<Integer, String> getMacIdentifiers() {
        return this.m_macIdentifiers;
    }

    public boolean isMacIdentifier(String mac) {
        return this.m_macIdentifiers.values().contains(mac);
    }

    public void addWifiMacAddress(Integer ifindex, String macAddress) {
        Set<String> macs = new HashSet<String>();
        if (this.m_wifiIfIndexMac.containsKey(ifindex)) {
            macs = this.m_wifiIfIndexMac.get(ifindex);
        }
        macs.add(macAddress);
        this.m_wifiIfIndexMac.put(ifindex, macs);
    }

    public Map<Integer, Set<String>> getWifiMacIfIndexMap() {
        return this.m_wifiIfIndexMac;
    }

    public void addBridgeForwardingTableEntry(int bridgeport, String macAddress) {
        Set<String> macs = new HashSet<String>();
        if (this.m_portMacs.containsKey(bridgeport)) {
            macs = this.m_portMacs.get(bridgeport);
        }
        macs.add(macAddress);
        this.m_portMacs.put(bridgeport, macs);
    }

    public boolean hasBridgeForwardingTableEntryFor(String macAddress) {
        for (Set<String> macs : this.m_portMacs.values()) {
            if (!macs.contains(macAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBridgeForwardingTable() {
        return !this.m_portMacs.isEmpty();
    }

    public Set<String> getBridgeForwadingTableOnBridgePort(int bridgeport) {
        if (this.hasBridgeForwardingTableOnBridgePort(bridgeport)) {
            return this.m_portMacs.get(bridgeport);
        }
        return Collections.emptySet();
    }

    public boolean hasBridgeForwardingTableOnBridgePort(int bridgeport) {
        return this.m_portMacs.containsKey(bridgeport) && this.m_portMacs.get(bridgeport) != null;
    }

    public List<Integer> getBridgeForwardingTablePortsFromMac(String macAddress) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Integer intePort : this.m_portMacs.keySet()) {
            if (!this.m_portMacs.get(intePort).contains(macAddress)) continue;
            ports.add(intePort);
        }
        return ports;
    }

    public int getIfindexFromBridgePort(int bridgeport) {
        if (this.m_bridgePortIfindex.containsKey(bridgeport)) {
            return this.m_bridgePortIfindex.get(bridgeport);
        }
        return -1;
    }

    public int getBridgePortFromIfindex(int ifindex) {
        for (Integer curBridgePort : this.m_bridgePortIfindex.keySet()) {
            Integer curIfIndex = this.m_bridgePortIfindex.get(curBridgePort);
            if (curIfIndex != ifindex) continue;
            return curBridgePort;
        }
        return -1;
    }

    public void setIfIndexBridgePort(Integer ifindex, Integer bridgeport) {
        Assert.notNull((Object)ifindex);
        Assert.notNull((Object)bridgeport);
        this.m_bridgePortIfindex.put(bridgeport, ifindex);
    }

    public Map<Integer, Set<String>> getBridgeForwardingTable() {
        return this.m_portMacs;
    }

    public void setBridgeForwardingTable(Map<Integer, Set<String>> portMacs) {
        this.m_portMacs = portMacs;
    }

    public void setVlanStpRoot(Integer vlan, String stproot) {
        if (stproot != null) {
            this.m_vlanStpRoot.put(vlan, stproot);
        }
    }

    public boolean hasStpRoot(Integer vlan) {
        return this.m_vlanStpRoot.containsKey(vlan);
    }

    public String getStpRoot(Integer vlan) {
        if (this.m_vlanStpRoot.containsKey(vlan)) {
            return this.m_vlanStpRoot.get(vlan);
        }
        return null;
    }

    public Map<Integer, List<OnmsStpInterface>> getStpInterfaces() {
        return this.m_vlanStpInterfaces;
    }

    public void addStpInterface(OnmsStpInterface stpIface) {
        Integer vlanindex = stpIface.getVlan() == null ? 0 : stpIface.getVlan();
        List<OnmsStpInterface> stpifs = new ArrayList<OnmsStpInterface>();
        if (this.m_vlanStpInterfaces.containsKey(vlanindex)) {
            stpifs = this.m_vlanStpInterfaces.get(vlanindex);
        }
        stpifs.add(stpIface);
        this.m_vlanStpInterfaces.put(vlanindex, stpifs);
    }

    public int getNodeId() {
        return this.getLinkableSnmpNode().getNodeId();
    }

    public InetAddress getSnmpPrimaryIpAddr() {
        return this.getLinkableSnmpNode().getSnmpPrimaryIpAddr();
    }

    public String getSysoid() {
        return this.getLinkableSnmpNode().getSysoid();
    }
}

