/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;

@Entity
@Table(name="cdpElement")
public final class CdpElement
implements Serializable {
    private static final long serialVersionUID = -3134355798509685991L;
    private Integer m_id;
    private OspfElement.TruthValue m_cdpGlobalRun;
    private String m_cdpGlobalDeviceId;
    private Date m_cdpNodeCreateTime = new Date();
    private Date m_cdpNodeLastPollTime;
    private OnmsNode m_node;

    public CdpElement() {
    }

    public CdpElement(OnmsNode node, String cdpGlobalDeviceId) {
        this.setNode(node);
        this.setCdpGlobalDeviceId(cdpGlobalDeviceId);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Column(name="cdpGlobalRun", nullable=false)
    @Type(type="org.opennms.netmgt.model.TruthValueUserType")
    public OspfElement.TruthValue getCdpGlobalRun() {
        return this.m_cdpGlobalRun;
    }

    @Column(name="cdpGlobalDeviceId", length=256, nullable=false)
    public String getCdpGlobalDeviceId() {
        return this.m_cdpGlobalDeviceId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpNodeCreateTime", nullable=false)
    public Date getCdpNodeCreateTime() {
        return this.m_cdpNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpNodeLastPollTime", nullable=false)
    public Date getCdpNodeLastPollTime() {
        return this.m_cdpNodeLastPollTime;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setCdpGlobalRun(OspfElement.TruthValue cdpGlobalRun) {
        this.m_cdpGlobalRun = cdpGlobalRun;
    }

    public void setCdpGlobalDeviceId(String cdpGlobalDeviceId) {
        this.m_cdpGlobalDeviceId = cdpGlobalDeviceId;
    }

    public void setCdpNodeCreateTime(Date cdpNodeCreateTime) {
        this.m_cdpNodeCreateTime = cdpNodeCreateTime;
    }

    public void setCdpNodeLastPollTime(Date cdpNodeLastPollTime) {
        this.m_cdpNodeLastPollTime = cdpNodeLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Nodeid", (Object)this.m_node.getId()).append("cdpGlobalDeviceId", (Object)this.m_cdpGlobalDeviceId).append("cdpNodeCreateTime", (Object)this.m_cdpNodeCreateTime).append("cdpNodeLastPollTime", (Object)this.m_cdpNodeLastPollTime).toString();
    }

    public void merge(CdpElement element) {
        if (element == null) {
            return;
        }
        this.setCdpGlobalRun(element.getCdpGlobalRun());
        this.setCdpGlobalDeviceId(element.getCdpGlobalDeviceId());
        this.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
    }
}

