/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.opennms.core.logging.Logging;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.BroadcastEventProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapQueueProcessorFactory;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class Trapd
extends AbstractServiceDaemon
implements TrapProcessorFactory,
TrapNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(Trapd.class);
    private static final String LOG4J_CATEGORY = "trapd";
    private int m_status = 0;
    private ExecutorService m_backlogQ;
    @Autowired
    private TrapQueueProcessorFactory m_processorFactory;
    @Autowired
    private BroadcastEventProcessor m_eventReader;
    @Autowired
    private TrapdIpMgr m_trapdIpMgr;
    @Resource(name="snmpTrapAddress")
    private String m_snmpTrapAddress;
    @Resource(name="snmpTrapPort")
    private Integer m_snmpTrapPort;
    @Resource(name="snmpV3Users")
    private List<SnmpV3User> m_snmpV3Users;
    private boolean m_registeredForTraps;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    public TrapProcessor createTrapProcessor() {
        return new EventCreator(this.m_trapdIpMgr);
    }

    public void trapReceived(TrapNotification trapNotification) {
        this.m_backlogQ.submit(this.m_processorFactory.getInstance(trapNotification));
    }

    public synchronized void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_backlogQ != null ? 1 : 0) != 0, (String)"backlogQ must be set");
        try {
            this.m_trapdIpMgr.dataSourceSync();
        }
        catch (SQLException e) {
            LOG.error("init: Failed to load known IP address list", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            InetAddress address = this.getInetAddress();
            LOG.info("Listening on {}:{}", (Object)(address == null ? "[all interfaces]" : InetAddressUtils.str((InetAddress)address)), (Object)this.m_snmpTrapPort);
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)this, (InetAddress)address, (int)this.m_snmpTrapPort, this.m_snmpV3Users);
            this.m_registeredForTraps = true;
            LOG.debug("init: Creating the trap session");
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                Logging.withPrefix((String)"OpenNMS.Manager", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LOG.error("init: Failed to listen on SNMP trap port, perhaps something else is already listening?", (Throwable)e);
                    }
                });
                LOG.error("init: Failed to listen on SNMP trap port, perhaps something else is already listening?", (Throwable)e);
            } else {
                LOG.error("init: Failed to initialize SNMP trap socket", (Throwable)e);
            }
            throw new UndeclaredThrowableException(e);
        }
        try {
            this.m_eventReader.open();
        }
        catch (Throwable e) {
            LOG.error("init: Failed to open event reader", e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private InetAddress getInetAddress() {
        if (this.m_snmpTrapAddress.equals("*")) {
            return null;
        }
        return InetAddressUtils.addr((String)this.m_snmpTrapAddress);
    }

    public synchronized void onStart() {
        this.m_status = 1;
        LOG.debug("start: Initializing the trapd config factory");
        this.m_status = 2;
        LOG.debug("start: Trapd ready to receive traps");
    }

    public void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LOG.debug("pause: Calling pause on processor");
        this.m_status = 6;
        LOG.debug("pause: Trapd paused");
    }

    public void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LOG.debug("resume: Calling resume on processor");
        this.m_status = 2;
        LOG.debug("resume: Trapd resumed");
    }

    public synchronized void onStop() {
        this.m_status = 3;
        LOG.debug("stop: closing communication paths.");
        try {
            if (this.m_registeredForTraps) {
                LOG.debug("stop: Closing SNMP trap session.");
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (InetAddress)this.getInetAddress(), (int)this.m_snmpTrapPort);
                LOG.debug("stop: SNMP trap session closed.");
            } else {
                LOG.debug("stop: not attemping to closing SNMP trap session--it was never opened");
            }
        }
        catch (IOException e) {
            LOG.warn("stop: exception occurred closing session", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.debug("stop: The SNMP session was already closed", (Throwable)e);
        }
        LOG.debug("stop: Stopping queue processor.");
        this.m_backlogQ.shutdown();
        this.m_eventReader.close();
        this.m_status = 4;
        LOG.debug("stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public void trapError(int error, String msg) {
        LOG.warn("Error Processing Received Trap: error = {} {}", (Object)error, (Object)(msg != null ? ", ref = " + msg : ""));
    }

    public BroadcastEventProcessor getEventReader() {
        return this.m_eventReader;
    }

    public void setEventReader(BroadcastEventProcessor eventReader) {
        this.m_eventReader = eventReader;
    }

    public ExecutorService getBacklogQ() {
        return this.m_backlogQ;
    }

    public void setBacklogQ(ExecutorService backlogQ) {
        this.m_backlogQ = backlogQ;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public long getV1TrapsReceived() {
        return TrapQueueProcessor.getV1TrapsReceived();
    }

    public long getV2cTrapsReceived() {
        return TrapQueueProcessor.getV2cTrapsReceived();
    }

    public long getV3TrapsReceived() {
        return TrapQueueProcessor.getV3TrapsReceived();
    }

    public long getTrapsDiscarded() {
        return TrapQueueProcessor.getTrapsDiscarded();
    }

    public long getTrapsErrored() {
        return TrapQueueProcessor.getTrapsErrored();
    }
}

