/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tl1AutonomousMessageProcessor
implements Tl1MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Tl1AutonomousMessageProcessor.class);
    private static final ThreadLocal<SimpleDateFormat> SDF_4DY = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> SDF_2DY = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        }
    };

    @Override
    public Tl1AutonomousMessage process(String rawMessage, int messageType) {
        StringTokenizer lineParser = new StringTokenizer(rawMessage, "\n");
        Tl1AutonomousMessage message = new Tl1AutonomousMessage(rawMessage);
        try {
            this.processHeader(lineParser, message);
            this.processId(lineParser, message);
            this.processAutoBlock(lineParser, message);
        }
        catch (IllegalStateException e) {
            return null;
        }
        return message;
    }

    private void processHeader(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundHeader = false;
        while (!foundHeader) {
            while (lineParser.hasMoreTokens() && !foundHeader) {
                String line = lineParser.nextToken();
                if (line == null || line.equals(message.getTerminator())) continue;
                try {
                    foundHeader = Tl1AutonomousMessageProcessor.parseHeader(line, message);
                }
                catch (IllegalArgumentException e) {}
            }
        }
        if (!foundHeader) {
            throw new IllegalStateException("No TL1 Header found in: " + lineParser.toString());
        }
    }

    private static boolean parseHeader(String line, Tl1AutonomousMessage message) throws IllegalArgumentException {
        StringTokenizer headerParser = new StringTokenizer(line);
        if (headerParser.countTokens() != 3) {
            throw new IllegalArgumentException("The line: " + line + " is not an Autonomous message header");
        }
        message.getHeader().setRawMessage(line);
        message.getHeader().setSid(headerParser.nextToken());
        message.setHost(message.getHeader().getSid());
        message.getHeader().setDate(headerParser.nextToken());
        message.getHeader().setTime(headerParser.nextToken());
        try {
            if (message.getHeader().getDate().matches("^[0-9]{4}")) {
                message.getHeader().setTimestamp(SDF_4DY.get().parse(message.getHeader().getDate() + " " + message.getHeader().getTime()));
            } else {
                message.getHeader().setTimestamp(SDF_2DY.get().parse(message.getHeader().getDate() + " " + message.getHeader().getTime()));
            }
            message.setTimestamp(message.getHeader().getTimestamp());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The line: " + line + ", doesn't contain date and time in the format: " + SDF_2DY.get().toLocalizedPattern() + " or " + SDF_4DY.get().toLocalizedPattern());
        }
        return true;
    }

    private void processId(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundId = false;
        while (!foundId) {
            while (lineParser.hasMoreElements() && !foundId) {
                String line = (String)lineParser.nextElement();
                if (line == null || line.equals(message.getTerminator())) continue;
                foundId = this.parseId(line, message);
            }
        }
    }

    private boolean parseId(String line, Tl1AutonomousMessage message) {
        StringTokenizer idParser = new StringTokenizer(line);
        if (idParser.countTokens() < 3) {
            throw new IllegalArgumentException("The line: " + line + " is not an Autonomouse message id.  Expected 3 or more tokens " + "and received: " + idParser.countTokens());
        }
        message.getId().setRawMessage(line);
        message.getId().setAlarmCode(idParser.nextToken());
        message.getId().setAlarmTag(idParser.nextToken());
        StringBuilder bldr = new StringBuilder();
        while (idParser.hasMoreTokens()) {
            bldr.append(idParser.nextToken());
            bldr.append(" ");
        }
        message.getId().setVerb(bldr.toString().trim());
        return true;
    }

    private void processAutoBlock(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundId = false;
        while (!foundId) {
            while (lineParser.hasMoreElements() && !foundId) {
                String line = (String)lineParser.nextElement();
                if (line == null || line.equals(message.getTerminator())) continue;
                foundId = true;
                foundId = this.parseAutoBlock(line.trim(), message);
            }
        }
    }

    private boolean parseAutoBlock(String line, Tl1AutonomousMessage message) {
        StringTokenizer codeParser;
        message.getAutoBlock().setBlock(line);
        StringTokenizer autoBlockParser = new StringTokenizer(line, ",");
        LOG.debug("parseAutoBlock: Autoblock: {}", (Object)line);
        String aidAndCode = autoBlockParser.nextToken().trim();
        LOG.debug("parseAutoBlock: aidAndCode: {}", (Object)aidAndCode);
        StringTokenizer aidParser = new StringTokenizer(aidAndCode, ":");
        message.getAutoBlock().setAid(aidParser.nextToken().substring(1));
        String ntfcncde = aidParser.nextToken().trim();
        if (ntfcncde.startsWith("NTFCNCDE=")) {
            LOG.info("NTFCNCDE appears to be of form: NTFCNCDE=<CODE>");
            codeParser = new StringTokenizer(ntfcncde, "=");
            if (codeParser.countTokens() >= 2) {
                codeParser.nextToken();
                ntfcncde = codeParser.nextToken().trim();
                LOG.debug("Determined NTFCNCDE is {}", (Object)ntfcncde);
            } else {
                LOG.warn("NTFCNCDE could not be determined from auto block: {}", (Object)ntfcncde);
            }
        } else if (ntfcncde.matches("^(CL|CR|MJ|MN|NA|NR),")) {
            LOG.info("NTFCNCDE appears to be of form: <CODE>");
            codeParser = new StringTokenizer(ntfcncde, ",");
            if (codeParser.hasMoreTokens()) {
                ntfcncde = codeParser.nextToken().trim();
                LOG.debug("Determined NTFCNCDE is {}", (Object)ntfcncde);
            } else {
                LOG.warn("NTFCNCDE could not be determined from auto block: {}", (Object)ntfcncde);
            }
        }
        message.getAutoBlock().setNtfcncde(ntfcncde);
        StringBuffer sb = new StringBuffer();
        while (autoBlockParser.hasMoreTokens()) {
            sb.append(autoBlockParser.nextToken()).append(",");
        }
        message.getAutoBlock().setAdditionalParams(sb.toString().trim());
        return true;
    }
}

