/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.syslogd.CustomSyslogParser;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuniperSyslogParser
extends SyslogParser {
    private static final Logger LOG = LoggerFactory.getLogger(JuniperSyslogParser.class);
    private static final Pattern m_juniperPattern = Pattern.compile("^<(\\d+)>\\s*(\\S\\S\\S\\s+\\d{1,2}\\s+\\d\\d:\\d\\d:\\d\\d)\\s+(\\S+)\\s+(\\S+)\\[(\\d+)\\]: (.*?)$", 8);

    protected JuniperSyslogParser(String text) {
        super(text);
    }

    public static SyslogParser getParser(String text) {
        return new JuniperSyslogParser(text);
    }

    @Override
    protected Pattern getPattern() {
        return m_juniperPattern;
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        if (!this.find()) {
            if (this.traceEnabled()) {
                LOG.trace("'{}' did not match '{}', falling back to the custom parser", (Object)m_juniperPattern, (Object)this.getText());
                SyslogParser custom = CustomSyslogParser.getParser(this.getText());
                return custom.parse();
            }
            return null;
        }
        Matcher matcher = this.getMatcher();
        SyslogMessage message = new SyslogMessage();
        try {
            int priorityField = Integer.parseInt(matcher.group(1));
            message.setFacility(SyslogFacility.getFacilityForCode(priorityField));
            message.setSeverity(SyslogSeverity.getSeverityForCode(priorityField));
        }
        catch (NumberFormatException nfe) {
            LOG.debug("Unable to parse '{}' as a PRI code.", (Object)matcher.group(1), (Object)nfe);
        }
        Date date = this.parseDate(matcher.group(2));
        if (date == null) {
            date = new Date();
        }
        message.setDate(date);
        message.setHostName(matcher.group(3));
        message.setProcessName(matcher.group(4));
        try {
            Integer pid = Integer.parseInt(matcher.group(5));
            message.setProcessId(pid);
        }
        catch (NumberFormatException nfe) {
            LOG.debug("Unable to parse '{}' as a process ID.", (Object)matcher.group(5), (Object)nfe);
        }
        message.setMessage(matcher.group(6).trim());
        return message;
    }
}

