/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.HttpResponseRange;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.pagesequence.Parameter;
import org.opennms.netmgt.config.pagesequence.SessionVariable;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.utils.DnsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class PageSequenceMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(PageSequenceMonitor.class);
    private static final int DEFAULT_SEQUENCE_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_RETRY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameterMap) {
        DefaultHttpClient client = null;
        PollStatus serviceStatus = PollStatus.unavailable((String)"Poll not completed yet");
        LinkedHashMap<String, Double> responseTimes = new LinkedHashMap<String, Double>();
        SequenceTracker tracker = new SequenceTracker(parameterMap, 0, 3000);
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            try {
                PageSequenceMonitorParameters parms = PageSequenceMonitorParameters.get(parameterMap);
                client = parms.createHttpClient();
                tracker.startAttempt();
                responseTimes.put("response-time", Double.NaN);
                parms.getPageSequence().execute(client, svc, responseTimes);
                double responseTime = tracker.elapsedTimeInMillis();
                serviceStatus = PollStatus.available();
                responseTimes.put("response-time", responseTime);
                serviceStatus.setProperties(responseTimes);
            }
            catch (PageSequenceMonitorException e) {
                serviceStatus = PollStatus.unavailable((String)e.getMessage());
                serviceStatus.setProperties(responseTimes);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid parameters to monitor", (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)("Invalid parameter to monitor: " + e.getMessage() + ".  See log for details."));
                serviceStatus.setProperties(responseTimes);
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().shutdown();
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }

    public static class PageSequenceMonitorParameters {
        public static final String KEY = PageSequenceMonitorParameters.class.getName();
        private final Map<String, Object> m_parameterMap;
        private final HttpParams m_clientParams;
        private final HttpPageSequence m_pageSequence;

        static synchronized PageSequenceMonitorParameters get(Map<String, Object> parameterMap) {
            PageSequenceMonitorParameters parms = (PageSequenceMonitorParameters)parameterMap.get(KEY);
            if (parms == null) {
                parms = new PageSequenceMonitorParameters(parameterMap);
                parameterMap.put(KEY, parms);
            }
            return parms;
        }

        PageSequenceMonitorParameters(Map<String, Object> parameterMap) {
            this.m_parameterMap = parameterMap;
            Object pageSequence = AbstractServiceMonitor.getKeyedObject(parameterMap, (String)"page-sequence", null);
            if (pageSequence == null) {
                throw new IllegalArgumentException("page-sequence must be set in monitor parameters");
            }
            if (pageSequence instanceof PageSequence) {
                pageSequence = JaxbUtils.marshal((Object)pageSequence);
            } else if (!(pageSequence instanceof String)) {
                throw new IllegalArgumentException("Unsure how to deal with Page Sequence of type " + pageSequence.getClass());
            }
            pageSequence = PropertiesUtils.substitute((String)((String)pageSequence), (Map[])new Map[]{this.m_parameterMap});
            PageSequence sequence = this.parsePageSequence((String)pageSequence);
            this.m_pageSequence = new HttpPageSequence(sequence);
            this.m_pageSequence.setParameters(this.m_parameterMap);
            this.m_clientParams = this.createClientParams();
        }

        Map<String, Object> getParameterMap() {
            return this.m_parameterMap;
        }

        HttpPageSequence getPageSequence() {
            return this.m_pageSequence;
        }

        PageSequence parsePageSequence(String sequenceString) {
            return (PageSequence)JaxbUtils.unmarshal(PageSequence.class, (String)sequenceString);
        }

        private HttpParams createClientParams() {
            BasicHttpParams clientParams = new BasicHttpParams();
            clientParams.setIntParameter("http.connection.timeout", this.getTimeout());
            clientParams.setIntParameter("http.socket.timeout", this.getTimeout());
            clientParams.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            clientParams.setBooleanParameter("http.protocol.single-cookie-header", true);
            return clientParams;
        }

        public int getRetries() {
            return AbstractServiceMonitor.getKeyedInteger(this.m_parameterMap, (String)"retry", (Integer)0);
        }

        public int getTimeout() {
            return AbstractServiceMonitor.getKeyedInteger(this.m_parameterMap, (String)"timeout", (Integer)3000);
        }

        public HttpParams getClientParams() {
            return this.m_clientParams;
        }

        DefaultHttpClient createHttpClient() {
            DefaultHttpClient client = new DefaultHttpClient(this.getClientParams());
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.getRetries(), false));
            return client;
        }
    }

    public static class HttpPage {
        private final Page m_page;
        private final HttpResponseRange m_range;
        private final Pattern m_successPattern;
        private final Pattern m_failurePattern;
        private final Pattern m_locationPattern;
        private final HttpPageSequence m_parentSequence;
        private double m_responseTime;
        private final List<NameValuePair> m_parms = new ArrayList<NameValuePair>();

        HttpPage(HttpPageSequence parent, Page page) {
            this.m_page = page;
            this.m_range = new HttpResponseRange(page.getResponseRange());
            this.m_successPattern = page.getSuccessMatch() == null ? null : Pattern.compile(page.getSuccessMatch());
            this.m_failurePattern = page.getFailureMatch() == null ? null : Pattern.compile(page.getFailureMatch());
            this.m_locationPattern = page.getLocationMatch() == null ? null : Pattern.compile(page.getLocationMatch());
            this.m_parentSequence = parent;
            for (Parameter parm : this.m_page.getParameters().toArray(new Parameter[0])) {
                this.m_parms.add((NameValuePair)new BasicNameValuePair(parm.getKey(), parm.getValue()));
            }
        }

        public String toString() {
            ToStringBuilder retval = new ToStringBuilder((Object)this);
            retval.append("page.httpVersion", (Object)this.m_page.getHttpVersion());
            retval.append("page.host", (Object)this.m_page.getHost());
            retval.append("page.requireIPv4", (Object)this.m_page.getRequireIPv4());
            retval.append("page.requireIPv6", (Object)this.m_page.getRequireIPv6());
            retval.append("page.port", (Object)this.m_page.getPort());
            retval.append("page.method", (Object)this.m_page.getMethod());
            retval.append("page.virtualHost", (Object)this.m_page.getVirtualHost());
            retval.append("page.path", (Object)this.m_page.getPath());
            retval.append("page.query", (Object)this.m_page.getQuery());
            retval.append("page.successMatch", (Object)this.m_page.getSuccessMatch());
            retval.append("page.failureMatch", (Object)this.m_page.getFailureMatch());
            retval.append("page.locationMatch", (Object)this.m_page.getLocationMatch());
            return retval.toString();
        }

        void execute(DefaultHttpClient client, MonitoredService svc, Properties sequenceProperties) {
            try {
                Matcher matcher;
                URI uri = this.getURI(svc);
                PageSequenceHttpUriRequest method = this.getMethod(uri);
                if (this.getVirtualHost(svc) != null) {
                    HttpHost host = null;
                    host = "https".equals(uri.getScheme()) && uri.getPort() == 443 ? new HttpHost(this.getVirtualHost(svc)) : ("http".equals(uri.getScheme()) && uri.getPort() == 80 ? new HttpHost(this.getVirtualHost(svc)) : new HttpHost(this.getVirtualHost(svc), uri.getPort()));
                    method.setHeader("Host", host.toHostString());
                }
                if (this.getUserAgent() != null) {
                    method.getParams().setParameter("http.useragent", (Object)this.getUserAgent());
                } else {
                    method.getParams().setParameter("http.useragent", (Object)("OpenNMS PageSequenceMonitor (Service name: " + svc.getSvcName() + ")"));
                }
                if ("https".equals(uri.getScheme()) && Boolean.parseBoolean(this.m_page.getDisableSslVerification())) {
                    SchemeRegistry registry = client.getConnectionManager().getSchemeRegistry();
                    Scheme https = registry.getScheme("https");
                    SSLSocketFactory factory = new SSLSocketFactory(SSLContext.getInstance("EmptyKeyRelaxedTrust"), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    Scheme lenient = new Scheme(https.getName(), https.getDefaultPort(), (SchemeSocketFactory)factory);
                    registry.register(lenient);
                }
                if (this.m_parms.size() > 0) {
                    method.setQueryParameters(this.expandParms(svc));
                }
                if (this.getUserInfo() != null) {
                    String userInfo = this.getUserInfo();
                    String[] streetCred = userInfo.split(":", 2);
                    if (streetCred.length == 2) {
                        client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
                    } else {
                        LOG.warn("Illegal value found for username/password HTTP credentials: {}", (Object)userInfo);
                    }
                }
                long startTime = System.nanoTime();
                CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                long endTime = System.nanoTime();
                this.m_responseTime = (double)(endTime - startTime) / 1000000.0;
                int code = response.getStatusLine().getStatusCode();
                if (!this.getRange().contains(code)) {
                    throw new PageSequenceMonitorException("response code out of range for uri:" + uri + ".  Expected " + this.getRange() + " but received " + code);
                }
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (this.getLocationPattern() != null) {
                    Header locationHeader = response.getFirstHeader("location");
                    if (locationHeader == null) {
                        LOG.debug("locationMatch was set, but no Location: header was returned at {}", (Object)uri, (Object)new Exception());
                        throw new PageSequenceMonitorException("locationMatch was set, but no Location: header was returned at " + uri);
                    }
                    Matcher matcher2 = this.getLocationPattern().matcher(locationHeader.getValue());
                    if (!matcher2.find()) {
                        LOG.debug("failed to find '{}' in Location: header at {}:\n{}", new Object[]{this.getLocationPattern(), uri, locationHeader.getValue(), new Exception()});
                        throw new PageSequenceMonitorException("failed to find '" + this.getLocationPattern() + "' in Location: header at " + uri);
                    }
                }
                if (this.getFailurePattern() != null && (matcher = this.getFailurePattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException(this.getResolvedFailureMessage(matcher));
                }
                if (this.getSuccessPattern() != null) {
                    matcher = this.getSuccessPattern().matcher(responseString);
                    if (!matcher.find()) {
                        LOG.debug("failed to find '{}' in page content at {}:\n{}", new Object[]{this.getSuccessPattern(), uri, responseString.trim(), new Exception()});
                        throw new PageSequenceMonitorException("failed to find '" + this.getSuccessPattern() + "' in page content at " + uri);
                    }
                    this.updateSequenceProperties(sequenceProperties, matcher);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new PageSequenceMonitorException("Could not find appropriate SSL context provider", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("unable to construct URL for page", e);
            }
            catch (IOException e) {
                LOG.debug("I/O Error", (Throwable)e);
                throw new PageSequenceMonitorException("I/O Error", e);
            }
        }

        private List<NameValuePair> expandParms(MonitoredService svc) {
            Properties seqProps;
            ArrayList<NameValuePair> expandedParms = new ArrayList<NameValuePair>();
            Properties svcProps = this.getServiceProperties(svc);
            if (svcProps != null) {
                LOG.debug("I have {} service properties.", (Object)svcProps.size());
            }
            if ((seqProps = this.getSequenceProperties()) != null) {
                LOG.debug("I have {} sequence properties.", (Object)seqProps.size());
            }
            for (NameValuePair nvp : this.m_parms) {
                String value = PropertiesUtils.substitute((String)nvp.getValue(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()});
                expandedParms.add((NameValuePair)new BasicNameValuePair(nvp.getName(), value));
                if (nvp.getValue().equals(value)) continue;
                LOG.debug("Expanded parm with name '{}' from '{}' to '{}'", new Object[]{nvp.getName(), nvp.getValue(), value});
            }
            return expandedParms;
        }

        private void updateSequenceProperties(Properties props, Matcher matcher) {
            for (SessionVariable varBinding : this.m_page.getSessionVariables()) {
                String vbName = varBinding.getName();
                String vbValue = matcher.group(varBinding.getMatchGroup());
                if (vbValue == null) {
                    vbValue = "";
                }
                props.put(vbName, vbValue);
                LOG.debug("Just set session variable '{}' to '{}'", (Object)vbName, (Object)vbValue);
            }
            this.setSequenceProperties(props);
        }

        private String getUserAgent() {
            return this.m_page.getUserAgent();
        }

        private String getVirtualHost(MonitoredService svc) {
            return PropertiesUtils.substitute((String)this.m_page.getVirtualHost(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()});
        }

        private URI getURI(MonitoredService svc) throws URISyntaxException {
            InetAddress address;
            Properties svcProps = this.getServiceProperties(svc);
            Properties seqProps = this.getSequenceProperties();
            String host = this.getHost(seqProps, svcProps);
            if (this.m_page.getRequireIPv4().booleanValue()) {
                try {
                    address = DnsUtils.resolveHostname(host, false);
                    if (!(address instanceof Inet4Address)) {
                        throw new UnknownHostException();
                    }
                    host = InetAddressUtils.str((InetAddress)address);
                }
                catch (UnknownHostException e) {
                    throw new PageSequenceMonitorException("failed to find IPv4 address for hostname: " + host);
                }
            }
            if (this.m_page.getRequireIPv6().booleanValue()) {
                try {
                    address = DnsUtils.resolveHostname(host, true);
                    host = "[" + InetAddressUtils.str((InetAddress)address) + "]";
                }
                catch (UnknownHostException e) {
                    throw new PageSequenceMonitorException("failed to find IPv6 address for hostname: " + host);
                }
            }
            URIBuilder ub = new URIBuilder();
            ub.setScheme(this.getScheme());
            ub.setHost(host);
            ub.setPort(this.getPort(new Properties[0]));
            ub.setPath(this.getPath(seqProps, svcProps));
            ub.setQuery(this.getQuery(seqProps, svcProps));
            ub.setFragment(this.getFragment(seqProps, svcProps));
            return ub.build();
        }

        private String getFragment(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getFragment(), (Properties[])p);
        }

        private String getQuery(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getQuery(), (Properties[])p);
        }

        private String getPath(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getPath(), (Properties[])p);
        }

        private int getPort(Properties ... p) {
            return Integer.valueOf(PropertiesUtils.substitute((String)String.valueOf(this.m_page.getPort()), (Properties[])p));
        }

        private String getHost(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getHost(), (Properties[])p);
        }

        private Properties getServiceProperties(MonitoredService svc) {
            Properties properties = new Properties();
            properties.put("ipaddr", svc.getIpAddr());
            properties.put("nodeid", (Object)svc.getNodeId());
            properties.put("nodelabel", svc.getNodeLabel());
            properties.put("svcname", svc.getSvcName());
            return properties;
        }

        private String getUserInfo() {
            return this.m_page.getUserInfo();
        }

        private String getScheme() {
            return this.m_page.getScheme();
        }

        private PageSequenceHttpUriRequest getMethod(URI uri) {
            String method = this.m_page.getMethod();
            return "GET".equalsIgnoreCase(method) ? new PageSequenceHttpGet(uri) : new PageSequenceHttpPost(uri);
        }

        private HttpResponseRange getRange() {
            return this.m_range;
        }

        private Pattern getSuccessPattern() {
            return this.m_successPattern;
        }

        private Pattern getLocationPattern() {
            return this.m_locationPattern;
        }

        private Pattern getFailurePattern() {
            return this.m_failurePattern;
        }

        private String getFailureMessage() {
            return this.m_page.getFailureMessage();
        }

        private String getResolvedFailureMessage(Matcher matcher) {
            return PropertiesUtils.substitute((String)this.getFailureMessage(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{new MatchTable(matcher)});
        }

        private Properties getSequenceProperties() {
            return this.m_parentSequence.getSequenceProperties();
        }

        private void setSequenceProperties(Properties props) {
            this.m_parentSequence.setSequenceProperties(props);
        }

        public Number getResponseTime() {
            return this.m_responseTime;
        }

        public String getDsName() {
            return this.m_page.getDsName();
        }
    }

    public static class PageSequenceHttpGet
    extends HttpGet
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpGet(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            URI uri = this.getURI();
            URI uriWithQueryString = null;
            try {
                String query = URLEncodedUtils.format(parms, (String)"UTF-8");
                URIBuilder ub = new URIBuilder(uri);
                ub.setQuery(query);
                uriWithQueryString = ub.build();
                this.setURI(uriWithQueryString);
            }
            catch (URISyntaxException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class PageSequenceHttpPost
    extends HttpPost
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpPost(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parms, "UTF-8");
                this.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                LOG.debug("Unsupported encoding", (Throwable)e);
            }
        }
    }

    public static interface PageSequenceHttpUriRequest
    extends HttpUriRequest {
        public void setQueryParameters(List<NameValuePair> var1);
    }

    public static class HttpPageSequence {
        final PageSequence m_sequence;
        final List<HttpPage> m_pages;
        Properties m_sequenceProperties;
        Map<String, Object> m_parameters = new HashMap<String, Object>();

        HttpPageSequence(PageSequence sequence) {
            this.m_sequence = sequence;
            this.m_pages = new ArrayList<HttpPage>(this.m_sequence.getPages().size());
            for (Page page : this.m_sequence.getPages().toArray(new Page[0])) {
                this.m_pages.add(new HttpPage(this, page));
            }
            this.m_sequenceProperties = new Properties();
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.m_parameters = parameters;
        }

        List<HttpPage> getPages() {
            return this.m_pages;
        }

        private void execute(DefaultHttpClient client, MonitoredService svc, Map<String, Number> responseTimes) {
            this.clearSequenceProperties();
            for (HttpPage page : this.getPages()) {
                if (page.getDsName() == null) continue;
                responseTimes.put(page.getDsName(), Double.NaN);
            }
            for (HttpPage page : this.getPages()) {
                LOG.debug("Executing HttpPage: {}", (Object)page.toString());
                page.execute(client, svc, this.m_sequenceProperties);
                if (page.getDsName() == null) continue;
                LOG.debug("Recording response time {} for ds {}", (Object)page.getResponseTime(), (Object)page.getDsName());
                responseTimes.put(page.getDsName(), page.getResponseTime());
            }
        }

        protected Properties getSequenceProperties() {
            return this.m_sequenceProperties;
        }

        protected void setSequenceProperties(Properties newProps) {
            this.m_sequenceProperties = newProps;
        }

        protected void clearSequenceProperties() {
            this.m_sequenceProperties.clear();
        }
    }

    public static class PageSequenceMonitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1346757238604080088L;

        public PageSequenceMonitorException(String message) {
            super(message);
        }

        public PageSequenceMonitorException(Throwable cause) {
            super(cause);
        }

        public PageSequenceMonitorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class SequenceTracker {
        TimeoutTracker m_tracker;

        public SequenceTracker(Map<String, Object> parameterMap, int defaultSequenceRetry, int defaultTimeout) {
            HashMap<String, Constable> parameters = new HashMap<String, Constable>();
            parameters.put("retry", AbstractServiceMonitor.getKeyedInteger(parameterMap, (String)"sequence-retry", (Integer)defaultSequenceRetry));
            parameters.put("timeout", AbstractServiceMonitor.getKeyedInteger(parameterMap, (String)"timeout", (Integer)defaultTimeout));
            parameters.put("strict-timeout", AbstractServiceMonitor.getKeyedBoolean(parameterMap, (String)"strict-timeout", (Boolean)false));
            this.m_tracker = new TimeoutTracker(parameters, defaultSequenceRetry, defaultTimeout);
        }

        public void reset() {
            this.m_tracker.reset();
        }

        public boolean shouldRetry() {
            return this.m_tracker.shouldRetry();
        }

        public void nextAttempt() {
            this.m_tracker.nextAttempt();
        }

        public void startAttempt() {
            this.m_tracker.startAttempt();
        }

        public double elapsedTimeInMillis() {
            return this.m_tracker.elapsedTimeInMillis();
        }
    }
}

