/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.jmx;

import java.lang.reflect.UndeclaredThrowableException;
import org.opennms.netmgt.config.DestinationPathFactory;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationCommandFactory;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.hibernate.NodeDaoHibernate;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.notifd.jmx.NotifdMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notifd
extends AbstractServiceDaemon
implements NotifdMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Notifd.class);
    private static String LOG4J_CATEGORY = "notifd";

    public Notifd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        EventIpcManagerFactory.init();
        try {
            NotifdConfigFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init NotifdConfigFactory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init NotificationFactory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            GroupFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init group factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            UserFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init user factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            DestinationPathFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init destination path factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            NotificationCommandFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init notification command factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            PollOutagesConfigFactory.init();
        }
        catch (Throwable t) {
            LOG.error("start: Failed to init poll outage config factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        this.getNotifd().setEventManager(EventIpcManagerFactory.getIpcManager());
        this.getNotifd().setConfigManager((NotifdConfigManager)NotifdConfigFactory.getInstance());
        this.getNotifd().setNotificationManager((NotificationManager)NotificationFactory.getInstance());
        this.getNotifd().setGroupManager(GroupFactory.getInstance());
        this.getNotifd().setUserManager(UserFactory.getInstance());
        this.getNotifd().setDestinationPathManager((DestinationPathManager)DestinationPathFactory.getInstance());
        this.getNotifd().setNotificationCommandManager((NotificationCommandManager)NotificationCommandFactory.getInstance());
        this.getNotifd().setPollOutagesConfigManager((PollOutagesConfigManager)PollOutagesConfigFactory.getInstance());
        this.getNotifd().setNodeDao((NodeDao)new NodeDaoHibernate());
        this.getNotifd().init();
    }

    private org.opennms.netmgt.notifd.Notifd getNotifd() {
        return org.opennms.netmgt.notifd.Notifd.getInstance();
    }

    protected void onStart() {
        this.getNotifd().start();
    }

    protected void onStop() {
        this.getNotifd().stop();
    }

    public int getStatus() {
        return this.getNotifd().getStatus();
    }

    @Override
    public long getNotificationTasksQueued() {
        return this.getNotifd().getNotificationManager().getNotificationTasksQueued();
    }

    @Override
    public long getBinaryNoticesAttempted() {
        return this.getNotifd().getNotificationManager().getBinaryNoticesAttempted();
    }

    @Override
    public long getJavaNoticesAttempted() {
        return this.getNotifd().getNotificationManager().getJavaNoticesAttempted();
    }

    @Override
    public long getBinaryNoticesSucceeded() {
        return this.getNotifd().getNotificationManager().getBinaryNoticesSucceeded();
    }

    @Override
    public long getJavaNoticesSucceeded() {
        return this.getNotifd().getNotificationManager().getJavaNoticesSucceeded();
    }

    @Override
    public long getBinaryNoticesFailed() {
        return this.getNotifd().getNotificationManager().getBinaryNoticesFailed();
    }

    @Override
    public long getJavaNoticesFailed() {
        return this.getNotifd().getNotificationManager().getJavaNoticesFailed();
    }

    @Override
    public long getBinaryNoticesInterrupted() {
        return this.getNotifd().getNotificationManager().getBinaryNoticesInterrupted();
    }

    @Override
    public long getJavaNoticesInterrupted() {
        return this.getNotifd().getNotificationManager().getJavaNoticesInterrupted();
    }

    @Override
    public long getUnknownNoticesInterrupted() {
        return this.getNotifd().getNotificationManager().getUnknownNoticesInterrupted();
    }
}

