/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.topology.AtInterface;
import org.opennms.netmgt.model.topology.BridgeTopology;
import org.opennms.netmgt.model.topology.CdpInterface;
import org.opennms.netmgt.model.topology.IsisISAdjInterface;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.model.topology.LldpRemInterface;
import org.opennms.netmgt.model.topology.NodeToNodeLink;
import org.opennms.netmgt.model.topology.OspfNbrInterface;
import org.opennms.netmgt.model.topology.RouterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryLink
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryLink.class);
    private String packageName;
    private List<NodeToNodeLink> m_links = new ArrayList<NodeToNodeLink>();
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean discoveryUsingLldp = true;
    private boolean discoveryUsingOspf = true;
    private boolean discoveryUsingIsis = true;
    private boolean discoveryUsingWifi = true;
    private boolean suspendCollection = false;
    private boolean runned = false;
    private Scheduler m_scheduler;
    private long m_interval = 1800000L;
    private long discovery_delay = 300000L;
    private long m_initial_sleep_time = 600000L;
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    private void sendSuspendedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoverySuspended", "Linkd"));
    }

    private void sendStartedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoveryStarted", "Linkd"));
    }

    private void sendCompletedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoveryCompleted", "Linkd"));
    }

    private void sendEvent(EventBuilder builder) {
        builder.addParam("runnable", "discoveryLink/" + this.getPackageName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }

    @Override
    public void run() {
        this.runned = true;
        LOG.info("run: discoveryUsingRoutes={} on package \"{}\"", (Object)this.discoveryUsingRoutes, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingOspf={} on package \"{}\"", (Object)this.discoveryUsingOspf, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingIsis={} on package \"{}\"", (Object)this.discoveryUsingIsis, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingWifi={} on package \"{}\"", (Object)this.discoveryUsingWifi, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingBridge={} on package \"{}\"", (Object)this.discoveryUsingBridge, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingCdp={} on package \"{}\"", (Object)this.discoveryUsingCdp, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingLldp={} on package \"{}\"", (Object)this.discoveryUsingLldp, (Object)this.getPackageName());
        if (this.suspendCollection) {
            this.sendSuspendedEvent();
            LOG.warn("run: linkd collections are suspended!");
        } else {
            this.sendStartedEvent();
            this.discoverLinks();
            this.sendCompletedEvent();
        }
    }

    private void discoverLinks() {
        Collection<LinkableNode> linkableNodes = this.m_linkd.getLinkableNodesOnPackage(this.getPackageName());
        LOG.info("run: Found {} LinkableNodes  on package \"{}\"", (Object)linkableNodes.size(), (Object)this.getPackageName());
        if (this.discoveryUsingRoutes) {
            this.getLinksFromRouteTable(linkableNodes);
        }
        if (this.discoveryUsingOspf) {
            this.getLinksFromOspf(linkableNodes);
        }
        if (this.discoveryUsingIsis) {
            this.getLinksFromIsis(linkableNodes);
        }
        if (this.discoveryUsingWifi) {
            this.getLinksFromWifi(linkableNodes);
        }
        if (this.discoveryUsingBridge) {
            this.getLinksFromBridge(linkableNodes);
        }
        if (this.discoveryUsingLldp) {
            this.getLinksFromLldp(linkableNodes);
        }
        if (this.discoveryUsingCdp) {
            this.getLinksFromCdp(linkableNodes);
        }
        this.getLinkd().clearPackageSavedData(this.getPackageName());
        this.m_linkd.updateDiscoveryLinkCollection(this);
        this.m_links.clear();
        this.runned = true;
    }

    private void getLinksFromWifi(Collection<LinkableNode> linkableNodes) {
        List<String> macParsed = new ArrayList<String>();
        for (LinkableNode curNode : linkableNodes) {
            if (curNode.getWifiMacIfIndexMap().isEmpty()) continue;
            int curNodeId = curNode.getNodeId();
            LOG.info("getLinksFromWifi: parsing wifi node with ID {} and {} wifi interfaces ", (Object)curNodeId, (Object)curNode.getWifiMacIfIndexMap().size());
            for (Map.Entry wifi : curNode.getWifiMacIfIndexMap().entrySet()) {
                LOG.debug("getLinksFromWifi: parsing wifi node with ID {} wifi interface {} macs {} ", new Object[]{curNodeId, wifi.getKey(), wifi.getValue()});
                macParsed = this.addLinks(macParsed, (Set)wifi.getValue(), curNodeId, (Integer)wifi.getKey(), DataLinkInterface.DiscoveryProtocol.wifi);
            }
        }
    }

    private void getLinksFromBridge(Collection<LinkableNode> linkableNodes) {
        Integer curNodeId;
        LOG.info("getLinksFromBridge: finding links using Bridge Discovery");
        BridgeTopology topology = new BridgeTopology();
        ArrayList<LinkableNode> bridgeNodes = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : linkableNodes) {
            if (!curNode.isBridgeNode()) continue;
            LOG.debug("getLinksFromBridge: found LinkableNode nodeid/sysoid/ipaddress {}/{}/{}", new Object[]{curNode.getNodeId(), curNode.getSysoid(), InetAddressUtils.str((InetAddress)curNode.getSnmpPrimaryIpAddr())});
            bridgeNodes.add(curNode);
            for (Map.Entry entry : curNode.getMacIdentifiers().entrySet()) {
                LOG.info("getLinksFromBridge: parsing mac identifier {} with associated ifindex {}.", entry.getValue(), entry.getKey());
                if (entry.getValue() == null || ((String)entry.getValue()).equals("")) continue;
                int bridgePort = curNode.getBridgePortFromIfindex(((Integer)entry.getKey()).intValue());
                if (bridgePort == -1) {
                    LOG.info("getLinksFromBridge: invalid bridge port association found. Skipping mac identifier {}.", entry.getValue());
                    continue;
                }
                if (!this.m_linkd.getAtInterfaces(this.getPackageName(), (String)entry.getValue()).isEmpty()) {
                    LOG.info("getLinksFromBridge: the mac was is associated to ip address. Skipping mac identifier {}.", entry.getValue());
                    continue;
                }
                topology.addBridgeAssociatedMac(Integer.valueOf(curNode.getNodeId()), (Integer)entry.getKey(), (Set)curNode.getBridgeForwardingTable().get(bridgePort), (String)entry.getValue());
            }
        }
        for (LinkableNode curNode : bridgeNodes) {
            InetAddress curIpAddr = curNode.getSnmpPrimaryIpAddr();
            curNodeId = curNode.getNodeId();
            if (curNode.getStpInterfaces().size() == 0) {
                LOG.info("getLinksFromBridge: no spanning tree info found on bridge with nodeid {} and ip address {}", (Object)curNodeId, (Object)InetAddressUtils.str((InetAddress)curIpAddr));
            }
            for (Map.Entry me : curNode.getStpInterfaces().entrySet()) {
                Integer vlan = (Integer)me.getKey();
                String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                LOG.info("getLinksFromBridge: parsing Spanning Tree Protocol Data:  nodeid {}, bridge identifier {}, VLAN {} with {} stp ports", new Object[]{curNodeId, curBaseBridgeAddress, vlan, ((List)curNode.getStpInterfaces().get(vlan)).size()});
                String designatedRoot = null;
                if (!curNode.hasStpRoot(vlan)) {
                    LOG.info("getLinksFromBridge: bridge identifier {}, VLAN {}: stp designated root bridge identifier not found. Skipping.", (Object)curBaseBridgeAddress, (Object)vlan);
                    continue;
                }
                designatedRoot = curNode.getStpRoot(vlan);
                if (designatedRoot == null || designatedRoot.equals("0000000000000000")) {
                    LOG.warn("getLinksFromBridge: bridge identifier {}, VLAN {}: stp designated root {} is invalid. Skipping: {}", new Object[]{curBaseBridgeAddress, vlan, designatedRoot});
                    continue;
                }
                if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                    LOG.info("getLinksFromBridge: bridge identifier {}, VLAN {}: stp designated root {} is the bridge itself. Skipping.", new Object[]{curBaseBridgeAddress, vlan, designatedRoot});
                    continue;
                }
                LOG.info("getLinksFromBridge: bridge identifier {}, VLAN {}: stp designated root {} is another bridge. {} Parsing stp interfaces.", new Object[]{curBaseBridgeAddress, vlan, designatedRoot});
                for (OnmsStpInterface stpIface : (List)me.getValue()) {
                    int stpbridgeport = stpIface.getBridgePort();
                    String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                    String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                    LOG.info("getLinksFromBridge: bridge identifier {}, VLAN {}: parsing bridge port {} with stp designated bridge {} and stp designated port {}", new Object[]{curBaseBridgeAddress, vlan, stpbridgeport, stpPortDesignatedBridge, stpPortDesignatedPort});
                    if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                        LOG.warn("getLinksFromBridge: bridge identifier {}, VLAN {}: designated bridge is invalid, skipping: {}", new Object[]{curBaseBridgeAddress, vlan, stpPortDesignatedBridge});
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                        LOG.info("getLinksFromBridge: bridge identifier {}, VLAN {}: designated bridge for port {} is bridge itself, skipping", new Object[]{curBaseBridgeAddress, vlan, stpbridgeport});
                        continue;
                    }
                    if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                        LOG.warn("getLinksFromBridge: bridge identifier {}, VLAN {}: designated port is invalid: {}. skipping", new Object[]{curBaseBridgeAddress, vlan, stpPortDesignatedPort});
                        continue;
                    }
                    int designatedbridgeport = 0x1FFF & Integer.parseInt(stpPortDesignatedPort, 16);
                    LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(linkableNodes, stpPortDesignatedBridge.substring(4));
                    if (designatedNode == null) {
                        LOG.debug("getLinksFromBridge: bridge identifier {}, VLAN {}: no nodeid found for stp designated bridge address {}. Nothing to save.", new Object[]{curBaseBridgeAddress, vlan, stpPortDesignatedBridge});
                        continue;
                    }
                    topology.parseSTPEntry(curNodeId, Integer.valueOf(stpbridgeport), curNode.getBridgeForwadingTableOnBridgePort(stpbridgeport), Integer.valueOf(designatedNode.getNodeId()), Integer.valueOf(designatedbridgeport), designatedNode.getBridgeForwadingTableOnBridgePort(designatedbridgeport));
                }
            }
        }
        for (LinkableNode bridgeNode : bridgeNodes) {
            topology.parseBFT(Integer.valueOf(bridgeNode.getNodeId()), bridgeNode.getBridgeForwardingTable());
        }
        List<String> macParsed = new ArrayList<String>();
        for (BridgeTopology.BridgeTopologyLink link : topology.getTopology()) {
            curNodeId = link.getBridgeTopologyPort().getNodeid();
            Integer curIfIndex = this.getIfIndexFromNodeidBridgePort(linkableNodes, curNodeId, link.getBridgeTopologyPort().getBridgePort());
            macParsed = this.addLinks(macParsed, link.getMacs(), curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
            if (link.getDesignateBridgePort() == null) continue;
            Integer endNodeId = link.getDesignateBridgePort().getNodeid();
            Integer endIfIndex = this.getIfIndexFromNodeidBridgePort(linkableNodes, endNodeId, link.getDesignateBridgePort().getBridgePort());
            NodeToNodeLink lk = new NodeToNodeLink(curNodeId.intValue(), curIfIndex.intValue(), DataLinkInterface.DiscoveryProtocol.bridge);
            lk.setNodeparentid(endNodeId.intValue());
            lk.setParentifindex(endIfIndex.intValue());
            this.addNodetoNodeLink(lk);
            LOG.info("getLinksFromBridge: saving bridge link: {}", (Object)lk.toString());
        }
        LOG.info("getLinksFromBridge: done finding links using Bridge Discovery");
    }

    private Integer getIfIndexFromNodeidBridgePort(Collection<LinkableNode> linkableNodes, Integer nodeid, Integer bridgeport) {
        for (LinkableNode node : linkableNodes) {
            if (node.getNodeId() != nodeid.intValue()) continue;
            return node.getIfindexFromBridgePort(bridgeport.intValue());
        }
        return -1;
    }

    private void getLinksFromRouteTable(Collection<LinkableNode> linkableNodes) {
        LOG.info("getLinksFromRouteTable: adding links using Ipv4 Routing Table");
        int i = 0;
        for (LinkableNode linkableNode : linkableNodes) {
            if (!linkableNode.hasRouteInterfaces()) continue;
            int curNodeId = linkableNode.getNodeId();
            InetAddress curIpAddr = linkableNode.getSnmpPrimaryIpAddr();
            LOG.info("getLinksFromRouteTable: parsing router node with ID {} IP address {} and {} router interfaces", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), linkableNode.getRouteInterfaces().size()});
            for (RouterInterface routeIface : linkableNode.getRouteInterfaces()) {
                LOG.debug("getLinksFromRouteTable: parsing RouterInterface: {}", (Object)routeIface.toString());
                NodeToNodeLink lk = new NodeToNodeLink(curNodeId, routeIface.getIfindex(), DataLinkInterface.DiscoveryProtocol.iproute);
                lk.setNodeparentid(routeIface.getNextHopNodeid());
                lk.setParentifindex(routeIface.getNextHopIfindex());
                LOG.info("getLinksFromRouteTable: saving route link: {}", (Object)lk.toString());
                this.addNodetoNodeLink(lk);
                ++i;
            }
            LOG.info("getLinksFromRouteTable: done parsing router node with ID {} IP address {} and {} router interfaces", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), linkableNode.getRouteInterfaces().size()});
        }
        LOG.info("getLinksFromRouteTable: done finding links using Ipv4 Routing Table.Found links # {}.", (Object)i);
    }

    private void getLinksFromCdp(Collection<LinkableNode> linkableNodes) {
        LOG.info("getLinksFromCdp: adding links using Cisco Discovery Protocol");
        int i = 0;
        HashMap<String, LinkableNode> cdpNodes = new HashMap<String, LinkableNode>();
        for (LinkableNode linkableNode : linkableNodes) {
            if (!linkableNode.hasCdpInterfaces()) continue;
            LOG.debug("getLinksFromCdp: adding to CDP node list: node with nodeid/#cdpinterfaces {}/#{}", (Object)linkableNode.getNodeId(), (Object)linkableNode.getCdpInterfaces().size());
            cdpNodes.put(linkableNode.getCdpDeviceId(), linkableNode);
        }
        LOG.info("getLinksFromCdp: found # {} nodes using Cisco Discovery Protocol", (Object)cdpNodes.size());
        for (LinkableNode linknode1 : cdpNodes.values()) {
            LOG.info("getLinksFromCdp: parsing cdp device {} with cdpDeviceId {} using Cisco Discovery Protocol", (Object)linknode1.getNodeId(), (Object)linknode1.getCdpDeviceId());
            for (CdpInterface cdpiface1 : linknode1.getCdpInterfaces()) {
                if (cdpiface1 == null) {
                    LOG.warn("getLinksFromCdp: cdp interface null found on target device node {} for cdpTargetDeviceId {} ", (Object)linknode1.getNodeId());
                    continue;
                }
                LOG.info("getLinksFromCdp: parsing cdpInterface {} ", (Object)cdpiface1);
                if (cdpiface1.getCdpTargetDeviceId() != null) {
                    LinkableNode linknode2 = (LinkableNode)cdpNodes.get(cdpiface1.getCdpTargetDeviceId());
                    if (linknode2 == null) {
                        LOG.info("getLinksFromCdp: no cdpdevice found for cdpDeviceId {} ", (Object)cdpiface1.getCdpTargetDeviceId());
                        continue;
                    }
                    if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                    LOG.info("getLinksFromCdp: found node {} for cdpTargetDeviceId {} ", (Object)linknode2.getNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                    for (CdpInterface cdpiface2 : linknode2.getCdpInterfaces()) {
                        if (cdpiface2 == null) {
                            LOG.warn("getLinksFromCdp: cdp interface null found on target device node {} for cdpTargetDeviceId {} ", (Object)linknode2.getNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                            continue;
                        }
                        LOG.info("getLinksFromCdp: parsing target cdpInterface {} ", (Object)cdpiface2);
                        if (cdpiface2.getCdpTargetDeviceId() == null || !cdpiface2.getCdpTargetDeviceId().equals(linknode1.getCdpDeviceId()) || (cdpiface1.getCdpIfName() == null || !cdpiface1.getCdpIfName().equals(cdpiface2.getCdpTargetIfName())) && (cdpiface2.getCdpIfName() == null || !cdpiface2.getCdpIfName().equals(cdpiface1.getCdpTargetIfName()))) continue;
                        NodeToNodeLink cdpLink = new NodeToNodeLink(linknode2.getNodeId(), cdpiface2.getCdpIfIndex(), DataLinkInterface.DiscoveryProtocol.cdp);
                        cdpLink.setNodeparentid(linknode1.getNodeId());
                        cdpLink.setParentifindex(cdpiface1.getCdpIfIndex());
                        this.addNodetoNodeLink(cdpLink);
                        ++i;
                    }
                    continue;
                }
                if (cdpiface1.getCdpTargetNodeId() == null) continue;
                LOG.info("getLinksFromCdp: cdpdevice found no snmp target node {} for cdpTargetDeviceId {} ", (Object)cdpiface1.getCdpTargetNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                NodeToNodeLink link = new NodeToNodeLink(cdpiface1.getCdpTargetNodeId().intValue(), -1, DataLinkInterface.DiscoveryProtocol.cdp);
                link.setNodeparentid(linknode1.getNodeId());
                link.setParentifindex(cdpiface1.getCdpIfIndex());
                this.addNodetoNodeLink(link);
                ++i;
            }
        }
        LOG.info("getLinksFromIsis: done CDP. Found links # {}.", (Object)i);
    }

    private void getLinksFromIsis(Collection<LinkableNode> linkableNodes) {
        LOG.info("getLinksFromIsis: adding links using ISO IS-IS Routing Protocol");
        ArrayList<LinkableNode> m_isisNodes = new ArrayList<LinkableNode>();
        for (LinkableNode linkableNode : linkableNodes) {
            if (linkableNode.getIsisSysId() == null) continue;
            LOG.debug("getLinksFromIsis: adding to isis node list: node with nodeid/isisSysId/#isisinterface {}/{}/#{}", new Object[]{linkableNode.getNodeId(), linkableNode.getIsisSysId(), linkableNode.getIsisInterfaces().size()});
            m_isisNodes.add(linkableNode);
        }
        int i = 0;
        for (LinkableNode linknode1 : m_isisNodes) {
            for (LinkableNode linknode2 : m_isisNodes) {
                if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                for (NodeToNodeLink isisLink : this.getIsisLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(isisLink);
                    ++i;
                }
            }
        }
        LOG.info("getLinksFromIsis: done IS-IS. Found links # {}.", (Object)i);
    }

    private List<NodeToNodeLink> getIsisLink(LinkableNode linknode1, LinkableNode linknode2) {
        LOG.info("getIsisLink: finding IS-IS links between node with id {} and node with id {}.", (Object)linknode1.getNodeId(), (Object)linknode2.getNodeId());
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (IsisISAdjInterface isis1 : linknode1.getIsisInterfaces()) {
            for (IsisISAdjInterface isis2 : linknode2.getIsisInterfaces()) {
                LOG.debug("getIsisLink: first IS-IS element: isisSysId {} isisISAdj {}.", (Object)linknode1.getIsisSysId(), (Object)isis1);
                LOG.debug("getIsisLink: second IS-IS element: isisSysId {} isisISAdj {}.", (Object)linknode2.getIsisSysId(), (Object)isis2);
                if (!isis1.getIsisISAdjNeighSysId().equals(linknode2.getIsisSysId()) || !isis2.getIsisISAdjNeighSysId().equals(linknode1.getIsisSysId()) || isis1.getIsisISAdjIndex().intValue() != isis2.getIsisISAdjIndex().intValue()) continue;
                NodeToNodeLink link = new NodeToNodeLink(linknode1.getNodeId(), isis1.getIsisLocalIfIndex().intValue(), DataLinkInterface.DiscoveryProtocol.isis);
                link.setNodeparentid(linknode2.getNodeId());
                link.setParentifindex(isis2.getIsisLocalIfIndex().intValue());
                links.add(link);
            }
        }
        return links;
    }

    private void getLinksFromOspf(Collection<LinkableNode> linkableNodes) {
        LOG.info("getLinksFromOspf: adding links using Open Short Path First Protocol");
        ArrayList<LinkableNode> ospfNodes = new ArrayList<LinkableNode>();
        for (LinkableNode linkableNode : linkableNodes) {
            if (linkableNode.getOspfRouterId() == null || linkableNode.getOspfinterfaces() == null) continue;
            LOG.debug("getLinksFromOspf: adding to ospf node list: node with nodeid/ospfrouterid/#ospfinterface {}/{}/#{}", new Object[]{linkableNode.getNodeId(), InetAddressUtils.str((InetAddress)linkableNode.getOspfRouterId()), linkableNode.getOspfinterfaces().size()});
            ospfNodes.add(linkableNode);
        }
        int i = 0;
        for (LinkableNode linknode1 : ospfNodes) {
            for (LinkableNode linknode2 : ospfNodes) {
                if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                for (NodeToNodeLink ospfLink : this.getOspfLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(ospfLink);
                    ++i;
                }
            }
        }
        LOG.info("getLinksFromOspf: done OSPF. Found links # {}.", (Object)i);
    }

    private List<NodeToNodeLink> getOspfLink(LinkableNode linknode1, LinkableNode linknode2) {
        LOG.info("getLinksFromOspf: finding OSPF links between node with id {} and node with id {}.", (Object)linknode1.getNodeId(), (Object)linknode2.getNodeId());
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (OspfNbrInterface ospf : linknode1.getOspfinterfaces()) {
            for (OspfNbrInterface ospf2 : linknode2.getOspfinterfaces()) {
                if (!ospf.getOspfNbrRouterId().equals(linknode2.getOspfRouterId()) || ospf.getOspfNbrNodeId() != linknode2.getNodeId() || !ospf2.getOspfNbrRouterId().equals(linknode1.getOspfRouterId()) || ospf2.getOspfNbrNodeId() != linknode1.getNodeId() || !this.getSubnetAddress(ospf).equals(this.getSubnetAddress(ospf2))) continue;
                NodeToNodeLink link = new NodeToNodeLink(ospf.getOspfNbrNodeId(), ospf.getOspfNbrIfIndex(), DataLinkInterface.DiscoveryProtocol.ospf);
                link.setNodeparentid(ospf2.getOspfNbrNodeId());
                link.setParentifindex(ospf2.getOspfNbrIfIndex());
                links.add(link);
            }
        }
        return links;
    }

    protected InetAddress getSubnetAddress(OspfNbrInterface ospfinterface) {
        if (ospfinterface.getOspfNbrIpAddr() != null && ospfinterface.getOspfNbrNetMask() != null) {
            byte[] ip = ospfinterface.getOspfNbrIpAddr().getAddress();
            byte[] nm = ospfinterface.getOspfNbrNetMask().getAddress();
            try {
                return InetAddress.getByAddress(new byte[]{(byte)(ip[0] & nm[0]), (byte)(ip[1] & nm[1]), (byte)(ip[2] & nm[2]), (byte)(ip[3] & nm[3])});
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void getLinksFromLldp(Collection<LinkableNode> linkableNodes) {
        LOG.info("getLinksFromLldp: adding links using Layer Link Discovery Protocol");
        ArrayList<LinkableNode> lldpNodes = new ArrayList<LinkableNode>();
        for (LinkableNode linkableNode : linkableNodes) {
            if (linkableNode.getLldpChassisId() == null || linkableNode.getLldpChassisIdSubtype() == null) continue;
            LOG.debug("getLinksFromLldp: adding to lldp node list: node with nodeid/sysname/chassisid {}/{}/{}", new Object[]{linkableNode.getNodeId(), linkableNode.getLldpSysname(), linkableNode.getLldpChassisId()});
            lldpNodes.add(linkableNode);
        }
        int i = 0;
        for (LinkableNode linknode1 : lldpNodes) {
            for (LldpRemInterface lldpremiface : linknode1.getLldpRemInterfaces()) {
                LOG.debug("getLinksFromLldp: found LLDP interface {}", (Object)lldpremiface.toString());
                NodeToNodeLink link = new NodeToNodeLink(lldpremiface.getLldpRemNodeid().intValue(), lldpremiface.getLldpRemIfIndex().intValue(), DataLinkInterface.DiscoveryProtocol.lldp);
                link.setNodeparentid(linknode1.getNodeId());
                link.setParentifindex(lldpremiface.getLldpLocIfIndex().intValue());
                this.addNodetoNodeLink(link);
                ++i;
            }
        }
        LOG.info("getLinksFromLldp: done LLDP. Found links # {}.", (Object)i);
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(Collection<LinkableNode> linkableNodes, String macAddress) {
        for (LinkableNode curNode : linkableNodes) {
            if (!curNode.isBridgeNode() || !curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.schedule(this.m_interval, this);
        } else {
            this.m_scheduler.schedule(this.discovery_delay + this.m_initial_sleep_time, this);
        }
    }

    public long getInitialSleepTime() {
        return this.m_initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.m_initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryDelay() {
        return this.discovery_delay;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public long getInterval() {
        return this.m_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_delay = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.m_links.toArray(new NodeToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("unschedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.m_interval);
        } else {
            this.m_scheduler.unschedule(this, this.m_initial_sleep_time + this.discovery_delay);
        }
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            LOG.warn("addNodetoNodeLink: node link is null.");
            return;
        }
        for (NodeToNodeLink curNnLink : this.m_links) {
            if (!curNnLink.equals((Object)nnlink)) continue;
            LOG.info("addNodetoNodeLink: link {} exists, not adding", (Object)nnlink.toString());
            return;
        }
        if (nnlink.getNodeId() == nnlink.getNodeparentid()) {
            LOG.warn("addNodetoNodeLink: link {} is on the same node, not adding", (Object)nnlink.toString());
            return;
        }
        LOG.info("addNodetoNodeLink: adding link {}", (Object)nnlink.toString());
        this.m_links.add(nnlink);
    }

    private List<String> addLinks(List<String> macParsed, Set<String> macs, int nodeid, int ifindex, DataLinkInterface.DiscoveryProtocol proto) {
        if (macs == null || macs.isEmpty()) {
            LOG.debug("addLinks: MAC address list on link is empty.");
        } else {
            for (String curMacAddress : macs) {
                if (macParsed.contains(curMacAddress)) {
                    LOG.warn("addLinks: MAC address {} just found on other bridge port! Skipping...", (Object)curMacAddress);
                    continue;
                }
                if (curMacAddress.indexOf("00000c07ac") == 0 || curMacAddress.indexOf("00000c9ff") == 0) {
                    LOG.warn("addLinks: MAC address {} is excluded from discovery package! Skipping...", (Object)curMacAddress);
                    continue;
                }
                List<AtInterface> ats = this.m_linkd.getAtInterfaces(this.getPackageName(), curMacAddress);
                if (!ats.isEmpty()) {
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeid().intValue(), at.getIfIndex().intValue(), proto);
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                }
                macParsed.add(curMacAddress);
            }
        }
        return macParsed;
    }

    public boolean equals(Object r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(((DiscoveryLink)r).getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable DiscoveryLink  package=" + this.getPackageName() + " sleep=" + this.getInitialSleepTime() + " discovery=" + this.getDiscoveryDelay() + " interval=" + this.getInterval() + " discoveryUsingBridge=" + this.discoveryUsingBridge() + " discoveryUsingCdp=" + this.discoveryUsingCdp() + " discoveryUsingRoutes=" + this.discoveryUsingRoutes() + " discoveryUsingLldp=" + this.discoveryUsingLldp() + " discoveryUsingOspf=" + this.discoveryUsingOspf() + " discoveryUsingIsis=" + this.discoveryUsingIsis() + " discoveryUsingWifi=" + this.discoveryUsingWifi();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingOspf() {
        return this.discoveryUsingOspf;
    }

    public void setDiscoveryUsingOspf(boolean discoveryUsingOspf) {
        this.discoveryUsingOspf = discoveryUsingOspf;
    }

    public boolean discoveryUsingIsis() {
        return this.discoveryUsingIsis;
    }

    public void setDiscoveryUsingIsIs(boolean discoveryUsingIsIs) {
        this.discoveryUsingIsis = discoveryUsingIsIs;
    }

    public boolean discoveryUsingLldp() {
        return this.discoveryUsingLldp;
    }

    public void setDiscoveryUsingLldp(boolean discoveryUsingLldp) {
        this.discoveryUsingLldp = discoveryUsingLldp;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingWifi() {
        return this.discoveryUsingWifi;
    }

    public void setDiscoveryUsingWifi(boolean discoveryUsingWifi) {
        this.discoveryUsingWifi = discoveryUsingWifi;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

