/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventUtilJdbcImpl
extends AbstractEventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtilJdbcImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeLabel(long nodeId) throws SQLException {
        String nodeLabel = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                stmt = dbConn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
                if (rs.next()) {
                    nodeLabel = rs.getString("nodelabel");
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable t) {}
            }
        }
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIfAlias(long nodeId, String ipaddr) throws SQLException {
        String ifAlias = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                DbSnmpInterfaceEntry snmpif;
                dbConn = DataSourceFactory.getInstance().getConnection();
                DbIpInterfaceEntry ipif = DbIpInterfaceEntry.get(dbConn, nodeId, InetAddressUtils.getInetAddress((String)ipaddr));
                if (ipif != null && (snmpif = DbSnmpInterfaceEntry.get(dbConn, nodeId, ipif.getIfIndex())) != null) {
                    ifAlias = snmpif.getAlias();
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable t) {}
            }
        }
        return ifAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getAssetFieldValue(String parm, long nodeId) {
        String retParmVal = null;
        int end = parm.lastIndexOf("]");
        String assetField = parm.substring(6, end);
        Connection dbConn = null;
        try {
            Statement stmt = null;
            dbConn = DataSourceFactory.getInstance().getConnection();
            stmt = dbConn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT " + assetField + " FROM assets WHERE nodeid=" + String.valueOf(nodeId));
            if (rs.next()) {
                retParmVal = rs.getString(assetField);
            }
            if (stmt == null) return retParmVal;
            try {
                stmt.close();
                return retParmVal;
            }
            catch (Throwable e) {}
            return retParmVal;
            catch (SQLException sqlE) {
                if (stmt == null) return retParmVal;
                try {
                    stmt.close();
                    return retParmVal;
                }
                catch (Throwable e) {}
                return retParmVal;
                catch (Throwable throwable) {
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getHardwareFieldValue(String parm, long nodeId) {
        String retParmVal = null;
        int end = parm.lastIndexOf("]");
        String[] parts = parm.substring("hardware[".length(), end).split(":");
        if (parts.length != 2) {
            return null;
        }
        String sql = null;
        boolean isCustomAttr = !parts[1].startsWith("entPhysical");
        sql = isCustomAttr ? "SELECT a.attribValue FROM hwEntityAttribute a, hwEntity h, hwEntityAttributeType t WHERE h.nodeId = " + String.valueOf(nodeId) + " AND a.hwEntityId = h.id AND a.hwAttribTypeId = t.id AND t.attribName = '" + parts[1] + "'" : "SELECT " + parts[1] + " FROM hwEntity WHERE nodeId = " + String.valueOf(nodeId);
        sql = parts[0].matches("^\\d+$") ? (isCustomAttr ? sql + " AND h.entPhysicalIndex = " + parts[0] : sql + " AND entPhysicalIndex = " + parts[0]) : (parts[0].startsWith("~") ? (isCustomAttr ? sql + " AND h.entPhysicalName ~ '" + parts[0].substring(1) + "'" : sql + " AND entPhysicalName ~ '" + parts[0].substring(1) + "'") : (isCustomAttr ? sql + " AND h.entPhysicalName = '" + parts[0] + "'" : sql + " AND entPhysicalName = '" + parts[0] + "'"));
        Connection dbConn = null;
        try {
            Statement stmt = null;
            dbConn = DataSourceFactory.getInstance().getConnection();
            stmt = dbConn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                retParmVal = rs.getString(1);
            }
            if (stmt == null) return retParmVal;
            try {
                stmt.close();
                return retParmVal;
            }
            catch (Throwable e) {}
            return retParmVal;
            catch (SQLException sqlE) {
                if (stmt == null) return retParmVal;
                try {
                    stmt.close();
                    return retParmVal;
                }
                catch (Throwable e) {}
                return retParmVal;
                catch (Throwable throwable) {
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

