/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EventUtilDaoImpl
extends AbstractEventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtilDaoImpl.class);
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private SnmpInterfaceDao snmpInterfaceDao;
    @Autowired
    private AssetRecordDao assetRecordDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;

    @Override
    public String getNodeLabel(long nodeId) throws SQLException {
        return this.nodeDao.getLabelForId(Integer.valueOf((int)nodeId));
    }

    @Override
    public String getIfAlias(long nodeId, String ipaddr) throws SQLException {
        return this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf((int)nodeId), ipaddr).getSnmpInterface().getIfAlias();
    }

    @Override
    public String getAssetFieldValue(String parm, long nodeId) {
        return this.assetRecordDao.findByNodeId(Integer.valueOf((int)nodeId)).getNode().getLabel();
    }

    @Override
    public String getHardwareFieldValue(String parm, long nodeId) {
        return "Unknown-Not-Implemented-Yet";
    }
}

