/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.model.events.EventProcessor;
import org.opennms.netmgt.model.events.EventProcessorException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class DefaultEventHandlerImpl
implements InitializingBean,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventHandlerImpl.class);
    private List<EventProcessor> m_eventProcessors;
    private boolean m_logEventSummaries;

    @Override
    public EventHandlerRunnable createRunnable(Log eventLog) {
        return new EventHandlerRunnable(eventLog);
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventProcessors != null ? 1 : 0) != 0, (String)"property eventPersisters must be set");
    }

    public List<EventProcessor> getEventProcessors() {
        return this.m_eventProcessors;
    }

    public void setEventProcessors(List<EventProcessor> eventProcessors) {
        this.m_eventProcessors = eventProcessors;
    }

    public boolean getLogEventSummaries() {
        return this.m_logEventSummaries;
    }

    public void setLogEventSummaries(boolean logEventSummaries) {
        this.m_logEventSummaries = logEventSummaries;
    }

    public class EventHandlerRunnable
    implements Runnable {
        private Log m_eventLog;

        public EventHandlerRunnable(Log eventLog) {
            Assert.notNull((Object)eventLog, (String)"eventLog argument must not be null");
            this.m_eventLog = eventLog;
        }

        @Override
        public void run() {
            Events events = this.m_eventLog.getEvents();
            if (events == null || events.getEventCount() <= 0) {
                return;
            }
            block3: for (Event event : events.getEventCollection()) {
                if (DefaultEventHandlerImpl.this.getLogEventSummaries() && LOG.isInfoEnabled()) {
                    LOG.info("Received event: UEI={}, src={}, iface={}, svc={}, time={}, parms={}", new Object[]{event.getUei(), event.getSource(), event.getInterface(), event.getService(), event.getTime(), this.getPrettyParms(event)});
                }
                if (LOG.isDebugEnabled()) {
                    String uuid = event.getUuid();
                    LOG.debug("Event {");
                    LOG.debug("  uuid  = {}", (Object)(uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                    LOG.debug("  uei   = {}", (Object)event.getUei());
                    LOG.debug("  src   = {}", (Object)event.getSource());
                    LOG.debug("  iface = {}", (Object)event.getInterface());
                    LOG.debug("  svc   = {}", (Object)event.getService());
                    LOG.debug("  time  = {}", (Object)event.getTime());
                    if (this.getPrettyParms(event).size() > 0) {
                        LOG.debug("  parms {");
                        for (Parm parm : event.getParmCollection()) {
                            if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                            LOG.debug("    ({}, {})", (Object)parm.getParmName().trim(), (Object)parm.getValue().getContent().trim());
                        }
                        LOG.debug("  }");
                    }
                    LOG.debug("}");
                }
                for (EventProcessor eventProcessor : DefaultEventHandlerImpl.this.m_eventProcessors) {
                    try {
                        eventProcessor.process(this.m_eventLog.getHeader(), event);
                    }
                    catch (EventProcessorException e) {
                        LOG.warn("Unable to process event using processor {}; not processing with any later processors.", (Object)eventProcessor, (Object)e);
                        continue block3;
                    }
                    catch (Throwable t) {
                        LOG.warn("Unknown exception processing event with processor {}; not processing with any later processors.", (Object)eventProcessor, (Object)t);
                        continue block3;
                    }
                }
            }
        }

        private List<String> getPrettyParms(Event event) {
            ArrayList<String> parms = new ArrayList<String>();
            for (Parm p : event.getParmCollection()) {
                parms.add(p.getParmName() + "=" + p.getValue().getContent());
            }
            return parms;
        }
    }
}

