/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public abstract class NodeDiscovery
implements ReadyRunnable {
    protected final LinkableSnmpNode m_node;
    private Scheduler m_scheduler;
    private long m_poll_interval = 1800000L;
    private long m_initial_sleep_time = 600000L;
    private boolean m_suspendCollection = false;
    private boolean m_runned = false;
    protected final EnhancedLinkd m_linkd;

    public NodeDiscovery(EnhancedLinkd linkd, LinkableSnmpNode node) {
        this.m_linkd = linkd;
        this.m_node = node;
        this.m_initial_sleep_time = this.m_linkd.getInitialSleepTime();
        this.m_poll_interval = this.m_linkd.getRescanInterval();
    }

    @Override
    public void run() {
        if (this.m_suspendCollection) {
            EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoverySuspended", "EnhancedLinkd");
            builder.setNodeid((long)this.getNodeId());
            builder.setInterface(this.getTarget());
            builder.addParam("runnable", this.getName());
            this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
        } else {
            EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryStarted", "EnhancedLinkd");
            builder.setNodeid((long)this.getNodeId());
            builder.setInterface(this.getTarget());
            builder.addParam("runnable", this.getName());
            this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
            this.runCollection();
            builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryCompleted", "EnhancedLinkd");
            builder.setNodeid((long)this.getNodeId());
            builder.setInterface(this.getTarget());
            builder.addParam("runnable", this.getName());
            this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
        }
        this.m_runned = true;
        this.reschedule();
    }

    protected abstract void runCollection();

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_poll_interval, this);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.m_suspendCollection;
    }

    @Override
    public void suspend() {
        this.m_suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.m_suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.m_runned) {
            this.m_scheduler.unschedule(this, this.m_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.m_initial_sleep_time);
        }
    }

    public InetAddress getTarget() {
        return this.m_node.getSnmpPrimaryIpAddr();
    }

    public String getReadCommunity() {
        return this.getPeer().getReadCommunity();
    }

    public SnmpAgentConfig getPeer() {
        return this.m_linkd.getSnmpAgentConfig(this.getTarget());
    }

    public int getPort() {
        return this.getPeer().getPort();
    }

    @Override
    public abstract String getInfo();

    @Override
    public String getPackageName() {
        return "default";
    }

    @Override
    public void setPackageName(String pkgName) {
    }

    public long getInitialSleepTime() {
        return this.m_initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.m_initial_sleep_time = initial_sleep_time;
    }

    public long getPollInterval() {
        return this.m_poll_interval;
    }

    public void setPollInterval(long interval) {
        this.m_poll_interval = interval;
    }

    public int getNodeId() {
        return this.m_node.getNodeId();
    }

    public abstract String getName();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_initial_sleep_time ^ this.m_initial_sleep_time >>> 32);
        result = 31 * result + (this.m_node == null ? 0 : this.m_node.hashCode());
        result = 31 * result + (int)(this.m_poll_interval ^ this.m_poll_interval >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeDiscovery other = (NodeDiscovery)obj;
        if (this.m_initial_sleep_time != other.m_initial_sleep_time) {
            return false;
        }
        if (this.m_node == null ? other.m_node != null : !this.m_node.equals((Object)other.m_node)) {
            return false;
        }
        return this.m_poll_interval == other.m_poll_interval;
    }
}

