/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfTable
extends SnmpTable<IfTableEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(IfTable.class);

    public IfTable(InetAddress address) {
        super(address, "ifTable", IfTableEntry.ms_elemList);
    }

    @Override
    protected IfTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IfTableEntry();
    }

    public IfTableEntry getEntry(int ifIndex) {
        for (IfTableEntry entry : this) {
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            return entry;
        }
        return null;
    }

    public int getOperStatus(int ifIndex) {
        for (IfTableEntry entry : this) {
            Integer ifStatus;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifStatus = entry.getIfOperStatus()) == null) continue;
            return ifStatus;
        }
        return -1;
    }

    public int getAdminStatus(int ifIndex) {
        for (IfTableEntry entry : this) {
            Integer ifStatus;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifStatus = entry.getIfAdminStatus()) == null) continue;
            return ifStatus;
        }
        return -1;
    }

    public int getIfType(int ifIndex) {
        for (IfTableEntry entry : this) {
            Integer ifType;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifType = entry.getIfType()) == null) continue;
            return ifType;
        }
        return -1;
    }

    public String getIfDescr(int ifIndex) {
        String ifDescr = null;
        for (IfTableEntry entry : this) {
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            ifDescr = entry.getIfDescr();
        }
        return ifDescr;
    }

    public Long getIfSpeed(int ifIndex) {
        Long ifSpeed = null;
        for (IfTableEntry entry : this) {
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            ifSpeed = entry.getIfSpeed();
        }
        return ifSpeed;
    }

    public String getPhysAddr(int ifIndex) {
        String physAddr = null;
        for (IfTableEntry entry : this) {
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            physAddr = entry.getPhysAddr();
        }
        return physAddr;
    }
}

