/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketUtils;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.poller.nrpe.NrpePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NrpePlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NrpePlugin.class);
    private static final String PROTOCOL_NAME = "NRPE";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    private boolean m_useSsl = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, String command, int padding, int retries, int timeout, Pattern regex, StringBuffer bannerResult) {
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket = this.wrapSocket(socket, host.toString(), port);
                socket.setSoTimeout(timeout);
                LOG.debug("NrpePlugin: connected to host: {} on port: {}", (Object)host, (Object)port);
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket(socket.getInputStream(), padding);
                if (response.getResultCode() == 0) {
                    isAServer = true;
                    continue;
                }
                if (response.getResultCode() <= 2) {
                    String response_msg = response.getBuffer();
                    Pattern r = Pattern.compile("OK|WARNING|CRITICAL");
                    if (!r.matcher(response_msg).find()) {
                        LOG.info("received 1-2 return code, {}, with message: {}", (Object)response.getResultCode(), (Object)response.getBuffer());
                        isAServer = false;
                        break;
                    }
                    isAServer = true;
                    continue;
                }
                LOG.info("received 3+ return code, {}, with message: {}", (Object)response.getResultCode(), (Object)response.getBuffer());
                isAServer = false;
                break;
            }
            catch (ConnectException e) {
                LOG.debug("NrpePlugin: Connection refused to {}:{}", (Object)InetAddressUtils.str((InetAddress)host), (Object)port);
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                LOG.info("NrpePlugin: Could not connect to host {}, no route to host", (Object)InetAddressUtils.str((InetAddress)host), (Object)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                LOG.debug("NrpePlugin: did not connect to host within timeout: {} attempt: {}", (Object)timeout, (Object)attempts);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                LOG.info("NrpePlugin: An expected I/O exception occured connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, e});
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                LOG.warn("NrpePlugin: An undeclared throwable exception was caught connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, t});
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int port = -1;
        int padding = -1;
        String banner = null;
        String match = null;
        String command = null;
        if (qualifiers != null) {
            command = ParameterMap.getKeyedString(qualifiers, (String)"command", (String)"_NRPE_CHECK");
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)5666);
            padding = ParameterMap.getKeyedInteger(qualifiers, (String)"padding", (int)2);
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
            this.m_useSsl = ParameterMap.getKeyedBoolean(qualifiers, (String)"usessl", (boolean)true);
        }
        try {
            StringBuffer bannerResult = null;
            Pattern regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = Pattern.compile(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = Pattern.compile(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, port, command, padding, retries, timeout, regex, bannerResult);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (PatternSyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected Socket wrapSocket(Socket socket, String hostAddress, int hostPort) throws Exception {
        if (!this.m_useSsl) {
            LOG.debug("Parameter 'usessl' is unset or false, not using SSL");
            return socket;
        }
        LOG.debug("Parameter 'usessl' is true, using SSL");
        return SocketUtils.wrapSocketInSslContext((Socket)socket, (String[])ADH_CIPHER_SUITES);
    }
}

