/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbNodeEntry {
    private static final Logger LOG = LoggerFactory.getLogger(DbNodeEntry.class);
    private static final String DEFAULT_DP_NAME = "localhost";
    private static final String SQL_NEXT_NID = System.getProperty("opennms.db.nextNodeId", "SELECT NEXTVAL('nodeNxtId')");
    private static final String SQL_LOAD_REC = "SELECT nodeCreateTime, nodeParentID, nodeType, nodeSysOID, nodeSysName, nodeSysDescription, nodeSysLocation, nodeSysContact, nodeLabel, nodeLabelSource, nodeNetBIOSName, nodeDomainName, operatingSystem, lastCapsdPoll, foreignSource, foreignId FROM node WHERE nodeID = ? AND dpName = ? AND nodeType != 'D'";
    private static final String SQL_LOAD_IF_LIST = "SELECT ipAddr, ifIndex FROM ipInterface WHERE nodeID = ? AND isManaged != 'D'";
    private static final String SQL_LOAD_MANAGED_IF_LIST = "SELECT ipAddr, ifIndex FROM ipInterface WHERE nodeID = ? AND isManaged = 'M'";
    private static final String SQL_LOAD_SNMP_LIST = "SELECT ipAddr, snmpIfIndex FROM snmpInterface WHERE nodeID = ?";
    private boolean m_fromDb = false;
    private int m_nodeId = -1;
    private String m_dpName;
    private Timestamp m_createTime;
    private int m_parentId;
    private OnmsNode.NodeType m_type;
    private String m_sysoid;
    private String m_sysname;
    private String m_sysdescr;
    private String m_syslocation;
    private String m_syscontact;
    private String m_label;
    private OnmsNode.NodeLabelSource m_labelSource;
    private String m_nbName;
    private String m_nbDomainName;
    private String m_os;
    private Timestamp m_lastPoll;
    private String m_foreignSource;
    private String m_foreignId;
    private int m_changed;
    private static final int CHANGED_CREATE_TIME = 1;
    private static final int CHANGED_PARENT_ID = 2;
    private static final int CHANGED_TYPE = 4;
    private static final int CHANGED_SYSOID = 8;
    private static final int CHANGED_SYSNAME = 16;
    private static final int CHANGED_SYSLOC = 32;
    private static final int CHANGED_SYSCONTACT = 64;
    private static final int CHANGED_LABEL = 128;
    private static final int CHANGED_LABEL_SOURCE = 256;
    private static final int CHANGED_NETBIOS_NAME = 512;
    private static final int CHANGED_DOMAIN_NAME = 1024;
    private static final int CHANGED_OS = 2048;
    private static final int CHANGED_DPNAME = 4096;
    private static final int CHANGED_SYSDESCR = 8192;
    private static final int CHANGED_POLLTIME = 16384;
    private static final int CHANGED_FOREIGN_SOURCE = 32768;
    private static final int CHANGED_FOREIGN_ID = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = c.prepareStatement(SQL_NEXT_NID);
            d.watch((Object)stmt);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            rset.next();
            this.m_nodeId = rset.getInt(1);
            StringBuffer names = new StringBuffer("INSERT INTO node (nodeID,dpName");
            StringBuffer values = new StringBuffer("?");
            if ((this.m_changed & 0x1000) == 4096) {
                values.append(",?");
            } else {
                values.append(",'").append(DEFAULT_DP_NAME).append("'");
            }
            if ((this.m_changed & 2) == 2) {
                values.append(",?");
                names.append(",nodeParentID");
            }
            if ((this.m_changed & 4) == 4) {
                values.append(",?");
                names.append(",nodeType");
            }
            if ((this.m_changed & 1) == 1) {
                values.append(",?");
                names.append(",nodeCreateTime");
            } else {
                values.append(",?");
                names.append(",nodeCreateTime");
                this.m_createTime = new Timestamp(new Date().getTime());
                this.m_changed |= 1;
            }
            if ((this.m_changed & 8) == 8) {
                values.append(",?");
                names.append(",nodeSysOID");
            }
            if ((this.m_changed & 0x10) == 16) {
                values.append(",?");
                names.append(",nodeSysName");
            }
            if ((this.m_changed & 0x2000) == 8192) {
                values.append(",?");
                names.append(",nodeSysDescription");
            }
            if ((this.m_changed & 0x20) == 32) {
                values.append(",?");
                names.append(",nodeSysLocation");
            }
            if ((this.m_changed & 0x40) == 64) {
                values.append(",?");
                names.append(",nodeSysContact");
            }
            if ((this.m_changed & 0x80) == 128) {
                values.append(",?");
                names.append(",nodeLabel");
            }
            if ((this.m_changed & 0x100) == 256) {
                values.append(",?");
                names.append(",nodeLabelSource");
            }
            if ((this.m_changed & 0x200) == 512) {
                values.append(",?");
                names.append(",nodeNetBIOSName");
            }
            if ((this.m_changed & 0x400) == 1024) {
                values.append(",?");
                names.append(",nodeDomainName");
            }
            if ((this.m_changed & 0x800) == 2048) {
                values.append(",?");
                names.append(",operatingSystem");
            }
            if ((this.m_changed & 0x4000) == 16384) {
                values.append(",?");
                names.append(",lastCapsdPoll");
            }
            if ((this.m_changed & 0x8000) == 32768) {
                values.append(",?");
                names.append(",foreignSource");
            }
            if ((this.m_changed & 0x10000) == 65536) {
                values.append(",?");
                names.append(",foreignId");
            }
            names.append(") VALUES (").append(values).append(')');
            LOG.debug("DbNodeEntry.insert: SQL insert statment = {}", (Object)names.toString());
            stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            names = null;
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            if ((this.m_changed & 0x1000) == 4096) {
                stmt.setString(ndx++, this.m_dpName);
            }
            if ((this.m_changed & 2) == 2) {
                if (this.m_parentId == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_parentId);
                }
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, this.m_type.toString());
            }
            if ((this.m_changed & 1) == 1) {
                stmt.setTimestamp(ndx++, this.m_createTime);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, this.m_sysoid);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setString(ndx++, this.m_sysname);
            }
            if ((this.m_changed & 0x2000) == 8192) {
                stmt.setString(ndx++, this.m_sysdescr);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setString(ndx++, this.m_syslocation);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setString(ndx++, this.m_syscontact);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setString(ndx++, this.m_label);
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setString(ndx++, this.m_labelSource.toString());
            }
            if ((this.m_changed & 0x200) == 512) {
                stmt.setString(ndx++, this.m_nbName);
            }
            if ((this.m_changed & 0x400) == 1024) {
                stmt.setString(ndx++, this.m_nbDomainName);
            }
            if ((this.m_changed & 0x800) == 2048) {
                stmt.setString(ndx++, this.m_os);
            }
            if ((this.m_changed & 0x4000) == 16384) {
                stmt.setTimestamp(ndx++, this.m_lastPoll);
            }
            if ((this.m_changed & 0x8000) == 32768) {
                stmt.setString(ndx++, this.m_foreignSource);
            }
            if ((this.m_changed & 0x10000) == 65536) {
                stmt.setString(ndx++, this.m_foreignId);
            }
            LOG.debug("nodeid='{}' nodetype='{}' createTime='{}' lastPoll='{}' dpName='{}' sysname='{}' sysoid='{}' sysdescr='{}' syslocation='{}' syscontact='{}' label='{}' labelsource='{}' netbios='{}' domain='{}' os='{}'", new Object[]{this.m_nodeId, this.m_type.toString(), this.m_createTime, this.m_lastPoll, this.m_dpName, this.m_sysname, this.m_sysoid, this.m_sysdescr, this.m_syslocation, this.m_syscontact, this.m_label, this.m_labelSource.toString(), this.m_nbName, this.m_nbDomainName, this.m_os});
            int rc = stmt.executeUpdate();
            LOG.debug("DbNodeEntry.insert: SQL update result = {}", (Object)rc);
            this.createAssetNodeEntry(c, this.m_nodeId);
            this.m_fromDb = true;
            this.m_changed = 0;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        StringBuffer sqlText = new StringBuffer("UPDATE node SET ");
        int comma = 32;
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("nodeParentID = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("nodeType = ?");
            comma = 44;
        }
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("nodeCreateTime = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("nodeSysOID = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("nodeSysName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x2000) == 8192) {
            sqlText.append((char)comma).append("nodeSysDescription = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("nodeSysLocation = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("nodeSysContact = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("nodeLabel = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("nodeLabelSource = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x200) == 512) {
            sqlText.append((char)comma).append("nodeNetBIOSName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x400) == 1024) {
            sqlText.append((char)comma).append("nodeDomainName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x800) == 2048) {
            sqlText.append((char)comma).append("operatingSystem = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x4000) == 16384) {
            sqlText.append((char)comma).append("lastCapsdPoll = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x8000) == 32768) {
            sqlText.append((char)comma).append("foreignSource = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10000) == 65536) {
            sqlText.append((char)comma).append("foreignId = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeID = ? AND dpName = ?");
        LOG.debug("DbNodeEntry.update: SQL update statment = {}", (Object)sqlText.toString());
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            sqlText = null;
            int ndx = 1;
            if ((this.m_changed & 2) == 2) {
                if (this.m_parentId == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_parentId);
                }
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, this.m_type.toString());
            }
            if ((this.m_changed & 1) == 1) {
                if (this.m_createTime == null) {
                    stmt.setNull(ndx++, 93);
                } else {
                    stmt.setTimestamp(ndx++, this.m_createTime);
                }
            }
            if ((this.m_changed & 8) == 8) {
                if (this.m_sysoid == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysoid);
                }
            }
            if ((this.m_changed & 0x10) == 16) {
                if (this.m_sysname == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysname);
                }
            }
            if ((this.m_changed & 0x2000) == 8192) {
                if (this.m_sysdescr == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysdescr);
                }
            }
            if ((this.m_changed & 0x20) == 32) {
                if (this.m_syslocation == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_syslocation);
                }
            }
            if ((this.m_changed & 0x40) == 64) {
                if (this.m_syscontact == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_syscontact);
                }
            }
            if ((this.m_changed & 0x80) == 128) {
                if (this.m_label == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_label);
                }
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setString(ndx++, this.m_labelSource.toString());
            }
            if ((this.m_changed & 0x200) == 512) {
                if (this.m_nbName == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_nbName);
                }
            }
            if ((this.m_changed & 0x400) == 1024) {
                if (this.m_nbDomainName == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_nbDomainName);
                }
            }
            if ((this.m_changed & 0x800) == 2048) {
                if (this.m_os == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_os);
                }
            }
            if ((this.m_changed & 0x4000) == 16384) {
                if (this.m_lastPoll != null) {
                    stmt.setTimestamp(ndx++, this.m_lastPoll);
                } else {
                    stmt.setNull(ndx++, 93);
                }
            }
            if ((this.m_changed & 0x8000) == 32768) {
                if (this.m_foreignSource == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_foreignSource);
                }
            }
            if ((this.m_changed & 0x10000) == 65536) {
                if (this.m_foreignId == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_foreignId);
                }
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, this.m_dpName);
            int rc = stmt.executeUpdate();
            LOG.debug("DbNodeEntry.update: update result = {}", (Object)rc);
            this.m_changed = 0;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_REC);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            stmt.setString(2, this.m_dpName);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_createTime = rset.getTimestamp(ndx++);
            this.m_parentId = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_parentId = -1;
            }
            this.m_type = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? (OnmsNode.NodeType.ACTIVE.toString().equals(str) ? OnmsNode.NodeType.ACTIVE : (OnmsNode.NodeType.DELETED.toString().equals(str) ? OnmsNode.NodeType.DELETED : OnmsNode.NodeType.UNKNOWN)) : OnmsNode.NodeType.UNKNOWN;
            this.m_sysoid = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_sysoid = null;
            }
            this.m_sysname = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_sysname = null;
            }
            this.m_sysdescr = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_sysdescr = null;
            }
            this.m_syslocation = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_syslocation = null;
            }
            this.m_syscontact = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_syscontact = null;
            }
            this.m_label = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_label = null;
            }
            str = rset.getString(ndx++);
            this.m_labelSource = rset.wasNull() ? OnmsNode.NodeLabelSource.UNKNOWN : (OnmsNode.NodeLabelSource.ADDRESS.toString().equals(str) ? OnmsNode.NodeLabelSource.ADDRESS : (OnmsNode.NodeLabelSource.HOSTNAME.toString().equals(str) ? OnmsNode.NodeLabelSource.HOSTNAME : (OnmsNode.NodeLabelSource.NETBIOS.toString().equals(str) ? OnmsNode.NodeLabelSource.NETBIOS : (OnmsNode.NodeLabelSource.SYSNAME.toString().equals(str) ? OnmsNode.NodeLabelSource.SYSNAME : (OnmsNode.NodeLabelSource.UNKNOWN.toString().equals(str) ? OnmsNode.NodeLabelSource.UNKNOWN : (OnmsNode.NodeLabelSource.USER.toString().equals(str) ? OnmsNode.NodeLabelSource.USER : OnmsNode.NodeLabelSource.UNKNOWN))))));
            this.m_nbName = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_nbName = null;
            }
            this.m_nbDomainName = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_nbDomainName = null;
            }
            this.m_os = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_os = null;
            }
            this.m_lastPoll = rset.getTimestamp(ndx++);
            this.m_foreignSource = rset.getString(ndx++);
            this.m_foreignId = rset.getString(ndx++);
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
        return true;
    }

    private DbNodeEntry() {
        this(DEFAULT_DP_NAME);
    }

    private DbNodeEntry(String poller) {
        this.m_dpName = poller;
        this.m_createTime = null;
        this.m_parentId = -1;
        this.m_type = OnmsNode.NodeType.UNKNOWN;
        this.m_sysoid = null;
        this.m_sysname = null;
        this.m_sysdescr = null;
        this.m_syslocation = null;
        this.m_syscontact = null;
        this.m_label = null;
        this.m_labelSource = OnmsNode.NodeLabelSource.UNKNOWN;
        this.m_nbName = null;
        this.m_nbDomainName = null;
        this.m_os = null;
        this.m_lastPoll = null;
        this.m_foreignSource = null;
        this.m_foreignId = null;
        this.m_changed = 0;
    }

    private DbNodeEntry(int nid) {
        this(DEFAULT_DP_NAME);
        this.m_fromDb = true;
        this.m_nodeId = nid;
        this.m_dpName = DEFAULT_DP_NAME;
    }

    private DbNodeEntry(int nid, String dpName) {
        this(dpName);
        this.m_fromDb = true;
        this.m_nodeId = nid;
        this.m_dpName = dpName;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getDistributedPollerName() {
        return this.m_dpName;
    }

    public Timestamp getCreationTime() {
        return this.m_createTime;
    }

    public String getFormattedCreationTime() {
        String result = null;
        if (this.m_createTime != null) {
            result = this.m_createTime.toString();
        }
        return result;
    }

    public void setCreationTime(String time) throws ParseException {
        if (time == null) {
            this.m_createTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_createTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 1;
    }

    public void setCreationTime(Date time) {
        this.m_createTime = new Timestamp(time.getTime());
        this.m_changed |= 1;
    }

    public void setCreationTime(Timestamp time) {
        this.m_createTime = time;
        this.m_changed |= 1;
    }

    public boolean hasParentId() {
        return this.m_parentId != -1;
    }

    public int getParentId() {
        return this.m_parentId;
    }

    public void setParentId(int id) {
        this.m_parentId = id;
        this.m_changed |= 2;
    }

    public boolean hasParentIdChanged() {
        return (this.m_changed & 2) == 2;
    }

    public boolean updateParentId(int newparentId) {
        if (newparentId != this.m_parentId) {
            this.setParentId(newparentId);
            return true;
        }
        return false;
    }

    public OnmsNode.NodeType getNodeType() {
        return this.m_type;
    }

    public void setNodeType(OnmsNode.NodeType type) {
        this.m_type = type;
        this.m_changed |= 4;
    }

    public boolean hasNodeTypeChanged() {
        return (this.m_changed & 4) == 4;
    }

    public boolean updateNodeType(OnmsNode.NodeType newtype) {
        if (newtype != this.m_type) {
            this.setNodeType(newtype);
            return true;
        }
        return false;
    }

    public String getSystemOID() {
        return this.m_sysoid;
    }

    public void setSystemOID(String oid) {
        this.m_sysoid = oid;
        this.m_changed |= 8;
    }

    public boolean hasSystemOIDChanged() {
        return (this.m_changed & 8) == 8;
    }

    public boolean updateSystemOID(String newsysoid) {
        if (newsysoid == null || newsysoid.equals(this.m_sysoid)) {
            return false;
        }
        this.setSystemOID(newsysoid);
        return true;
    }

    public String getSystemName() {
        return this.m_sysname;
    }

    public void setSystemName(String name) {
        this.m_sysname = name;
        this.m_changed |= 0x10;
    }

    public boolean hasSystemNameChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    public boolean updateSystemName(String newsysname) {
        if (newsysname == null || newsysname.equals(this.m_sysname)) {
            return false;
        }
        this.setSystemName(newsysname);
        return true;
    }

    public String getSystemDescription() {
        return this.m_sysdescr;
    }

    public void setSystemDescription(String descr) {
        this.m_sysdescr = descr;
        this.m_changed |= 0x2000;
    }

    public boolean hasSystemDescriptionChanged() {
        return (this.m_changed & 0x2000) == 8192;
    }

    public boolean updateSystemDescription(String newsysdescr) {
        if (newsysdescr == null || newsysdescr.equals(this.m_sysdescr)) {
            return false;
        }
        this.setSystemDescription(newsysdescr);
        return true;
    }

    public String getSystemLocation() {
        return this.m_syslocation;
    }

    public void setSystemLocation(String loc) {
        this.m_syslocation = loc;
        this.m_changed |= 0x20;
    }

    public boolean hasSystemLocationChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    public boolean updateSystemLocation(String newsyslocation) {
        if (newsyslocation == null || newsyslocation.equals(this.m_syslocation)) {
            return false;
        }
        this.setSystemLocation(newsyslocation);
        return true;
    }

    public String getSystemContact() {
        return this.m_syscontact;
    }

    public void setSystemContact(String contact) {
        this.m_syscontact = contact;
        this.m_changed |= 0x40;
    }

    public boolean hasSystemContactChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    public boolean updateSystemContact(String newsyscontact) {
        if (newsyscontact == null || newsyscontact.equals(this.m_syscontact)) {
            return false;
        }
        this.setSystemContact(newsyscontact);
        return true;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
        this.m_changed |= 0x80;
    }

    public boolean hasLabelChanged() {
        return (this.m_changed & 0x80) == 128;
    }

    public boolean updateLabel(String newlabel) {
        boolean doUpdate = false;
        if (newlabel != null && this.m_label != null) {
            if (!newlabel.equals(this.m_label)) {
                doUpdate = true;
            }
        } else if (newlabel != null || this.m_label != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setLabel(newlabel);
            return true;
        }
        return false;
    }

    public OnmsNode.NodeLabelSource getLabelSource() {
        return this.m_labelSource;
    }

    public void setLabelSource(OnmsNode.NodeLabelSource src) {
        this.m_labelSource = src;
        this.m_changed |= 0x100;
    }

    public boolean hasLabelSourceChanged() {
        return (this.m_changed & 0x100) == 256;
    }

    public boolean updateLabelSource(OnmsNode.NodeLabelSource newlabelSource) {
        if (newlabelSource != this.m_labelSource) {
            this.setLabelSource(newlabelSource);
            return true;
        }
        return false;
    }

    public String getNetBIOSName() {
        return this.m_nbName;
    }

    public void setNetBIOSName(String name) {
        this.m_nbName = name != null ? name.toUpperCase() : null;
        this.m_changed |= 0x200;
    }

    public boolean hasNetBIOSNameChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    public boolean updateNetBIOSName(String newnbName) {
        boolean doUpdate = false;
        if (newnbName != null && this.m_nbName != null) {
            if (!newnbName.equalsIgnoreCase(this.m_nbName)) {
                doUpdate = true;
            }
        } else if (newnbName != null || this.m_nbName != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setNetBIOSName(newnbName);
            return true;
        }
        return false;
    }

    public String getDomainName() {
        return this.m_nbDomainName;
    }

    public void setDomainName(String domain) {
        this.m_nbDomainName = domain;
        this.m_changed |= 0x400;
    }

    public boolean hasDomainNameChanged() {
        return (this.m_changed & 0x400) == 1024;
    }

    public boolean updateDomainName(String domain) {
        boolean doUpdate = false;
        if (domain != null && this.m_nbDomainName != null) {
            if (!domain.equals(this.m_nbDomainName)) {
                doUpdate = true;
            }
        } else if (domain != null || this.m_nbDomainName != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setDomainName(domain);
            return true;
        }
        return false;
    }

    public String getOS() {
        return this.m_os;
    }

    public void setOS(String os) {
        this.m_os = os;
        this.m_changed |= 0x800;
    }

    public boolean hasOSChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    public boolean updateOS(String newos) {
        boolean doUpdate = false;
        if (newos != null && this.m_os != null) {
            if (!newos.equals(this.m_os)) {
                doUpdate = true;
            }
        } else if (newos != null || this.m_os != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setOS(newos);
            return true;
        }
        return false;
    }

    public String getLastPollString() {
        String result = null;
        if (this.m_lastPoll != null) {
            result = this.m_lastPoll.toString();
        }
        return result;
    }

    public Timestamp getLastPoll() {
        return this.m_lastPoll;
    }

    public void setLastPoll(String time) throws ParseException {
        if (time == null) {
            this.m_lastPoll = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPoll = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x4000;
    }

    public void setLastPoll(Date time) {
        this.m_lastPoll = new Timestamp(time.getTime());
        this.m_changed |= 0x4000;
    }

    public void setLastPoll(Timestamp time) {
        this.m_lastPoll = time;
        this.m_changed |= 0x4000;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
        this.m_changed |= 0x8000;
    }

    public boolean hasForeignSource() {
        return (this.m_changed & 0x8000) == 32768;
    }

    public boolean updateForeignSource(String newForeignSource) {
        boolean doUpdate = false;
        if (newForeignSource != null && this.m_foreignSource != null) {
            if (!newForeignSource.equalsIgnoreCase(this.m_foreignSource)) {
                doUpdate = true;
            }
        } else if (newForeignSource != null || this.m_foreignSource != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setForeignSource(newForeignSource);
            return true;
        }
        return false;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
        this.m_changed |= 0x10000;
    }

    public boolean hasForeignId() {
        return (this.m_changed & 0x10000) == 65536;
    }

    public boolean updateForeignId(String newForeignId) {
        boolean doUpdate = false;
        if (newForeignId != null && this.m_foreignId != null) {
            if (!newForeignId.equalsIgnoreCase(this.m_foreignId)) {
                doUpdate = true;
            }
        } else if (newForeignId != null || this.m_foreignId != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setForeignId(newForeignId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    LOG.warn("Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    public void store(Connection db) throws SQLException {
        LOG.debug("DbNodeEntry: changed map = 0x{}", (Object)Integer.toHexString(this.m_changed));
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbIpInterfaceEntry[] getInterfaces() throws SQLException {
        DbIpInterfaceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getInterfaces(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LOG.warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbIpInterfaceEntry[] getInterfaces(Connection db) throws SQLException {
        ArrayList<DbIpInterfaceEntry> l;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = db.prepareStatement(SQL_LOAD_IF_LIST);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            l = new ArrayList<DbIpInterfaceEntry>();
            while (rset.next()) {
                String saddr = rset.getString(1);
                int ifIndex = rset.getInt(2);
                if (rset.wasNull()) {
                    ifIndex = -1;
                }
                InetAddress addr = null;
                addr = InetAddressUtils.addr((String)saddr);
                if (addr == null) continue;
                DbIpInterfaceEntry entry = null;
                entry = ifIndex == -1 ? DbIpInterfaceEntry.get(db, this.m_nodeId, addr) : DbIpInterfaceEntry.get(db, this.m_nodeId, addr, ifIndex);
                if (entry == null) continue;
                l.add(entry);
            }
        }
        finally {
            d.cleanUp();
        }
        DbIpInterfaceEntry[] entries = new DbIpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbIpInterfaceEntry[] getManagedInterfaces() throws SQLException {
        DbIpInterfaceEntry[] entries = null;
        Connection db = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            db = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)db);
            entries = this.getManagedInterfaces(db);
        }
        finally {
            d.cleanUp();
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbIpInterfaceEntry[] getManagedInterfaces(Connection db) throws SQLException {
        ArrayList<DbIpInterfaceEntry> l;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = db.prepareStatement(SQL_LOAD_MANAGED_IF_LIST);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            l = new ArrayList<DbIpInterfaceEntry>();
            while (rset.next()) {
                String saddr = rset.getString(1);
                int ifIndex = rset.getInt(2);
                if (rset.wasNull()) {
                    ifIndex = -1;
                }
                InetAddress addr = null;
                addr = InetAddressUtils.addr((String)saddr);
                if (addr == null) continue;
                DbIpInterfaceEntry entry = null;
                entry = ifIndex == -1 ? DbIpInterfaceEntry.get(db, this.m_nodeId, addr) : DbIpInterfaceEntry.get(db, this.m_nodeId, addr, ifIndex);
                if (entry == null) continue;
                l.add(entry);
            }
        }
        finally {
            d.cleanUp();
        }
        DbIpInterfaceEntry[] entries = new DbIpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    public static DbIpInterfaceEntry getPrimarySnmpInterface(DbIpInterfaceEntry[] ipInterfaces) {
        if (ipInterfaces == null) {
            return null;
        }
        for (int i = 0; i < ipInterfaces.length; ++i) {
            if (ipInterfaces[i].getPrimaryState() != 'P') continue;
            return ipInterfaces[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbSnmpInterfaceEntry[] getSnmpInterfaces() throws SQLException {
        DbSnmpInterfaceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getSnmpInterfaces(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LOG.warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbSnmpInterfaceEntry[] getSnmpInterfaces(Connection db) throws SQLException {
        ArrayList<DbSnmpInterfaceEntry> l;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = db.prepareStatement(SQL_LOAD_SNMP_LIST);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            l = new ArrayList<DbSnmpInterfaceEntry>();
            while (rset.next()) {
                String saddr = rset.getString(1);
                int ifIndex = rset.getInt(2);
                if (rset.wasNull()) {
                    ifIndex = -1;
                }
                if (InetAddressUtils.addr((String)saddr) == null) continue;
                DbSnmpInterfaceEntry entry = null;
                if (ifIndex == -1 || (entry = DbSnmpInterfaceEntry.get(db, this.m_nodeId, ifIndex)) == null) continue;
                l.add(entry);
            }
        }
        finally {
            d.cleanUp();
        }
        DbSnmpInterfaceEntry[] entries = new DbSnmpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    public static DbNodeEntry create() {
        return new DbNodeEntry(DEFAULT_DP_NAME);
    }

    public static DbNodeEntry create(String poller) {
        if (poller == null) {
            poller = DEFAULT_DP_NAME;
        }
        return new DbNodeEntry(poller);
    }

    public static DbNodeEntry clone(DbNodeEntry entry) {
        DbNodeEntry clonedEntry = DbNodeEntry.create();
        clonedEntry.m_fromDb = entry.m_fromDb;
        clonedEntry.m_nodeId = entry.m_nodeId;
        clonedEntry.m_createTime = entry.m_createTime;
        clonedEntry.m_parentId = entry.m_parentId;
        clonedEntry.m_type = entry.m_type;
        clonedEntry.m_sysoid = entry.m_sysoid;
        clonedEntry.m_sysname = entry.m_sysname;
        clonedEntry.m_syslocation = entry.m_syslocation;
        clonedEntry.m_sysdescr = entry.m_sysdescr;
        clonedEntry.m_syscontact = entry.m_syscontact;
        clonedEntry.m_label = entry.m_label;
        clonedEntry.m_labelSource = entry.m_labelSource;
        clonedEntry.m_nbName = entry.m_nbName;
        clonedEntry.m_nbDomainName = entry.m_nbDomainName;
        clonedEntry.m_os = entry.m_os;
        clonedEntry.m_lastPoll = entry.m_lastPoll;
        clonedEntry.m_changed = entry.m_changed;
        return clonedEntry;
    }

    public static DbNodeEntry get(int nid) throws SQLException {
        return DbNodeEntry.get(nid, DEFAULT_DP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbNodeEntry get(int nid, String dpName) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbNodeEntry dbNodeEntry = DbNodeEntry.get(db, nid, dpName);
            return dbNodeEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LOG.warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    public static DbNodeEntry get(Connection db, int nid) throws SQLException {
        return DbNodeEntry.get(db, nid, DEFAULT_DP_NAME);
    }

    public static DbNodeEntry get(Connection db, int nid, String dpName) throws SQLException {
        DbNodeEntry entry = new DbNodeEntry(nid, dpName);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from database            = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier          = ").append(this.m_nodeId).append(sep);
        buf.append("distributed poller       = ").append(this.m_dpName).append(sep);
        buf.append("creation time            = ").append(this.m_createTime).append(sep);
        buf.append("parent identifier        = ").append(this.m_parentId).append(sep);
        buf.append("node type                = ").append(this.m_type).append(sep);
        buf.append("snmp system oid          = ").append(this.m_sysoid).append(sep);
        buf.append("snmp system name         = ").append(this.m_sysname).append(sep);
        buf.append("snmp system description  = ").append(this.m_sysdescr).append(sep);
        buf.append("snmp system location     = ").append(this.m_syslocation).append(sep);
        buf.append("snmp system contact      = ").append(this.m_syscontact).append(sep);
        buf.append("label                    = ").append(this.m_label).append(sep);
        buf.append("label source             = ").append(this.m_labelSource).append(sep);
        buf.append("NetBIOS                  = ").append(this.m_nbName).append(sep);
        buf.append("Domain                   = ").append(this.m_nbDomainName).append(sep);
        buf.append("Operating System         = ").append(this.m_os).append(sep);
        buf.append("last poll time           = ").append(this.m_lastPoll).append(sep);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAssetNodeEntry(Connection conn, int nodeid) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = conn.prepareStatement("INSERT INTO ASSETS (nodeID,category,userLastModified,lastModifiedDate,displayCategory,notifyCategory,pollerCategory,thresholdCategory) values(?,?,?,?,?,?,?,?)");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setString(2, "Unspecified");
            stmt.setString(3, "");
            stmt.setTimestamp(4, new Timestamp(new Date().getTime()));
            stmt.setString(5, "");
            stmt.setString(6, "");
            stmt.setString(7, "");
            stmt.setString(8, "");
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }
}

