/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.util.Enumeration;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final FifoQueue<String> m_execQ;

    BroadcastEventProcessor(FifoQueue<String> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        Enumeration walker = event.enumerateAutoaction();
        while (walker.hasMoreElements()) {
            try {
                Autoaction aact = (Autoaction)walker.nextElement();
                if ("on".equalsIgnoreCase(aact.getState())) {
                    this.m_execQ.add((Object)aact.getContent());
                }
                LOG.debug("Added event '{}' to execute autoaction '{}'", (Object)event.getUei(), (Object)aact.getContent());
            }
            catch (FifoQueueException ex) {
                LOG.error("Failed to add event to execution queue", (Throwable)ex);
                break;
            }
            catch (InterruptedException ex) {
                LOG.error("Failed to add event to execution queue", (Throwable)ex);
                break;
            }
        }
        if (event.getTticket() != null && event.getTticket().getState().equalsIgnoreCase("on")) {
            try {
                this.m_execQ.add((Object)event.getTticket().getContent());
                LOG.debug("Added event '{}' to execute tticket '{}'", (Object)event.getUei(), (Object)event.getTticket().getContent());
            }
            catch (FifoQueueException ex) {
                LOG.error("Failed to add event to execution queue", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                LOG.error("Failed to add event to execution queue", (Throwable)ex);
            }
        }
    }

    public String getName() {
        return "Actiond:BroadcastEventProcessor";
    }
}

