/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.SchedulerRepository;
import org.quartz.spi.JobFactory;

public class RemoteScheduler
implements Scheduler {
    private RemotableQuartzScheduler rsched;
    private SchedulingContext schedCtxt;
    private String schedId;
    private String rmiHost;
    private int rmiPort;

    public RemoteScheduler(SchedulingContext schedCtxt, String schedId, String host, int port) {
        this.schedCtxt = schedCtxt;
        this.schedId = schedId;
        this.rmiHost = host;
        this.rmiPort = port;
    }

    protected RemotableQuartzScheduler getRemoteScheduler() throws SchedulerException {
        if (this.rsched != null) {
            return this.rsched;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(this.rmiHost, this.rmiPort);
            this.rsched = (RemotableQuartzScheduler)registry.lookup(this.schedId);
        }
        catch (Exception e) {
            SchedulerException initException = new SchedulerException("Could not get handle to remote scheduler: " + e.getMessage(), e);
            initException.setErrorCode(200);
            throw initException;
        }
        return this.rsched;
    }

    protected SchedulerException invalidateHandleCreateException(String msg, Exception cause) {
        this.rsched = null;
        SchedulerException ex = new SchedulerException(msg, cause);
        ex.setErrorCode(200);
        return ex;
    }

    public String getSchedulerName() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerName();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String getSchedulerInstanceId() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerInstanceId();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public SchedulerMetaData getMetaData() throws SchedulerException {
        try {
            RemotableQuartzScheduler sched = this.getRemoteScheduler();
            return new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), true, this.isStarted(), this.isInStandbyMode(), this.isShutdown(), sched.runningSince(), sched.numJobsExecuted(), sched.getJobStoreClass(), sched.supportsPersistence(), sched.getThreadPoolClass(), sched.getThreadPoolSize(), sched.getVersion());
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public SchedulerContext getContext() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerContext();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void start() throws SchedulerException {
        try {
            this.getRemoteScheduler().start();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void startDelayed(int seconds) throws SchedulerException {
        try {
            this.getRemoteScheduler().startDelayed(seconds);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void standby() throws SchedulerException {
        try {
            this.getRemoteScheduler().standby();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pause() throws SchedulerException {
        this.standby();
    }

    public boolean isStarted() throws SchedulerException {
        try {
            return this.getRemoteScheduler().runningSince() != null;
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean isInStandbyMode() throws SchedulerException {
        try {
            return this.getRemoteScheduler().isInStandbyMode();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean isPaused() throws SchedulerException {
        return this.isInStandbyMode();
    }

    public void shutdown() throws SchedulerException {
        try {
            String schedulerName = this.getSchedulerName();
            this.getRemoteScheduler().shutdown();
            SchedulerRepository.getInstance().remove(schedulerName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        try {
            String schedulerName = this.getSchedulerName();
            this.getRemoteScheduler().shutdown(waitForJobsToComplete);
            SchedulerRepository.getInstance().remove(schedulerName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean isShutdown() throws SchedulerException {
        try {
            return this.getRemoteScheduler().isShutdown();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public List getCurrentlyExecutingJobs() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCurrentlyExecutingJobs();
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().scheduleJob(this.schedCtxt, jobDetail, trigger);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().scheduleJob(this.schedCtxt, trigger);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        try {
            this.getRemoteScheduler().addJob(this.schedCtxt, jobDetail, replace);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().deleteJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().unscheduleJob(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().rescheduleJob(this.schedCtxt, triggerName, groupName, newTrigger);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.triggerJob(jobName, groupName, null);
    }

    public void triggerJob(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        try {
            this.getRemoteScheduler().triggerJob(this.schedCtxt, jobName, groupName, data);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.triggerJobWithVolatileTrigger(jobName, groupName, null);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        try {
            this.getRemoteScheduler().triggerJobWithVolatileTrigger(this.schedCtxt, jobName, groupName, data);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseTrigger(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseTriggerGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseJobGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeTrigger(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeTriggerGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeJobGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseAll() throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseAll(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeAll() throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeAll(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getJobGroupNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobGroupNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobNames(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggersOfJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerGroupNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerNames(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobDetail(this.schedCtxt, jobName, jobGroup);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTrigger(this.schedCtxt, triggerName, triggerGroup);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerState(this.schedCtxt, triggerName, triggerGroup);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        try {
            this.getRemoteScheduler().addCalendar(this.schedCtxt, calName, calendar, replace, updateTriggers);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean deleteCalendar(String calName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().deleteCalendar(this.schedCtxt, calName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public Calendar getCalendar(String calName) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCalendar(this.schedCtxt, calName);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getCalendarNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCalendarNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getGlobalJobListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public Set getJobListenerNames() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public JobListener getGlobalJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public JobListener getJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getGlobalTriggerListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public Set getTriggerListenerNames() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public TriggerListener getGlobalTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getSchedulerListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public Set getPausedTriggerGroups() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getPausedTriggerGroups(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
        try {
            return this.getRemoteScheduler().interrupt(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new UnableToInterruptJobException(this.invalidateHandleCreateException("Error communicating with remote scheduler.", re));
        }
        catch (SchedulerException se) {
            throw new UnableToInterruptJobException(se);
        }
    }

    public void setJobFactory(JobFactory factory) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }
}

