/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.url;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.url.GenericURLStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericURLFactory
implements URLStreamHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.Output." + GenericURLFactory.class.getName()));
    private Map<String, String> urlConnections = new HashMap<String, String>();
    private Map<String, Integer> urlDefaultPorts = new HashMap<String, Integer>();
    private static GenericURLFactory genericUrlFactory = new GenericURLFactory();

    private GenericURLFactory() {
        this.addURLConnection("dns", "org.opennms.netmgt.provision.service.dns.DnsRequisitionUrlConnection", 53);
        this.addURLConnection("vmware", "org.opennms.netmgt.provision.service.vmware.VmwareRequisitionUrlConnection", 443);
    }

    public static void initialize() {
        try {
            URL.setURLStreamHandlerFactory(genericUrlFactory);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public static GenericURLFactory getInstance() {
        return genericUrlFactory;
    }

    public void addURLConnection(String protocol, String classname, int defaultPort) {
        this.urlConnections.put(protocol, classname);
        this.urlDefaultPorts.put(protocol, defaultPort);
    }

    public void addURLConnection(String protocol, String classname) {
        this.addURLConnection(protocol, classname, -1);
    }

    public void removeURLConnection(String protocol) {
        if (this.urlConnections.containsKey(protocol)) {
            this.urlConnections.remove(protocol);
            this.logger.debug("Remove existing protocol: '{}'", (Object)protocol);
        }
    }

    public Map<String, String> getURLConnections() {
        return this.urlConnections;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        Class<?> c = null;
        if (!this.urlConnections.containsKey(protocol)) {
            this.logger.info("No protocol mapping with '{}' found. Return null. Creating...", (Object)protocol);
            return null;
        }
        try {
            c = Class.forName(this.urlConnections.get(protocol));
        }
        catch (ClassNotFoundException e) {
            this.logger.warn("Class not found for protocol '{}' and return null. Error message: '{}'", (Object)protocol, (Object)e.getMessage());
            return null;
        }
        return new GenericURLStreamHandler(c, this.urlDefaultPorts.get(protocol));
    }
}

