/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(WmiPlugin.class);
    private static final String PROTOCOL_NAME = "WMI";
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_WQL = "NOTSET";
    private static final String DEFAULT_WMI_NAMESPACE = "root/cimv2";

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig(address);
        String matchType = DEFAULT_WMI_MATCH_TYPE;
        String compVal = DEFAULT_WMI_COMP_VAL;
        String compOp = DEFAULT_WMI_COMP_OP;
        String wmiClass = DEFAULT_WMI_CLASS;
        String wmiObject = DEFAULT_WMI_OBJECT;
        String wmiWqlStr = DEFAULT_WMI_WQL;
        String wmiNamespace = DEFAULT_WMI_NAMESPACE;
        if (qualifiers != null) {
            if (qualifiers.get("timeout") != null) {
                int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)agentConfig.getTimeout());
                agentConfig.setTimeout(timeout);
            }
            if (qualifiers.get("retry") != null) {
                int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)agentConfig.getRetries());
                agentConfig.setRetries(retries);
            }
            if (qualifiers.get("username") != null) {
                String user = ParameterMap.getKeyedString(qualifiers, (String)"username", (String)agentConfig.getUsername());
                agentConfig.setUsername(user);
            }
            if (qualifiers.get("password") != null) {
                String pass = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)agentConfig.getPassword());
                agentConfig.setPassword(pass);
            }
            if (qualifiers.get("domain") != null) {
                String domain = ParameterMap.getKeyedString(qualifiers, (String)"domain", (String)agentConfig.getDomain());
                agentConfig.setDomain(domain);
            }
            matchType = ParameterMap.getKeyedString(qualifiers, (String)"matchType", (String)DEFAULT_WMI_MATCH_TYPE);
            compVal = ParameterMap.getKeyedString(qualifiers, (String)"compareValue", (String)DEFAULT_WMI_COMP_VAL);
            compOp = ParameterMap.getKeyedString(qualifiers, (String)"compareOp", (String)DEFAULT_WMI_COMP_OP);
            wmiWqlStr = ParameterMap.getKeyedString(qualifiers, (String)"wql", (String)DEFAULT_WMI_WQL);
            wmiClass = ParameterMap.getKeyedString(qualifiers, (String)"wmiClass", (String)DEFAULT_WMI_CLASS);
            wmiObject = ParameterMap.getKeyedString(qualifiers, (String)"wmiObject", (String)DEFAULT_WMI_OBJECT);
            wmiNamespace = ParameterMap.getKeyedString(qualifiers, (String)"wmiNamespace", (String)DEFAULT_WMI_NAMESPACE);
        }
        WmiParams clientParams = null;
        clientParams = wmiWqlStr.equals(DEFAULT_WMI_WQL) ? new WmiParams("InstanceOf", compVal, compOp, wmiClass, wmiObject) : new WmiParams("Wql", compVal, compOp, wmiWqlStr, wmiObject);
        WmiResult result = this.isServer(address, agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), matchType, agentConfig.getRetries(), agentConfig.getTimeout(), clientParams, wmiNamespace);
        return result != null && result.getResultCode() != 1 && result.getResultCode() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WmiResult isServer(InetAddress host, String user, String pass, String domain, String matchType, int retries, int timeout, WmiParams params, String wmiNamespace) {
        boolean isAServer = false;
        WmiResult result = null;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            WmiManager mgr = null;
            try {
                mgr = new WmiManager(InetAddressUtils.str((InetAddress)host), user, pass, domain, matchType);
                mgr.setNamespace(wmiNamespace);
                mgr.init();
                result = mgr.performOp(params);
                if (params.getWmiOperation().equals("Wql")) {
                    LOG.debug("WmiPlugin: {} :  {}", (Object)params.getWql(), (Object)WmiResult.convertStateToString(result.getResultCode()));
                } else {
                    LOG.debug("\\\\{}\\{} : {}", new Object[]{params.getWmiClass(), params.getWmiObject(), WmiResult.convertStateToString(result.getResultCode())});
                }
                isAServer = true;
                continue;
            }
            catch (WmiException e) {
                LOG.info("WmiPlugin: Check failed.", (Throwable)e);
                isAServer = false;
                continue;
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        LOG.warn("An error occurred closing the WMI manager.", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }
}

