/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.InetAddrXmlAdapter;
import org.opennms.netmgt.snmp.SnmpConfiguration;

@XmlRootElement(name="snmpAgentConfig")
public class SnmpAgentConfig
extends SnmpConfiguration
implements Serializable {
    private static final long serialVersionUID = -6646744513933866811L;
    private InetAddress m_address;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this((InetAddress)null);
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this(agentAddress, SnmpConfiguration.DEFAULTS);
    }

    public SnmpAgentConfig(InetAddress agentAddress, SnmpConfiguration defaults) {
        super(defaults);
        this.m_address = agentAddress;
    }

    public static SnmpAgentConfig parseProtocolConfigurationString(String protocolConfigString) {
        if (protocolConfigString == null) {
            throw new IllegalArgumentException("Protocol configuration string for SnmpAgentConfig must not be null.");
        }
        JSONObject protocolConfig = new JSONObject(new JSONTokener(protocolConfigString)).optJSONObject("snmp");
        if (protocolConfig == null) {
            throw new IllegalArgumentException("Invalid protocol configuration string for SnmpAgentConfig: Expected it to start with snmp object" + protocolConfigString);
        }
        SnmpAgentConfig agentConfig = new SnmpAgentConfig();
        if (!protocolConfig.isNull("address")) {
            agentConfig.setAddress(InetAddrUtils.addr(protocolConfig.optString("address")));
        }
        if (!protocolConfig.isNull("proxyFor")) {
            agentConfig.setProxyFor(InetAddrUtils.addr(protocolConfig.optString("proxyFor")));
        }
        if (!protocolConfig.isNull("port")) {
            agentConfig.setPort(protocolConfig.optInt("port"));
        }
        if (!protocolConfig.isNull("timeout")) {
            agentConfig.setTimeout(protocolConfig.optInt("timeout"));
        }
        if (!protocolConfig.isNull("retries")) {
            agentConfig.setRetries(protocolConfig.optInt("retries"));
        }
        if (!protocolConfig.isNull("max-vars-per-pdu")) {
            agentConfig.setMaxVarsPerPdu(protocolConfig.optInt("max-vars-per-pdu"));
        }
        if (!protocolConfig.isNull("max-repetitions")) {
            agentConfig.setMaxRepetitions(protocolConfig.optInt("max-repetitions"));
        }
        if (!protocolConfig.isNull("max-request-size")) {
            agentConfig.setMaxRequestSize(protocolConfig.optInt("max-request-size"));
        }
        if (!protocolConfig.isNull("version")) {
            agentConfig.setVersion(protocolConfig.optInt("version"));
        }
        if (!protocolConfig.isNull("security-level")) {
            agentConfig.setSecurityLevel(protocolConfig.optInt("security-level"));
        }
        if (!protocolConfig.isNull("security-name")) {
            agentConfig.setSecurityName(protocolConfig.optString("security-name"));
        }
        if (!protocolConfig.isNull("auth-passphrase")) {
            agentConfig.setAuthPassPhrase(protocolConfig.optString("auth-passphrase"));
        }
        if (!protocolConfig.isNull("auth-protocol")) {
            agentConfig.setAuthProtocol(protocolConfig.optString("auth-protocol"));
        }
        if (!protocolConfig.isNull("priv-passphrase")) {
            agentConfig.setPrivPassPhrase(protocolConfig.optString("priv-passphrase"));
        }
        if (!protocolConfig.isNull("priv-protocol")) {
            agentConfig.setPrivProtocol(protocolConfig.optString("priv-protocol"));
        }
        if (!protocolConfig.isNull("context-name")) {
            agentConfig.setContextName(protocolConfig.optString("context-name"));
        }
        if (!protocolConfig.isNull("engine-id")) {
            agentConfig.setEngineId(protocolConfig.optString("engine-id"));
        }
        if (!protocolConfig.isNull("context-engine-id")) {
            agentConfig.setContextEngineId(protocolConfig.optString("context-engine-id"));
        }
        if (!protocolConfig.isNull("enterprise-id")) {
            agentConfig.setEnterpriseId(protocolConfig.optString("enterprise-id"));
        }
        if (!protocolConfig.isNull("read-community")) {
            agentConfig.setReadCommunity(protocolConfig.optString("read-community"));
        }
        if (!protocolConfig.isNull("write-community")) {
            agentConfig.setWriteCommunity(protocolConfig.optString("write-community"));
        }
        return agentConfig;
    }

    public String toProtocolConfigString() {
        return new JSONStringer().object().key("snmp").object().key("address").value(this.m_address == null ? null : InetAddrUtils.str(this.m_address)).key("proxyFor").value(this.m_proxyFor == null ? null : InetAddrUtils.str(this.m_proxyFor)).key("port").value((long)this.getPort()).key("timeout").value((long)this.getTimeout()).key("retries").value((long)this.getRetries()).key("max-vars-per-pdu").value((long)this.getMaxVarsPerPdu()).key("max-repetitions").value((long)this.getMaxRepetitions()).key("max-request-size").value((long)this.getMaxRequestSize()).key("version").value((long)this.getVersion()).key("security-level").value((long)this.getSecurityLevel()).key("security-name").value((Object)this.getSecurityName()).key("auth-passphrase").value((Object)this.getAuthPassPhrase()).key("auth-protocol").value((Object)this.getAuthProtocol()).key("priv-passphrase").value((Object)this.getPrivPassPhrase()).key("priv-protocol").value((Object)this.getPrivProtocol()).key("context-name").value((Object)this.getContextName()).key("engine-id").value((Object)this.getEngineId()).key("context-engine-id").value((Object)this.getContextEngineId()).key("enterprise-id").value((Object)this.getEnterpriseId()).key("read-community").value((Object)this.getReadCommunity()).key("write-community").value((Object)this.getWriteCommunity()).endObject().endObject().toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("SnmpAgentConfig[");
        buff.append("Address: " + InetAddrUtils.str(this.m_address));
        buff.append(", ProxyForAddress: " + InetAddrUtils.str(this.m_proxyFor));
        buff.append(", Port: " + this.getPort());
        buff.append(", Timeout: " + this.getTimeout());
        buff.append(", Retries: " + this.getRetries());
        buff.append(", MaxVarsPerPdu: " + this.getMaxVarsPerPdu());
        buff.append(", MaxRepetitions: " + this.getMaxRepetitions());
        buff.append(", MaxRequestSize: " + this.getMaxRequestSize());
        buff.append(", Version: " + SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.isVersion3()) {
            buff.append(", SecurityLevel: " + this.getSecurityLevel());
            buff.append(", SecurityName: " + this.getSecurityName());
            buff.append(", AuthPassPhrase: " + this.getAuthPassPhrase());
            buff.append(", AuthProtocol: " + this.getAuthProtocol());
            buff.append(", PrivPassphrase: " + this.getPrivPassPhrase());
            buff.append(", PrivProtocol: " + this.getPrivProtocol());
            buff.append(", ContextName: " + this.getContextName());
            buff.append(", EngineId: " + this.getEngineId());
            buff.append(", ContextEngineId: " + this.getContextEngineId());
            buff.append(", EnterpriseId:" + this.getEnterpriseId());
        } else {
            buff.append(", ReadCommunity: " + this.getReadCommunity());
            buff.append(", WriteCommunity: " + this.getWriteCommunity());
        }
        buff.append("]");
        return buff.toString();
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }

    @XmlTransient
    public InetAddress getEffectiveAddress() {
        if (this.m_proxyFor == null) {
            return this.m_address;
        }
        return this.m_proxyFor;
    }

    public int hashCode() {
        int hash = Objects.hash(this.getAddress(), this.getProxyFor(), this.getPort(), this.getTimeout(), this.getRetries(), this.getMaxVarsPerPdu(), this.getMaxRepetitions(), this.getMaxRequestSize(), this.getVersion(), this.getSecurityLevel(), this.getSecurityName(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivProtocol(), this.getContextName(), this.getEngineId(), this.getContextEngineId(), this.getEnterpriseId(), this.getReadCommunity(), this.getWriteCommunity());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            System.err.println("obj = null!");
            return false;
        }
        if (obj instanceof SnmpAgentConfig) {
            SnmpAgentConfig other = (SnmpAgentConfig)obj;
            return Objects.equals(this.getAddress(), other.getAddress()) && Objects.equals(this.getProxyFor(), other.getProxyFor()) && Objects.equals(this.getPort(), other.getPort()) && Objects.equals(this.getTimeout(), other.getTimeout()) && Objects.equals(this.getRetries(), other.getRetries()) && Objects.equals(this.getMaxRepetitions(), other.getMaxRepetitions()) && Objects.equals(this.getMaxRequestSize(), other.getMaxRequestSize()) && Objects.equals(this.getMaxVarsPerPdu(), other.getMaxVarsPerPdu()) && Objects.equals(this.getVersion(), other.getVersion()) && Objects.equals(this.getSecurityLevel(), other.getSecurityLevel()) && Objects.equals(this.getSecurityName(), other.getSecurityName()) && Objects.equals(this.getAuthPassPhrase(), other.getAuthPassPhrase()) && Objects.equals(this.getAuthProtocol(), other.getAuthProtocol()) && Objects.equals(this.getPrivPassPhrase(), other.getPrivPassPhrase()) && Objects.equals(this.getPrivProtocol(), other.getPrivProtocol()) && Objects.equals(this.getEngineId(), other.getEngineId()) && Objects.equals(this.getContextEngineId(), other.getContextEngineId()) && Objects.equals(this.getEnterpriseId(), other.getEnterpriseId()) && Objects.equals(this.getReadCommunity(), other.getReadCommunity()) && Objects.equals(this.getWriteCommunity(), other.getWriteCommunity());
        }
        return false;
    }
}

