/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.ServiceSelector;

public class MonitoredServiceDaoHibernate
extends AbstractDaoHibernate<OnmsMonitoredService, Integer>
implements MonitoredServiceDao {
    public MonitoredServiceDaoHibernate() {
        super(OnmsMonitoredService.class);
    }

    public List<OnmsMonitoredService> findByType(String type) {
        return this.find("from OnmsMonitoredService svc where svc.serviceType.name = ?", type);
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddress, String svcName) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.ipAddress = ? and svc.serviceType.name = ?", nodeId, ipAddress, svcName);
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddress, Integer serviceId) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.ipAddress = ? and svc.serviceType.id = ?", nodeId, ipAddress, serviceId);
    }

    public OnmsMonitoredService getPrimaryService(Integer nodeId, String svcName) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.isSnmpPrimary= ? and svc.serviceType.name = ?", nodeId, PrimaryType.PRIMARY, svcName);
    }

    public OnmsMonitoredService get(Integer nodeId, InetAddress ipAddr, Integer ifIndex, Integer serviceId) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.ipAddress = ? and svc.ipInterface.snmpInterface.ifIndex = ? and svc.serviceType.id = ?", nodeId, ipAddr, ifIndex, serviceId);
    }

    public List<OnmsMonitoredService> findMatchingServices(ServiceSelector selector) {
        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
        HashSet matchingAddrs = new HashSet(FilterDaoFactory.getInstance().getActiveIPAddressList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsMonitoredService> matchingServices = new LinkedList<OnmsMonitoredService>();
        Collection<OnmsMonitoredService> services = this.findActive();
        for (OnmsMonitoredService svc : services) {
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingAddrs.contains(svc.getIpAddress())) continue;
            matchingServices.add(svc);
        }
        return matchingServices;
    }

    private Collection<OnmsMonitoredService> findActive() {
        return this.find("select distinct svc from OnmsMonitoredService as svc left join fetch svc.serviceType left join fetch svc.ipInterface as ip left join fetch ip.node as node left join fetch node.assetRecord where (svc.status is null or svc.status not in ('F','U','D'))");
    }

    public Set<OnmsMonitoredService> findByApplication(OnmsApplication application) {
        return application.getMonitoredServices();
    }
}

