/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.springframework.orm.hibernate3.HibernateCallback;

public class DataLinkInterfaceDaoHibernate
extends AbstractDaoHibernate<DataLinkInterface, Integer>
implements DataLinkInterfaceDao {
    public DataLinkInterfaceDaoHibernate() {
        super(DataLinkInterface.class);
    }

    public Collection<DataLinkInterface> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<DataLinkInterface>>(){

            public Collection<DataLinkInterface> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(DataLinkInterface.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    public DataLinkInterface findById(Integer id) {
        return (DataLinkInterface)this.findUnique("from DataLinkInterface as dli where dli.id = ?", id);
    }

    public Collection<DataLinkInterface> findByNodeId(Integer nodeId) {
        return this.find("from DataLinkInterface as dli where dli.node.id = ?", nodeId);
    }

    public Collection<DataLinkInterface> findByNodeParentId(Integer nodeParentId) {
        return this.find("from DataLinkInterface as dli where dli.nodeParentId = ?", nodeParentId);
    }

    public Collection<DataLinkInterface> findByNodeIdAndIfIndex(Integer nodeId, Integer ifIndex) {
        return this.find("from DataLinkInterface as dli where dli.node.id = ? and dli.ifIndex = ?", nodeId, ifIndex);
    }

    public Collection<DataLinkInterface> findByParentNodeIdAndIfIndex(Integer nodeParentId, Integer parentIfIndex) {
        return this.find("from DataLinkInterface as dli where dli.nodeParentId = ? and dli.parentIfIndex = ?", nodeParentId, parentIfIndex);
    }

    public void markDeletedIfNodeDeleted() {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.eq("node.type", (Object)"D");
        for (DataLinkInterface dataLinkIface : this.findMatching(builder.toCriteria())) {
            dataLinkIface.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(dataLinkIface);
        }
    }

    public void deactivateIfOlderThan(Date scanTime, String source) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("source", (Object)source);
        builder.lt("lastPollTime", (Object)scanTime);
        builder.eq("status", (Object)OnmsArpInterface.StatusType.ACTIVE);
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(iface);
        }
    }

    public void deleteIfOlderThan(Date scanTime, String source) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("source", (Object)source);
        builder.lt("lastPollTime", (Object)scanTime);
        builder.ne("status", (Object)OnmsArpInterface.StatusType.DELETED);
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            this.delete(iface);
        }
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        this.setStatusForNode(nodeid, null, action);
    }

    public void setStatusForNode(Integer nodeid, String source, OnmsArpInterface.StatusType action) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        if (source != null) {
            builder.eq("source", (Object)source);
        }
        builder.or((Restriction)new EqRestriction("node.id", (Object)nodeid), (Restriction)new EqRestriction("nodeParentId", (Object)nodeid));
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, OnmsArpInterface.StatusType action) {
        this.setStatusForNodeAndIfIndex(nodeid, ifIndex, null, action);
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, String source, OnmsArpInterface.StatusType action) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        if (source != null) {
            builder.eq("source", (Object)source);
        }
        builder.or((Restriction)new AllRestriction(new Restriction[]{new EqRestriction("node.id", (Object)nodeid), new EqRestriction("ifIndex", (Object)ifIndex)}), (Restriction)new AllRestriction(new Restriction[]{new EqRestriction("nodeParentId", (Object)nodeid), new EqRestriction("parentIfIndex", (Object)ifIndex)}));
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }
}

