/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.CdpTopologyLink;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;

public class CdpLinkDaoHibernate
extends AbstractDaoHibernate<CdpLink, Integer>
implements CdpLinkDao {
    public CdpLinkDaoHibernate() {
        super(CdpLink.class);
    }

    public CdpLink get(OnmsNode node, Integer cdpCacheifIndex) {
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node = ? and cdpLink.cdpCacheIfIndex = ?", node, cdpCacheifIndex);
    }

    public CdpLink get(Integer nodeId, Integer cdpCacheifIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node.id = ? and cdpLink.cdpCacheIfIndex = ?", nodeId, cdpCacheifIndex);
    }

    public List<CdpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from CdpLink cdpLink where cdpLink.node.id = ?", nodeId);
    }

    public List<CdpTopologyLink> findLinksForTopology() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<CdpTopologyLink>>(){

            public List<CdpTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                List list = session.createSQLQuery("select l.id as sourceid, l.nodeid as sourcenodeid, l.cdpcacheifindex as sourceifindex, l.cdpinterfacename as sourceifname, e.id as targetid, e.nodeid as targetnodeid, l.cdpcachedeviceport as targetifname from cdplink l right join ipinterface e on l.cdpcacheaddress = e.ipaddr where l.cdpcacheaddresstype=1;").list();
                ArrayList<CdpTopologyLink> topoLinks = new ArrayList<CdpTopologyLink>();
                for (Object[] objs : list) {
                    Integer targetId = (Integer)objs[4];
                    Integer targetNodeId = (Integer)objs[5];
                    if (targetId == null || targetNodeId == null) continue;
                    topoLinks.add(new CdpTopologyLink((Integer)objs[0], (Integer)objs[1], (Integer)objs[2], (String)objs[3], (Integer)objs[4], (Integer)objs[5], (String)objs[6]));
                }
                return topoLinks;
            }
        });
    }

    public List<CdpTopologyLink> findLinksForTopologyByIds(final Integer ... ids) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<CdpTopologyLink>>(){

            public List<CdpTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                StringBuffer idList = new StringBuffer();
                String conditional = "";
                if (ids.length > 0) {
                    for (int i = 0; i < ids.length; ++i) {
                        if (i > 0) {
                            idList.append(", ");
                        }
                        idList.append(ids[i]);
                    }
                    conditional = " and (l.id in (" + idList.toString() + ") or e.id in (" + idList.toString() + "))";
                }
                List list = session.createSQLQuery("select l.id as sourceid, l.nodeid as sourcenodeid, l.cdpcacheifindex as sourceifindex, l.cdpinterfacename as sourceifname, e.id as targetid, e.nodeid as targetnodeid, l.cdpcachedeviceport as targetifname from cdplink l right join ipinterface e on l.cdpcacheaddress = e.ipaddr where l.cdpcacheaddresstype=1 " + conditional.toString() + ";").list();
                ArrayList<CdpTopologyLink> topoLinks = new ArrayList<CdpTopologyLink>();
                for (Object[] objs : list) {
                    Integer targetId = (Integer)objs[4];
                    Integer targetNodeId = (Integer)objs[5];
                    if (targetId == null || targetNodeId == null) continue;
                    topoLinks.add(new CdpTopologyLink((Integer)objs[0], (Integer)objs[1], (Integer)objs[2], (String)objs[3], (Integer)objs[4], (Integer)objs[5], (String)objs[6]));
                }
                return topoLinks;
            }
        });
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (CdpLink link : this.find("from CdpLink cdpLink where cdpLink.node.id = ? and cdpLink.cdpLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }
}

