/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class AlarmDaoHibernate
extends AbstractDaoHibernate<OnmsAlarm, Integer>
implements AlarmDao {
    public AlarmDaoHibernate() {
        super(OnmsAlarm.class);
    }

    public OnmsAlarm findByReductionKey(String reductionKey) {
        String hql = "from OnmsAlarm as alarms where alarms.reductionKey = ?";
        return (OnmsAlarm)super.findUnique(hql, reductionKey);
    }

    public List<AlarmSummary> getNodeAlarmSummariesIncludeAcknowledgedOnes(List<Integer> nodeIds) {
        if (nodeIds.size() < 1) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary( node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) ) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity > 3 ");
        if (nodeIds.size() == 1) {
            sql.append("AND node.id = " + nodeIds.get(0) + " ");
        } else {
            sql.append("AND node.id in (");
            for (int i = 0; i < nodeIds.size(); ++i) {
                sql.append(nodeIds.get(i));
                if (i >= nodeIds.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
        }
        sql.append("GROUP BY node.id, node.label ");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }

    public List<EdgeAlarmStatusSummary> getLldpEdgeAlarmSummaries(List<Integer> lldpLinkIds) {
        if (lldpLinkIds.size() < 1) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT new org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary( LEAST(s.id, t.id), GREATEST(s.id, t.id), alarm.uei)\n");
        sql.append("FROM LldpLink as s\n");
        sql.append("LEFT JOIN org.opennms.netmgt.model.LldpLink as t\n");
        sql.append("LEFT JOIN\n");
        sql.append("  OnmsAlarm as alarm\n");
        sql.append("with\n");
        sql.append(" alarm.node.id = s.node.id AND\n");
        sql.append(" s.lldpPortIfindex = alarm.ifindex\n");
        sql.append("GROUP BY\n");
        sql.append(" s.id,\n");
        sql.append(" t.id,\n");
        sql.append(" s.node.id,\n");
        sql.append(" t.node.id,\n");
        sql.append(" alarm.uei,\n");
        sql.append(" alarm.lastEventTime\n");
        sql.append("ORDER BY\n");
        sql.append(" alarm.lastEventTime DESC limit 1");
        return this.findObjects(EdgeAlarmStatusSummary.class, sql.toString(), new Object[0]);
    }

    public List<AlarmSummary> getNodeAlarmSummaries() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary(node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), count(*)) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity > 3 AND alarm.alarmAckTime IS NULL ");
        sql.append("GROUP BY node.id, node.label ");
        sql.append("ORDER BY min(alarm.lastEventTime) DESC, node.label ASC");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }
}

