/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.core.xml.MarshallingExceptionTranslator;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.dao.api.SnmpConfigDao;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.springframework.beans.factory.InitializingBean;

public class FactoryBasedSnmpConfigDao
implements SnmpConfigDao,
InitializingBean {
    private static final MarshallingExceptionTranslator TRANSLATOR = new MarshallingExceptionTranslator();

    private SnmpPeerFactory getSnmpPeerFactory() {
        return SnmpPeerFactory.getInstance();
    }

    public void afterPropertiesSet() throws Exception {
        SnmpPeerFactory.init();
    }

    @Override
    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getSnmpPeerFactory().getAgentConfig(agentAddress);
    }

    @Override
    public SnmpConfiguration getDefaults() {
        SnmpConfig config = this.getSnmpConfig();
        SnmpConfiguration defaults = new SnmpConfiguration();
        if (config.getAuthPassphrase() != null) {
            defaults.setAuthPassPhrase(config.getAuthPassphrase());
        }
        if (config.getAuthProtocol() != null) {
            defaults.setAuthProtocol(config.getAuthProtocol());
        }
        if (config.hasMaxRepetitions()) {
            defaults.setMaxRepetitions(config.getMaxRepetitions().intValue());
        }
        if (config.hasMaxRequestSize()) {
            defaults.setMaxRequestSize(config.getMaxRequestSize().intValue());
        }
        if (config.hasMaxVarsPerPdu()) {
            defaults.setMaxVarsPerPdu(config.getMaxVarsPerPdu().intValue());
        }
        if (config.hasPort()) {
            defaults.setPort(config.getPort().intValue());
        }
        if (config.getPrivacyPassphrase() != null) {
            defaults.setPrivPassPhrase(config.getPrivacyPassphrase());
        }
        if (config.getPrivacyProtocol() != null) {
            defaults.setPrivProtocol(config.getPrivacyProtocol());
        }
        if (config.getReadCommunity() != null) {
            defaults.setReadCommunity(config.getReadCommunity());
        }
        if (config.hasRetry()) {
            defaults.setRetries(config.getRetry().intValue());
        }
        if (config.hasSecurityLevel()) {
            defaults.setSecurityLevel(config.getSecurityLevel().intValue());
        }
        if (config.getSecurityName() != null) {
            defaults.setSecurityName(config.getSecurityName());
        }
        if (config.hasTimeout()) {
            defaults.setTimeout(config.getTimeout().intValue());
        }
        if (config.getVersion() != null) {
            defaults.setVersionAsString(config.getVersion());
        }
        if (config.getWriteCommunity() != null) {
            defaults.setWriteCommunity(config.getWriteCommunity());
        }
        return defaults;
    }

    private boolean nullSafeEquals(String o1, String o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void saveAsDefaults(SnmpConfiguration newDefaults) {
        SnmpConfig config = this.getSnmpConfig();
        SnmpConfiguration oldDefaults = this.getDefaults();
        if (!this.nullSafeEquals(oldDefaults.getAuthPassPhrase(), newDefaults.getAuthPassPhrase())) {
            config.setAuthPassphrase(newDefaults.getAuthPassPhrase());
        }
        if (!this.nullSafeEquals(oldDefaults.getAuthProtocol(), newDefaults.getAuthProtocol())) {
            config.setAuthProtocol(newDefaults.getAuthProtocol());
        }
        if (oldDefaults.getMaxRepetitions() != newDefaults.getMaxRepetitions()) {
            config.setMaxRepetitions(Integer.valueOf(newDefaults.getMaxRepetitions()));
        }
        if (oldDefaults.getMaxRequestSize() != newDefaults.getMaxRequestSize()) {
            config.setMaxRequestSize(Integer.valueOf(newDefaults.getMaxRequestSize()));
        }
        if (oldDefaults.getMaxVarsPerPdu() != newDefaults.getMaxVarsPerPdu()) {
            config.setMaxVarsPerPdu(Integer.valueOf(newDefaults.getMaxVarsPerPdu()));
        }
        if (oldDefaults.getPort() != newDefaults.getPort()) {
            config.setPort(Integer.valueOf(newDefaults.getPort()));
        }
        if (!this.nullSafeEquals(oldDefaults.getPrivPassPhrase(), newDefaults.getPrivPassPhrase())) {
            config.setPrivacyPassphrase(newDefaults.getPrivPassPhrase());
        }
        if (!this.nullSafeEquals(oldDefaults.getPrivProtocol(), newDefaults.getPrivProtocol())) {
            config.setPrivacyProtocol(newDefaults.getPrivProtocol());
        }
        if (!this.nullSafeEquals(oldDefaults.getReadCommunity(), newDefaults.getReadCommunity())) {
            config.setReadCommunity(newDefaults.getReadCommunity());
        }
        if (oldDefaults.getRetries() != newDefaults.getRetries()) {
            config.setRetry(Integer.valueOf(newDefaults.getRetries()));
        }
        if (oldDefaults.getSecurityLevel() != newDefaults.getSecurityLevel()) {
            config.setSecurityLevel(Integer.valueOf(newDefaults.getSecurityLevel()));
        }
        if (!this.nullSafeEquals(oldDefaults.getSecurityName(), newDefaults.getSecurityName())) {
            config.setSecurityName(newDefaults.getSecurityName());
        }
        if (oldDefaults.getTimeout() != newDefaults.getTimeout()) {
            config.setTimeout(Integer.valueOf(newDefaults.getTimeout()));
        }
        if (oldDefaults.getVersion() != newDefaults.getVersion()) {
            config.setVersion(newDefaults.getVersionAsString());
        }
        if (!this.nullSafeEquals(oldDefaults.getWriteCommunity(), newDefaults.getWriteCommunity())) {
            config.setWriteCommunity(newDefaults.getWriteCommunity());
        }
        this.saveCurrent();
    }

    @Override
    public void saveOrUpdate(SnmpAgentConfig newConfig) {
        SnmpAgentConfig oldConfig = this.getAgentConfig(newConfig.getAddress());
        SnmpEventInfo eventInfo = new SnmpEventInfo();
        eventInfo.setFirstIPAddress(newConfig.getAddress());
        eventInfo.setLastIPAddress(newConfig.getAddress());
        boolean save = false;
        if (!this.nullSafeEquals(oldConfig.getReadCommunity(), newConfig.getReadCommunity())) {
            eventInfo.setReadCommunityString(newConfig.getReadCommunity());
            save = true;
        }
        if (oldConfig.getPort() != newConfig.getPort()) {
            eventInfo.setPort(newConfig.getPort());
            save = true;
        }
        if (oldConfig.getRetries() != newConfig.getRetries()) {
            eventInfo.setRetryCount(newConfig.getRetries());
            save = true;
        }
        if (oldConfig.getTimeout() != newConfig.getTimeout()) {
            eventInfo.setTimeout(newConfig.getTimeout());
            save = true;
        }
        if (oldConfig.getVersion() != newConfig.getVersion()) {
            eventInfo.setVersion(newConfig.getVersionAsString());
            save = true;
        }
        if (save) {
            this.getSnmpPeerFactory().define(eventInfo);
            this.saveCurrent();
        }
    }

    private SnmpConfig getSnmpConfig() {
        return SnmpPeerFactory.getInstance().getSnmpConfig();
    }

    private void saveCurrent() {
        try {
            SnmpPeerFactory.getInstance().saveCurrent();
        }
        catch (IOException e) {
            TRANSLATOR.translate("save current SNMP configure", e);
        }
    }

    public void define(SnmpEventInfo info) {
        this.getSnmpPeerFactory().define(info);
    }
}

