/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SnmpPeerFactory
implements SnmpAgentConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPeerFactory.class);
    private static final ReadWriteUpdateLock m_globalLock = new ReentrantReadWriteUpdateLock();
    private static final Lock m_readLock = m_globalLock.updateLock();
    private static final Lock m_writeLock = m_globalLock.writeLock();
    private static SnmpPeerFactory m_singleton = null;
    private static File m_configFile;
    private SnmpConfig m_config;
    private static FileReloadContainer<SnmpConfig> m_container;
    private static FileReloadCallback<SnmpConfig> m_callback;
    private static volatile boolean m_loaded;
    private static final int VERSION_UNSPECIFIED = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(Resource resource) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            SnmpConfig config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
            try {
                File file = resource.getFile();
                if (file != null) {
                    m_callback = new FileReloadCallback<SnmpConfig>(){

                        public SnmpConfig reload(SnmpConfig object, Resource resource) throws IOException {
                            return (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
                        }
                    };
                    m_container = new FileReloadContainer((Object)config, resource, m_callback);
                    return;
                }
            }
            catch (IOException e) {
                LOG.debug("No file associated with resource {}, skipping reload container initialization.", (Object)resource);
            }
            this.m_config = config;
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    protected static Lock getReadLock() {
        return m_readLock;
    }

    protected static Lock getWriteLock() {
        return m_writeLock;
    }

    public static synchronized void init() throws IOException {
        if (!m_loaded) {
            File cfgFile = SnmpPeerFactory.getFile();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileSystemResource resource = new FileSystemResource(cfgFile);
            m_singleton = new SnmpPeerFactory((Resource)resource);
            m_loaded = true;
        }
    }

    public static synchronized SnmpPeerFactory getInstance() {
        if (!m_loaded) {
            try {
                SnmpPeerFactory.init();
            }
            catch (IOException e) {
                LOG.error("Failed to initialize SnmpPeerFactory instance!", (Throwable)e);
            }
        }
        return m_singleton;
    }

    public static synchronized void setInstance(SnmpPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public static synchronized File getFile() throws IOException {
        if (m_configFile == null) {
            SnmpPeerFactory.setFile(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
        }
        return m_configFile;
    }

    public static synchronized void setFile(File configFile) {
        File oldFile = m_configFile;
        m_configFile = configFile;
        if (oldFile == null || m_configFile == null || !oldFile.equals(m_configFile)) {
            m_singleton = null;
            m_loaded = false;
        }
    }

    public void saveCurrent() throws IOException {
        this.saveToFile(SnmpPeerFactory.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        SnmpPeerFactory.getWriteLock().lock();
        String marshalledConfig = this.getSnmpConfigAsString();
        FileOutputStream out = null;
        OutputStreamWriter fileWriter = null;
        try {
            if (marshalledConfig != null) {
                out = new FileOutputStream(file);
                fileWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                fileWriter.write(marshalledConfig);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                if (m_container != null) {
                    m_container.reload();
                }
            }
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(out);
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        SnmpPeerFactory.getReadLock().lock();
        try {
            if (this.getSnmpConfig() == null) {
                SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
                if (requestedSnmpVersion == -1) {
                    agentConfig.setVersion(1);
                } else {
                    agentConfig.setVersion(requestedSnmpVersion);
                }
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
            AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agentInetAddress);
            this.getSnmpConfig().visit((SnmpConfigVisitor)visitor);
            Definition matchingDef = visitor.getDefinition();
            if (matchingDef != null) {
                this.setSnmpAgentConfig(agentConfig, matchingDef, requestedSnmpVersion);
            }
            SnmpAgentConfig snmpAgentConfig = agentConfig;
            return snmpAgentConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.getVersionCode(def, this.getSnmpConfig(), requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(def.getSecurityLevel().intValue());
        agentConfig.setSecurityName(def.getSecurityName());
        agentConfig.setAuthProtocol(def.getAuthProtocol());
        agentConfig.setAuthPassPhrase(def.getAuthPassphrase());
        agentConfig.setPrivPassPhrase(def.getPrivacyPassphrase());
        agentConfig.setPrivProtocol(def.getPrivacyProtocol());
        agentConfig.setReadCommunity(def.getReadCommunity());
        agentConfig.setWriteCommunity(def.getWriteCommunity());
        agentConfig.setContextName(def.getContextName());
        agentConfig.setEngineId(def.getEngineId());
        agentConfig.setContextEngineId(def.getContextEngineId());
        agentConfig.setEnterpriseId(def.getEnterpriseId());
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(def.getPort().intValue());
        agentConfig.setRetries(def.getRetry().intValue());
        agentConfig.setTimeout(def.getTimeout().intValue());
        agentConfig.setMaxRequestSize(def.getMaxRequestSize().intValue());
        agentConfig.setMaxVarsPerPdu(def.getMaxVarsPerPdu().intValue());
        agentConfig.setMaxRepetitions(def.getMaxRepetitions().intValue());
        InetAddress proxyHost = InetAddressUtils.addr((String)def.getProxyHost());
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(proxyHost);
        }
    }

    public int getVersionCode(Definition def, SnmpConfig config, int requestedSnmpVersion) {
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (config.getVersion() == null) {
                    return 1;
                }
                return SnmpConfiguration.stringToVersion((String)config.getVersion());
            }
            return SnmpConfiguration.stringToVersion((String)def.getVersion());
        }
        return requestedSnmpVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpConfig getSnmpConfig() {
        SnmpPeerFactory.getReadLock().lock();
        try {
            if (m_container == null) {
                SnmpConfig snmpConfig = this.m_config;
                return snmpConfig;
            }
            SnmpConfig snmpConfig = (SnmpConfig)m_container.getObject();
            return snmpConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void define(SnmpEventInfo info) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            SnmpConfigManager mgr = new SnmpConfigManager(this.getSnmpConfig());
            mgr.mergeIntoConfig(info.createDef());
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSnmpConfigAsString() {
        String marshalledConfig = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JaxbUtils.marshal((Object)this.getSnmpConfig(), (Writer)writer);
            marshalledConfig = writer.toString();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return marshalledConfig;
    }

    static {
        m_loaded = false;
    }
}

