/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.netmgt.config.MergeableDefinition;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;

public class SnmpConfigManager {
    private SnmpConfig m_config;
    private List<MergeableDefinition> m_definitions = new ArrayList<MergeableDefinition>();

    public SnmpConfigManager(SnmpConfig config) {
        this.m_config = config;
        for (Definition def : this.m_config.getDefinitions()) {
            this.m_definitions.add(new MergeableDefinition(def));
        }
    }

    private void removeDefaults(Definition def) {
        if (SnmpConfigManager.areEquals(this.m_config.getPort(), def.getPort())) {
            def.setPort(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getAuthPassphrase(), def.getAuthPassphrase())) {
            def.setAuthPassphrase(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getAuthProtocol(), def.getAuthProtocol())) {
            def.setAuthProtocol(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getContextEngineId(), def.getContextEngineId())) {
            def.setContextEngineId(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getContextName(), def.getContextName())) {
            def.setContextName(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getEngineId(), def.getEngineId())) {
            def.setEngineId(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getEnterpriseId(), def.getEnterpriseId())) {
            def.setEnterpriseId(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getMaxRepetitions(), def.getMaxRepetitions())) {
            def.setMaxRepetitions(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getMaxVarsPerPdu(), def.getMaxVarsPerPdu())) {
            def.setMaxVarsPerPdu(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getPrivacyPassphrase(), def.getPrivacyPassphrase())) {
            def.setPrivacyPassphrase(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getPrivacyProtocol(), def.getPrivacyProtocol())) {
            def.setPrivacyProtocol(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getProxyHost(), def.getProxyHost())) {
            def.setProxyHost(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getMaxRequestSize(), def.getMaxRequestSize())) {
            def.setMaxRequestSize(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getWriteCommunity(), def.getWriteCommunity())) {
            def.setWriteCommunity(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getVersion(), def.getVersion())) {
            def.setVersion(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getTimeout(), def.getTimeout())) {
            def.setTimeout(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getSecurityName(), def.getSecurityName())) {
            def.setSecurityName(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getSecurityLevel(), def.getSecurityLevel())) {
            def.setSecurityLevel(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getRetry(), def.getRetry())) {
            def.setRetry(null);
        }
        if (SnmpConfigManager.areEquals(this.m_config.getReadCommunity(), def.getReadCommunity())) {
            def.setReadCommunity(null);
        }
    }

    public SnmpConfig getConfig() {
        return this.m_config;
    }

    private List<MergeableDefinition> getDefinitions() {
        return this.m_definitions;
    }

    private void addDefinition(MergeableDefinition def) {
        this.m_definitions.add(def);
        this.getConfig().addDefinition(def.getConfigDef());
    }

    private void removeEmptyDefinitions() {
        Iterator<MergeableDefinition> iter = this.getDefinitions().iterator();
        while (iter.hasNext()) {
            MergeableDefinition def = iter.next();
            if (!def.isEmpty()) continue;
            this.getConfig().removeDefinition(def.getConfigDef());
            iter.remove();
        }
    }

    public void mergeIntoConfig(Definition eventDef) {
        this.removeDefaults(eventDef);
        MergeableDefinition eventToMerge = new MergeableDefinition(eventDef);
        this.purgeRangesFromDefinitions(eventToMerge);
        if (eventToMerge.isTrivial()) {
            return;
        }
        MergeableDefinition matchingDef = this.findMatchingDefinition(eventToMerge);
        if (matchingDef == null) {
            this.addDefinition(eventToMerge);
        } else {
            matchingDef.mergeMatchingAttributeDef(eventToMerge);
        }
    }

    private void purgeRangesFromDefinitions(MergeableDefinition eventDefinition) {
        for (MergeableDefinition def : this.getDefinitions()) {
            def.removeRanges(eventDefinition);
        }
        this.removeEmptyDefinitions();
    }

    private MergeableDefinition findMatchingDefinition(MergeableDefinition def) {
        for (MergeableDefinition d : this.getDefinitions()) {
            if (!d.matches(def)) continue;
            return d;
        }
        return null;
    }

    protected static final <T> boolean areEquals(T obj1, T obj2) {
        boolean match = false;
        if (obj1 == null && obj2 == null) {
            match = true;
        } else if (obj1 == null || obj2 == null) {
            match = false;
        } else if (obj1.equals(obj2)) {
            match = true;
        }
        return match;
    }
}

