/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.beans.PropertyVetoException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.ClosableDataSource;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnectionFactory
implements ClosableDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConnectionFactory.class);

    protected BaseConnectionFactory(JdbcDataSource ds) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        this.initializePool(ds);
    }

    protected abstract void initializePool(JdbcDataSource var1) throws SQLException;

    public abstract String getUrl();

    public abstract void setUrl(String var1);

    public abstract String getUser();

    public abstract void setUser(String var1);

    public abstract DataSource getDataSource();

    @Override
    public abstract int getLoginTimeout() throws SQLException;

    @Override
    public void close() {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected static void validateJdbcUrl(String url) {
        try {
            if (url == null) {
                throw new IllegalArgumentException("Null JDBC URL");
            }
            if (url.length() == 0) {
                throw new IllegalArgumentException("Blank JDBC URL");
            }
            if (url.matches("\\$\\{.*\\}")) {
                throw new IllegalArgumentException("JDBC URL cannot contain replacement tokens");
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid JDBC URL specified: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }
}

