/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.config.viewsdisplay.Viewinfo;

public class ViewsDisplayFactory {
    private static ViewsDisplayFactory m_instance;
    protected File m_viewsDisplayFile;
    protected boolean initialized = false;
    protected long m_lastModified;
    protected Map<String, View> m_viewsMap;
    private Viewinfo m_viewInfo;

    private ViewsDisplayFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        this.reload();
    }

    public ViewsDisplayFactory(String file) throws MarshalException, ValidationException, FileNotFoundException, IOException {
        this.setViewsDisplayFile(new File(file));
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            ViewsDisplayFactory.setInstance(new ViewsDisplayFactory());
        }
    }

    public static synchronized ViewsDisplayFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call ViewDisplay.init() before calling getInstance().");
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        InputStream stream = null;
        try {
            stream = this.getStream();
            this.unmarshal(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private void unmarshal(InputStream stream) throws MarshalException, ValidationException {
        this.m_viewInfo = (Viewinfo)CastorUtils.unmarshal(Viewinfo.class, (InputStream)stream);
        this.updateViewsMap();
    }

    private void updateViewsMap() {
        HashMap<String, View> viewsMap = new HashMap<String, View>();
        for (View view : this.m_viewInfo.getViewCollection()) {
            viewsMap.put(view.getViewName(), view);
        }
        this.m_viewsMap = viewsMap;
    }

    private InputStream getStream() throws IOException {
        File viewsDisplayFile = this.getViewsDisplayFile();
        this.m_lastModified = viewsDisplayFile.lastModified();
        return new FileInputStream(viewsDisplayFile);
    }

    public void setViewsDisplayFile(File viewsDisplayFile) {
        this.m_viewsDisplayFile = viewsDisplayFile;
    }

    public File getViewsDisplayFile() throws IOException {
        if (this.m_viewsDisplayFile == null) {
            this.m_viewsDisplayFile = ConfigFileConstants.getFile((int)ConfigFileConstants.VIEWS_DISPLAY_CONF_FILE_NAME);
        }
        return this.m_viewsDisplayFile;
    }

    public View getView(String viewName) throws IOException, MarshalException, ValidationException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        View view = this.m_viewsMap.get(viewName);
        return view;
    }

    public View getDefaultView() {
        return this.m_viewsMap.get(this.m_viewInfo.getDefaultView());
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_viewsDisplayFile.lastModified()) {
            this.reload();
        }
    }

    public static void setInstance(ViewsDisplayFactory instance) {
        m_instance = instance;
        ViewsDisplayFactory.m_instance.initialized = true;
    }

    public int getDisconnectTimeout() {
        return this.m_viewInfo.getDisconnectTimeout();
    }
}

