/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import simple.util.net.Path;
import simple.util.parse.Parser;

public class PathParser
extends Parser
implements Path {
    private static String[] langs = Locale.getISOLanguages();
    private static String[] countrys = Locale.getISOCountries();
    private TokenList list = new TokenList();
    private Token country = new Token();
    private Token lang = new Token();
    private Token name;
    private Token ext = new Token();
    private Token dir = new Token();
    private Token path = new Token();

    static {
        Arrays.sort(countrys);
        Arrays.sort(langs);
    }

    public PathParser() {
        this.name = new Token();
    }

    public PathParser(String path) {
        this();
        this.parse(path);
    }

    protected void parse() {
        this.normalize();
        this.path();
        this.segments();
        this.name();
        this.extension();
        this.locale();
    }

    protected void init() {
        this.list.clear();
        this.country.clear();
        this.lang.clear();
        this.ext.clear();
        this.dir.clear();
        this.name.clear();
        this.path.clear();
        this.off = 0;
    }

    public String getLanguage() {
        return this.lang.toString();
    }

    public String getCountry() {
        return this.country.toString();
    }

    public String getExtension() {
        return this.ext.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getDirectory() {
        return this.dir.toString();
    }

    public String[] getSegments() {
        return this.list.list();
    }

    public String getRelative(String path) {
        return this.getRelative(new PathParser(path));
    }

    private String getRelative(PathParser path) {
        char[] text = path.buf;
        int off = path.dir.off;
        int len = path.dir.len;
        return this.getRelative(text, off, len);
    }

    private String getRelative(char[] text, int off, int len) {
        int size = this.path.len - len + 1;
        int pos = this.path.off + len - 1;
        int i = 0;
        while (i < len) {
            if (text[off++] != this.buf[this.path.off + i]) {
                return null;
            }
            ++i;
        }
        if (pos < 0) {
            return null;
        }
        return new String(this.buf, pos, size);
    }

    private void path() {
        if (this.count > 0) {
            this.path.len = this.count;
            this.path.off = 0;
        }
    }

    private void extension() {
        int pos = this.off + this.count;
        int len = 0;
        while (pos - 1 >= this.off) {
            if (this.buf[--pos] == '.') {
                this.ext.off = pos + 1;
                this.ext.len = len;
                this.count = pos;
                break;
            }
            ++len;
        }
    }

    private void locale() {
        int pos = this.count;
        while (pos - 1 >= this.off) {
            if (this.buf[--pos] != '.') continue;
            if (this.isLanguage(++pos)) {
                switch (this.count - pos) {
                    case 5: {
                        if (this.buf[pos + 2] != '_' || !this.isCountry(pos + 3)) break;
                        this.country();
                        --this.count;
                    }
                    case 2: {
                        this.language();
                        --this.count;
                    }
                }
            }
            return;
        }
    }

    private void country() {
        if (this.off < this.count - 2) {
            this.country.off = this.count - 2;
            this.country.len = 2;
            this.count -= 2;
        }
    }

    private void language() {
        if (this.off < this.count - 2) {
            this.lang.off = this.count - 2;
            this.lang.len = 2;
            this.count -= 2;
        }
    }

    private void segments() {
        int pos = this.count - 1;
        int len = 1;
        if (this.count > 0) {
            if (this.buf[pos] == '/') {
                this.dir.len = pos + 1;
                this.dir.off = 0;
                --pos;
            }
            while (pos >= this.off) {
                if (this.buf[pos] == '/') {
                    if (this.dir.len == 0) {
                        this.dir.len = pos + 1;
                        this.dir.off = 0;
                    }
                    this.list.add(pos + 1, len - 1);
                    len = 0;
                }
                ++len;
                --pos;
            }
        }
    }

    private void normalize() {
        int size = this.count + this.off;
        int mark = this.off;
        int pos = this.off;
        this.count = 0;
        this.off = 0;
        while (pos < size) {
            this.buf[this.count++] = this.buf[pos];
            if (this.buf[pos] == '/') {
                if (this.count - 1 > 0 && this.buf[this.count - 2] == '/') {
                    --this.count;
                }
            } else if (this.buf[pos] == '.' && (this.count - 1 <= 0 || this.buf[this.count - 2] == '/')) {
                if (pos + 2 > size) {
                    --this.count;
                } else {
                    if (this.buf[pos + 1] == '/') {
                        ++pos;
                        --this.count;
                    }
                    if (this.buf[pos] == '.' && (pos + 2 >= size || this.buf[pos + 2] == '/')) {
                        if (this.count - 2 <= 0) {
                            this.count = 0;
                            this.off = 0;
                            break;
                        }
                        this.count -= 2;
                        while (this.count - 1 > 0) {
                            if (this.buf[this.count - 1] != '/') {
                                --this.count;
                                continue;
                            }
                            break;
                        }
                        pos += 2;
                    }
                }
            }
            ++pos;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void name() {
        pos = this.count;
        len = 0;
        if (true) ** GOTO lbl15
        do {
            if (this.buf[pos] == ';') {
                if (this.buf[pos - 1] == '/') {
                    // empty if block
                }
                len = 0;
            } else {
                if (this.buf[pos] == '/') {
                    this.off = pos + 1;
                    this.count = len;
                    break;
                }
                ++len;
            }
lbl15:
            // 3 sources

            v0 = --pos;
            --pos;
        } while (v0 > this.off);
        this.name.len = this.count;
        this.name.off = this.off;
    }

    private boolean isLanguage(int pos) {
        if (pos + 1 >= this.count) {
            return false;
        }
        return Arrays.binarySearch(langs, new String(this.buf, pos, 2)) > 0;
    }

    private boolean isCountry(int pos) {
        if (pos + 1 >= this.count) {
            return false;
        }
        return Arrays.binarySearch(countrys, new String(this.buf, pos, 2)) > 0;
    }

    public String toString() {
        return this.getPath();
    }

    private class Token
    implements Serializable {
        public String value;
        public int off;
        public int len;

        private Token() {
        }

        public void clear() {
            this.value = null;
            this.len = 0;
        }

        public String toString() {
            if (this.value != null) {
                return this.value;
            }
            if (this.len > 0) {
                this.value = new String(PathParser.this.buf, this.off, this.len);
            }
            return this.value;
        }
    }

    private class TokenList
    implements Serializable {
        private int[] list = new int[16];
        private int count;

        private TokenList() {
        }

        public void add(int off, int len) {
            if (this.count + 1 > this.list.length) {
                this.resize(this.count * 2);
            }
            this.list[this.count++] = off;
            this.list[this.count++] = len;
        }

        public String[] list() {
            String[] value = new String[this.count / 2];
            int i = 0;
            int j = this.count / 2;
            while (i < this.count) {
                value[j - i / 2 - 1] = new String(PathParser.this.buf, this.list[i], this.list[i + 1]);
                i += 2;
            }
            return value;
        }

        public void clear() {
            this.count = 0;
        }

        private void resize(int size) {
            int[] copy = new int[size];
            System.arraycopy(this.list, 0, copy, 0, this.count);
            this.list = copy;
        }
    }
}

