/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.rt;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTracker<ReqT extends Request<?, ReqT, ReplyT>, ReplyT extends Response> {
    private static final Logger s_log = Logger.getLogger(RequestTracker.class);
    private RequestLocator<ReqT, ReplyT> m_requestLocator;
    private Messenger<ReqT, ReplyT> m_messenger;
    private BlockingQueue<ReplyT> m_pendingReplyQueue;
    private DelayQueue<ReqT> m_timeoutQueue;
    private Thread m_replyProcessor;
    private Thread m_timeoutProcessor;
    private static final int NEW = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private AtomicInteger m_state = new AtomicInteger(0);

    public RequestTracker(String name, Messenger<ReqT, ReplyT> messenger, RequestLocator<ReqT, ReplyT> requestLocator) throws IOException {
        this.m_requestLocator = requestLocator;
        this.m_pendingReplyQueue = new LinkedBlockingQueue<ReplyT>();
        this.m_timeoutQueue = new DelayQueue();
        this.m_replyProcessor = new Thread(String.valueOf(name) + "-Reply-Processor"){

            public void run() {
                try {
                    RequestTracker.this.processReplies();
                }
                catch (InterruptedException e) {
                    RequestTracker.this.errorf("Thread %s interrupted!", new Object[]{this});
                }
                catch (Throwable t) {
                    RequestTracker.this.errorf(t, "Unexpected exception on Thread %s!", new Object[]{this});
                }
            }
        };
        this.m_timeoutProcessor = new Thread(String.valueOf(name) + "-Timeout-Processor"){

            public void run() {
                try {
                    RequestTracker.this.processTimeouts();
                }
                catch (InterruptedException e) {
                    RequestTracker.this.errorf("Thread %s interrupted!", new Object[]{this});
                }
                catch (Throwable t) {
                    RequestTracker.this.errorf(t, "Unexpected exception on Thread %s!", new Object[]{this});
                }
            }
        };
        this.m_messenger = messenger;
    }

    public synchronized void start() {
        boolean startNeeded = this.m_state.compareAndSet(0, 1);
        if (startNeeded) {
            this.m_messenger.start(this.m_pendingReplyQueue);
            this.m_timeoutProcessor.start();
            this.m_replyProcessor.start();
            this.m_state.set(2);
        }
    }

    public void assertStarted() {
        boolean started;
        boolean bl = started = this.m_state.get() == 2;
        if (!started) {
            throw new IllegalStateException("RequestTracker not started!");
        }
    }

    public void sendRequest(ReqT request) throws Exception {
        this.assertStarted();
        if (!this.m_requestLocator.trackRequest(request)) {
            return;
        }
        this.m_messenger.sendRequest(request);
        this.debugf("Scheding timeout for request to %s in %d ms", request, request.getDelay(TimeUnit.MILLISECONDS));
        this.m_timeoutQueue.offer(request);
    }

    private void processReplies() throws InterruptedException {
        while (true) {
            Response reply = (Response)this.m_pendingReplyQueue.take();
            this.debugf("Found a reply to process: %s", reply);
            ReqT request = this.locateMatchingRequest(reply);
            if (request != null) {
                if (!this.processReply(reply, request)) continue;
                this.m_requestLocator.requestComplete(request);
                continue;
            }
            this.debugf("No request found for reply %s", reply);
        }
    }

    private ReqT locateMatchingRequest(ReplyT reply) {
        try {
            return (ReqT)((Request)this.m_requestLocator.locateMatchingRequest(reply));
        }
        catch (Throwable t) {
            this.errorf(t, "Unexpected error locating response to request %s. Discarding response!", reply);
            return null;
        }
    }

    private boolean processReply(ReplyT reply, ReqT request) {
        try {
            this.debugf("Processing reply %s for request %s", reply, request);
            return request.processResponse(reply);
        }
        catch (Throwable t) {
            this.errorf(t, "Unexpected error processingResponse to request: %s, reply is %s", request, reply);
            return true;
        }
    }

    private void processTimeouts() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    Request timedOutRequest = (Request)this.m_timeoutQueue.take();
                    this.processNextTimeout(timedOutRequest);
                }
            }
            catch (Throwable t) {
                this.errorf(t, "Unexpected error processingTimeout!", new Object[0]);
                continue;
            }
            break;
        }
    }

    private void processNextTimeout(ReqT timedOutRequest) {
        if (timedOutRequest.isProcessed()) {
            return;
        }
        this.debugf("Found a possibly timedout request: %s", timedOutRequest);
        Request pendingRequest = (Request)this.m_requestLocator.requestTimedOut(timedOutRequest);
        if (pendingRequest == timedOutRequest) {
            ReqT retry = this.processTimeout(timedOutRequest);
            if (retry != null) {
                try {
                    this.sendRequest(retry);
                }
                catch (Exception e) {
                    retry.processError(e);
                }
            }
        } else if (pendingRequest != null) {
            String msg = String.format("A pending request %s with the same id exists but is not the timeout request %s from the queue!", pendingRequest, timedOutRequest);
            this.errorf(msg, new Object[0]);
            timedOutRequest.processError(new IllegalStateException(msg));
        }
    }

    private ReqT processTimeout(ReqT request) {
        try {
            this.debugf("Processing timeout for: %s", request);
            return (ReqT)request.processTimeout();
        }
        catch (Throwable t) {
            this.errorf(t, "Unexpected error processingTimout to request: %s", request);
            return null;
        }
    }

    private Category log() {
        return s_log;
    }

    private void debugf(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)String.format(format, args));
        }
    }

    private void errorf(String format, Object ... args) {
        this.log().error((Object)String.format(format, args));
    }

    private void errorf(Throwable t, String format, Object ... args) {
        this.log().error((Object)String.format(format, args), t);
    }
}

