/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpAgentConfig;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpTrapNotifier;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValueFactory;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpWalker;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoeSnmpStrategy
implements SnmpStrategy {
    public static final transient Logger LOG = LoggerFactory.getLogger(JoeSnmpStrategy.class);
    private static Map<TrapNotificationListener, RegistrationInfo> s_registrations = new HashMap<TrapNotificationListener, RegistrationInfo>();
    private static SnmpTrapSession s_trapSession;
    private JoeSnmpValueFactory m_valueFactory;

    public SnmpWalker createWalker(SnmpAgentConfig snmpAgentConfig, String name, CollectionTracker tracker) {
        return new JoeSnmpWalker(new JoeSnmpAgentConfig(snmpAgentConfig), name, tracker);
    }

    public SnmpValue set(SnmpAgentConfig snmpAgentConfig, SnmpObjId oid, SnmpValue value) {
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] values = new SnmpValue[]{value};
        return this.set(snmpAgentConfig, oids, values)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpValue[] set(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        JoeSnmpAgentConfig agentConfig = new JoeSnmpAgentConfig(snmpAgentConfig);
        SnmpSession session = null;
        SnmpSyntax[] syntaxvalues = new SnmpSyntax[values.length];
        for (int i = 0; i < values.length; ++i) {
            syntaxvalues[i] = new JoeSnmpValue(values[i].getType(), values[i].getBytes()).getSnmpSyntax();
        }
        values = null;
        try {
            SnmpPeer peer = this.createPeer(agentConfig);
            SnmpParameters params = new SnmpParameters();
            this.setParameters(agentConfig, params);
            peer.setParameters(params);
            this.configurePeer(peer, agentConfig);
            session = new SnmpSession(peer);
            SnmpObjectId[] jOids = this.convertOids(oids);
            SnmpSyntax[] results = session.set(jOids, syntaxvalues);
            values = this.convertSnmpSyntaxs(results);
        }
        catch (SocketException e) {
            LOG.error("Could not create JoeSNMP session using AgentConfig: {}", (Object)agentConfig);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return values;
    }

    public SnmpValue get(SnmpAgentConfig snmpAgentConfig, SnmpObjId oid) {
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        return this.get(snmpAgentConfig, oids)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpValue[] get(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids) {
        JoeSnmpAgentConfig agentConfig = new JoeSnmpAgentConfig(snmpAgentConfig);
        SnmpValue[] values = new SnmpValue[]{null};
        try (SnmpSession session = null;){
            SnmpPeer peer = this.createPeer(agentConfig);
            SnmpParameters params = new SnmpParameters();
            this.setParameters(agentConfig, params);
            peer.setParameters(params);
            this.configurePeer(peer, agentConfig);
            session = new SnmpSession(peer);
            SnmpObjectId[] jOids = this.convertOids(oids);
            SnmpSyntax[] results = session.get(jOids);
            values = this.convertSnmpSyntaxs(results);
        }
        return values;
    }

    public SnmpValue getNext(SnmpAgentConfig snmpAgentConfig, SnmpObjId oid) {
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        return this.getNext(snmpAgentConfig, oids)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpValue[] getNext(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids) {
        JoeSnmpAgentConfig agentConfig = new JoeSnmpAgentConfig(snmpAgentConfig);
        SnmpValue[] values = new SnmpValue[]{null};
        try (SnmpSession session = null;){
            SnmpPeer peer = this.createPeer(agentConfig);
            SnmpParameters params = new SnmpParameters();
            this.setParameters(agentConfig, params);
            peer.setParameters(params);
            this.configurePeer(peer, agentConfig);
            session = new SnmpSession(peer);
            SnmpObjectId[] jOids = this.convertOids(oids);
            SnmpSyntax[] results = session.getNext(jOids);
            values = this.convertSnmpSyntaxs(results);
        }
        return values;
    }

    private SnmpValue[] convertSnmpSyntaxs(SnmpSyntax[] results) {
        Object[] values = new SnmpValue[]{null};
        if (results == null || results[0] == null || results.length == 0) {
            return values;
        }
        values = new JoeSnmpValue[results.length];
        for (int i = 0; i < results.length; ++i) {
            values[i] = new JoeSnmpValue(results[i]);
        }
        return values;
    }

    private SnmpObjectId[] convertOids(SnmpObjId[] oids) {
        SnmpObjectId[] jOids = new SnmpObjectId[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            jOids[i] = new SnmpObjectId(oids[i].toString());
        }
        return jOids;
    }

    private void configurePeer(SnmpPeer peer, JoeSnmpAgentConfig agentConfig) {
        peer.setPort(agentConfig.getPort());
        peer.setRetries(agentConfig.getRetries());
        peer.setTimeout(agentConfig.getTimeout());
    }

    private SnmpPeer createPeer(JoeSnmpAgentConfig agentConfig) {
        return new SnmpPeer(agentConfig.getAddress());
    }

    private void setParameters(JoeSnmpAgentConfig agentConfig, SnmpParameters params) {
        params.setVersion(agentConfig.getVersion());
        params.setReadCommunity(agentConfig.getReadCommunity());
        params.setWriteCommunity(agentConfig.getWriteCommunity());
    }

    public SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        throw new UnsupportedOperationException("JoeSnmpStrategy.getBulk() not yet implemented.");
    }

    public void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort) throws IOException {
        RegistrationInfo info = new RegistrationInfo(listener, address, snmpTrapPort);
        JoeSnmpTrapNotifier m_trapHandler = new JoeSnmpTrapNotifier(listener, processorFactory);
        info.setHandler(m_trapHandler);
        SnmpTrapSession m_trapSession = new SnmpTrapSession((SnmpTrapHandler)m_trapHandler, address, snmpTrapPort);
        info.setSession(m_trapSession);
        s_registrations.put(listener, info);
    }

    public void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort, List<SnmpV3User> snmpv3Users) throws IOException {
        this.registerForTraps(listener, processorFactory, address, snmpTrapPort);
    }

    public void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, int snmpTrapPort) throws IOException {
        this.registerForTraps(listener, processorFactory, null, snmpTrapPort);
    }

    public void unregisterForTraps(TrapNotificationListener listener, InetAddress address, int snmpTrapPort) {
        RegistrationInfo info = s_registrations.remove(listener);
        info.getSession().close();
    }

    public void unregisterForTraps(TrapNotificationListener listener, int snmpTrapPort) {
        RegistrationInfo info = s_registrations.remove(listener);
        info.getSession().close();
    }

    public SnmpValueFactory getValueFactory() {
        if (this.m_valueFactory == null) {
            this.m_valueFactory = new JoeSnmpValueFactory();
        }
        return this.m_valueFactory;
    }

    public SnmpV1TrapBuilder getV1TrapBuilder() {
        return new JoeSnmpV1TrapBuilder();
    }

    public SnmpTrapBuilder getV2TrapBuilder() {
        return new JoeSnmpV2TrapBuilder();
    }

    public static void send(String destAddr, int destPort, String community, SnmpPduTrap trap) throws Exception {
        SnmpTrapSession trapSession = JoeSnmpStrategy.getTrapSession();
        SnmpPeer peer = new SnmpPeer(InetAddress.getByName(destAddr), destPort);
        SnmpParameters parms = new SnmpParameters(community);
        parms.setVersion(0);
        peer.setParameters(parms);
        trapSession.send(peer, trap);
    }

    public static void send(String destAddr, int destPort, String community, SnmpPduRequest pdu) throws Exception {
        SnmpTrapSession trapSession = JoeSnmpStrategy.getTrapSession();
        SnmpPeer peer = new SnmpPeer(InetAddress.getByName(destAddr), destPort);
        SnmpParameters parms = new SnmpParameters(community);
        parms.setVersion(1);
        peer.setParameters(parms);
        trapSession.send(peer, (SnmpPduPacket)pdu);
    }

    private static synchronized SnmpTrapSession getTrapSession() throws SocketException {
        if (s_trapSession == null) {
            s_trapSession = new SnmpTrapSession(null, null, -1);
        }
        return s_trapSession;
    }

    public static void sendTest(String destAddr, int destPort, String community, SnmpPduRequest pdu) throws UnknownHostException {
        InetAddress agentAddress = InetAddrUtils.addr((String)destAddr);
        for (RegistrationInfo info : s_registrations.values()) {
            if (destPort != info.getPort()) continue;
            info.getHandler().snmpReceivedTrap(info.getSession(), agentAddress, destPort, new SnmpOctetString(community.getBytes()), (SnmpPduPacket)pdu);
        }
    }

    public static void sendTest(String destAddr, int destPort, String community, SnmpPduTrap pdu) throws UnknownHostException {
        InetAddress agentAddress = InetAddrUtils.addr((String)destAddr);
        for (RegistrationInfo info : s_registrations.values()) {
            if (destPort != info.getPort()) continue;
            info.getHandler().snmpReceivedTrap(info.getSession(), agentAddress, destPort, new SnmpOctetString(community.getBytes()), pdu);
        }
    }

    public SnmpV3TrapBuilder getV3TrapBuilder() {
        throw new UnsupportedOperationException();
    }

    public SnmpV2TrapBuilder getV2InformBuilder() {
        throw new UnsupportedOperationException();
    }

    public SnmpV3TrapBuilder getV3InformBuilder() {
        throw new UnsupportedOperationException();
    }

    public byte[] getLocalEngineID() {
        throw new UnsupportedOperationException();
    }

    public static class RegistrationInfo {
        private TrapNotificationListener m_listener;
        private InetAddress m_address;
        private int m_port;
        SnmpTrapSession m_trapSession;
        JoeSnmpTrapNotifier m_trapHandler;

        public RegistrationInfo(TrapNotificationListener listener, int trapPort) {
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            this.m_listener = listener;
            this.m_port = trapPort;
        }

        public RegistrationInfo(TrapNotificationListener listener, InetAddress address, int snmpTrapPort) {
            this.m_listener = listener;
            this.m_address = address;
            this.m_port = snmpTrapPort;
        }

        public void setSession(SnmpTrapSession trapSession) {
            this.m_trapSession = trapSession;
        }

        public SnmpTrapSession getSession() {
            return this.m_trapSession;
        }

        public void setHandler(JoeSnmpTrapNotifier trapHandler) {
            this.m_trapHandler = trapHandler;
        }

        public JoeSnmpTrapNotifier getHandler() {
            return this.m_trapHandler;
        }

        public InetAddress getAddress() {
            return this.m_address;
        }

        public int getPort() {
            return this.m_port;
        }

        public int hashCode() {
            return this.m_listener.hashCode() + this.m_address.hashCode() ^ this.m_port;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistrationInfo) {
                RegistrationInfo info = (RegistrationInfo)obj;
                return this.m_listener == info.m_listener && Arrays.equals(this.m_address.getAddress(), info.getAddress().getAddress()) && this.m_port == info.getPort();
            }
            return false;
        }
    }
}

