/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria.restrictions;

import java.util.Collection;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.AttributeRestriction;
import org.opennms.core.criteria.restrictions.BetweenRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.GeRestriction;
import org.opennms.core.criteria.restrictions.GtRestriction;
import org.opennms.core.criteria.restrictions.IlikeRestriction;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.IplikeRestriction;
import org.opennms.core.criteria.restrictions.LeRestriction;
import org.opennms.core.criteria.restrictions.LikeRestriction;
import org.opennms.core.criteria.restrictions.LtRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.NotNullRestriction;
import org.opennms.core.criteria.restrictions.NotRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.SqlRestriction;

public abstract class Restrictions {
    private static final Restriction[] EMPTY_RESTRICTION_ARRAY = new Restriction[0];

    public static NullRestriction isNull(String attribute) {
        return new NullRestriction(attribute);
    }

    public static NotNullRestriction isNotNull(String attribute) {
        return new NotNullRestriction(attribute);
    }

    public static EqRestriction id(Integer id) {
        return Restrictions.eq("id", id);
    }

    public static EqRestriction eq(String attribute, Object comparator) {
        return new EqRestriction(attribute, comparator);
    }

    public static Restriction ne(String attribute, Object comparator) {
        return new NeRestriction(attribute, comparator);
    }

    public static GtRestriction gt(String attribute, Object comparator) {
        return new GtRestriction(attribute, comparator);
    }

    public static GeRestriction ge(String attribute, Object comparator) {
        return new GeRestriction(attribute, comparator);
    }

    public static LtRestriction lt(String attribute, Object comparator) {
        return new LtRestriction(attribute, comparator);
    }

    public static LeRestriction le(String attribute, Object comparator) {
        return new LeRestriction(attribute, comparator);
    }

    public static LikeRestriction like(String attribute, Object comparator) {
        return new LikeRestriction(attribute, comparator);
    }

    public static IlikeRestriction ilike(String attribute, Object comparator) {
        return new IlikeRestriction(attribute, comparator);
    }

    public static IplikeRestriction iplike(String attribute, Object comparator) {
        return new IplikeRestriction(attribute, comparator);
    }

    public static InRestriction in(String attribute, Collection<?> collection) {
        return new InRestriction(attribute, collection);
    }

    public static BetweenRestriction between(String attribute, Object begin, Object end) {
        return new BetweenRestriction(attribute, begin, end);
    }

    public static NotRestriction not(Restriction restriction) {
        return new NotRestriction(restriction);
    }

    public static AllRestriction and(Restriction lhs, Restriction rhs) {
        return new AllRestriction(lhs, rhs);
    }

    public static AnyRestriction or(Restriction lhs, Restriction rhs) {
        return new AnyRestriction(lhs, rhs);
    }

    public static AllRestriction all(Restriction ... restrictions) {
        return new AllRestriction(restrictions);
    }

    public static AllRestriction all(Collection<Restriction> restrictions) {
        return new AllRestriction(restrictions.toArray(EMPTY_RESTRICTION_ARRAY));
    }

    public static AnyRestriction any(Restriction ... restrictions) {
        return new AnyRestriction(restrictions);
    }

    public static AnyRestriction any(Collection<Restriction> restrictions) {
        return new AnyRestriction(restrictions.toArray(EMPTY_RESTRICTION_ARRAY));
    }

    public static AttributeRestriction sql(String sql) {
        return new SqlRestriction(sql);
    }
}

