/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.utils;

import java.util.Date;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.netmgt.xml.rtc.Header;
import org.opennms.netmgt.xml.rtc.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EuiLevelMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EuiLevelMapper.class);
    private Header m_header = new Header();

    public EuiLevelMapper() {
        this.m_header.setVer("1.9a");
        this.m_header.setMstation("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EuiLevel convertToEuiLevelXML(RTCCategory rtcCat) {
        DataManager rtcDataMgr;
        Date curDate = new Date();
        long curTime = curDate.getTime();
        long rWindow = RTCManager.getRollingWindow();
        LOG.debug("curdate: {}", (Object)curDate);
        EuiLevel level = new EuiLevel();
        this.m_header.setCreated(EventConstants.formatToString((Date)curDate));
        level.setHeader(this.m_header);
        Category levelCat = new Category();
        DataManager dataManager = rtcDataMgr = RTCManager.getDataManager();
        synchronized (dataManager) {
            levelCat.setCatlabel(rtcCat.getLabel());
            levelCat.setCatvalue(rtcDataMgr.getValue(rtcCat.getLabel(), curTime, rWindow));
            for (Long rtcNodeid : rtcCat.getNodes()) {
                long nodeID = rtcNodeid;
                Node levelNode = new Node();
                levelNode.setNodeid(nodeID);
                levelNode.setNodevalue(rtcDataMgr.getValue(nodeID, rtcCat.getLabel(), curTime, rWindow));
                levelNode.setNodesvccount((long)rtcDataMgr.getServiceCount(nodeID, rtcCat.getLabel()));
                levelNode.setNodesvcdowncount((long)rtcDataMgr.getServiceDownCount(nodeID, rtcCat.getLabel()));
                levelCat.addNode(levelNode);
            }
        }
        level.addCategory(levelCat);
        return level;
    }
}

