/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class MonitorTester {
    private static final String CMD_SYNTAX = "poller-test [options]";

    private static void registerProperties(Properties properties) {
        for (Object o : properties.keySet()) {
            String key = (String)o;
            System.setProperty(key, properties.getProperty(key));
        }
    }

    private static void loadProperties(Properties properties, String fileName) throws Exception {
        File propertiesFile = ConfigFileConstants.getConfigFileByName((String)fileName);
        properties.load(new FileInputStream(propertiesFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        try {
            Properties mainProperties = new Properties();
            MonitorTester.loadProperties(mainProperties, "opennms.properties");
            MonitorTester.registerProperties(mainProperties);
            Properties rrdProperties = new Properties();
            MonitorTester.loadProperties(rrdProperties, "rrd-configuration.properties");
            MonitorTester.registerProperties(rrdProperties);
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
            DataSourceConfiguration dsc = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(cfgFile);
                dsc = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (InputStream)fileInputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
            boolean found = false;
            for (JdbcDataSource jds : dsc.getJdbcDataSourceCollection()) {
                if (!jds.getName().equals("opennms")) continue;
                DataSourceFactory.setInstance((DataSource)new SimpleDataSource(jds));
                found = true;
            }
            if (!found) {
                System.err.printf("Error: Can't find OpenNMS database configuration.\n", new Object[0]);
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.printf("Error: Can't initialize OpenNMS database connection factory. %s\n", e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Package pkg;
        InetAddress addr;
        Options options = new Options();
        Option oI = new Option("i", "ipaddress", true, "IP Address to test [required]");
        oI.setRequired(true);
        options.addOption(oI);
        Option oS = new Option("s", "service", true, "Service name [required]");
        oS.setRequired(true);
        options.addOption(oS);
        options.addOption("P", "package", true, "Poller Package");
        options.addOption("p", "param", true, "Service parameter ~ key=value");
        options.addOption("c", "class", true, "Monitor Class");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp(80, CMD_SYNTAX, String.format("ERROR: %s%n", e.getMessage()), options, null);
            System.exit(1);
        }
        MonitorTester.initialize();
        String packageName = cmd.getOptionValue('P');
        String monitorClass = cmd.getOptionValue('c');
        final String ipAddress = cmd.getOptionValue('i');
        final String serviceName = cmd.getOptionValue('s');
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (cmd.hasOption('p')) {
            for (String parm : cmd.getOptionValues('p')) {
                String[] data = parm.split("=");
                if (data.length != 2 || data[0] == null || data[1] == null) continue;
                parameters.put(data[0], data[1]);
            }
        }
        if ((addr = InetAddressUtils.addr((String)ipAddress)) == null) {
            throw new IllegalStateException("Error getting InetAddress object for " + ipAddress);
        }
        final IpInterfaceDao dao = (IpInterfaceDao)BeanUtils.getBean((String)"daoContext", (String)"ipInterfaceDao", IpInterfaceDao.class);
        TransactionTemplate tt = (TransactionTemplate)BeanUtils.getBean((String)"daoContext", (String)"transactionTemplate", TransactionTemplate.class);
        MonitoredService monSvc = (MonitoredService)tt.execute((TransactionCallback)new TransactionCallback<MonitoredService>(){

            public MonitoredService doInTransaction(TransactionStatus status) {
                List ips = dao.findByIpAddress(ipAddress);
                if (ips == null || ips.size() == 0) {
                    System.err.printf("Error: Can't find the IP address %s on the database\n", ipAddress);
                    return null;
                }
                if (ips.size() > 1) {
                    System.out.printf("Warning: there are several IP interface objects associated with the IP address %s (picking the first one)\n", ipAddress);
                }
                OnmsNode n = ((OnmsIpInterface)ips.get(0)).getNode();
                return new SimpleMonitoredService(addr, n.getId(), n.getLabel(), serviceName);
            }
        });
        if (monSvc == null) {
            System.exit(1);
        }
        try {
            PollerConfigFactory.init();
        }
        catch (Exception e) {
            System.err.printf("Error: Can't initialize poller-configuration.xml. %s%n", e.getMessage());
            System.exit(1);
        }
        PollerConfig config = PollerConfigFactory.getInstance();
        System.out.printf("Checking service %s on IP %s%n", serviceName, ipAddress);
        Package package_ = pkg = packageName == null ? config.getFirstLocalPackageMatch(ipAddress) : config.getPackage(packageName);
        if (pkg == null) {
            System.err.printf("Error: Package %s doesn't exist%n", packageName);
            System.exit(1);
        }
        System.out.printf("Package: %s%n", pkg.getName());
        Service svc = config.getServiceInPackage(serviceName, pkg);
        if (svc == null) {
            System.err.printf("Error: Service %s not defined on package %s%n", serviceName, packageName);
            System.exit(1);
        }
        ServiceMonitor monitor = null;
        if (monitorClass == null) {
            monitor = config.getServiceMonitor(serviceName);
            if (monitor == null) {
                System.err.printf("Error: Service %s doesn't have a monitor class defined%n", serviceName);
                System.exit(1);
            }
        } else {
            try {
                Class<ServiceMonitor> mc = Class.forName(monitorClass).asSubclass(ServiceMonitor.class);
                monitor = mc.newInstance();
            }
            catch (Exception e) {
                System.err.printf("Error: Can't instantiate %s because %s%n", monitorClass, e.getMessage());
                System.exit(1);
            }
        }
        System.out.printf("Monitor: %s%n", monitor.getClass().getName());
        if (config.isPolledLocally(ipAddress, serviceName)) {
            for (Parameter parameter : svc.getParameters()) {
                if (parameters.containsKey(parameter.getKey())) continue;
                String value = parameter.getValue();
                if (value == null) {
                    try {
                        value = JaxbUtils.marshal((Object)parameter.getAnyObject());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                parameters.put(parameter.getKey(), value);
            }
            for (Map.Entry entry : parameters.entrySet()) {
                System.out.printf("Parameter %s : %s%n", entry.getKey(), entry.getValue());
            }
            try {
                PollStatus status = monitor.poll(monSvc, parameters);
                System.out.printf("Available ? %s (status %s[%s])%n", status.isAvailable(), status.getStatusName(), status.getStatusCode());
                if (status.isAvailable()) {
                    System.out.printf("Response time: %s%n", status.getResponseTime());
                } else if (status.getReason() != null) {
                    System.out.printf("Reason: %s%n", status.getReason());
                }
            }
            catch (Exception e) {
                System.err.println("Error: Can't execute the monitor. " + e.getMessage());
                System.exit(1);
            }
        } else {
            System.err.printf("Error: Polling is not enabled for service %s using IP %s%n", serviceName, ipAddress);
        }
        System.exit(0);
    }

    public static class SimpleMonitoredService
    implements MonitoredService {
        private InetAddress ipAddress;
        private int nodeId;
        private String nodeLabel;
        private String svcName;

        public SimpleMonitoredService(InetAddress ipAddress, int nodeId, String nodeLabel, String svcName) {
            this.ipAddress = ipAddress;
            this.nodeId = nodeId;
            this.nodeLabel = nodeLabel;
            this.svcName = svcName;
        }

        public String getSvcUrl() {
            return null;
        }

        public String getSvcName() {
            return this.svcName;
        }

        public String getIpAddr() {
            return this.ipAddress.getHostAddress();
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodeLabel() {
            return this.nodeLabel;
        }

        public NetworkInterface<InetAddress> getNetInterface() {
            return new InetNetworkInterface(this.getAddress());
        }

        public InetAddress getAddress() {
            return this.ipAddress;
        }
    }

    public static class SimpleDataSource
    implements DataSource {
        private String m_driver;
        private String m_url;
        private Properties m_properties = new Properties();
        private Integer m_timeout = null;

        public SimpleDataSource(JdbcDataSource ds) throws ClassNotFoundException {
            this.m_driver = ds.getClassName();
            this.m_url = ds.getUrl();
            this.m_properties.put("user", ds.getUserName());
            this.m_properties.put("password", ds.getPassword());
            Class.forName(this.m_driver);
            for (Param param : ds.getParamCollection()) {
                this.m_properties.put(param.getName(), param.getValue());
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.m_timeout == null) {
                return DriverManager.getConnection(this.m_url, this.m_properties);
            }
            int oldTimeout = DriverManager.getLoginTimeout();
            DriverManager.setLoginTimeout(this.m_timeout);
            Connection conn = DriverManager.getConnection(this.m_url, this.m_properties);
            DriverManager.setLoginTimeout(oldTimeout);
            return conn;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException("getConnection(String, String) not implemented");
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter() not implemented");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.m_timeout == null ? -1 : this.m_timeout;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter(PrintWriter) not implemented");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.m_timeout = seconds;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("getParentLogger not supported");
        }
    }
}

