/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.SingleResultQuerier;
import org.opennms.core.utils.Updater;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.poller.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryManager
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultQueryManager.class);
    private static final String SQL_FETCH_INTERFACES_AND_SERVICES_ON_NODE = "SELECT ipaddr,servicename FROM ifservices,service WHERE nodeid= ? AND ifservices.serviceid=service.serviceid";
    private DataSource m_dataSource;

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    private Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeLabel(int nodeId) throws SQLException {
        String nodeLabel = null;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            stmt = dbConn.createStatement();
            d.watch((Object)stmt);
            rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
            d.watch((Object)rs);
            if (rs.next()) {
                nodeLabel = rs.getString("nodelabel");
                LOG.debug("getNodeLabel: nodeid={} nodelabel={}", (Object)nodeId, (Object)nodeLabel);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeLabel;
    }

    private static Timestamp convertEventTimeToTimeStamp(String time) {
        try {
            Date date = EventConstants.parseToDate((String)time);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date format: " + time, e);
        }
    }

    @Override
    public void openOutage(String outageIdSQL, int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        int serviceId = this.getServiceID(svcName);
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                LOG.info("openOutage: opening outage for {}:{}:{} with cause {}:{}", new Object[]{nodeId, ipAddr, svcName, dbId, time});
                SingleResultQuerier srq = new SingleResultQuerier(this.m_dataSource, outageIdSQL);
                srq.execute(new Object[0]);
                Object outageId = srq.getResult();
                if (outageId == null) {
                    throw new Exception("Null outageId returned from Querier with SQL: " + outageIdSQL);
                }
                String sql = "insert into outages (outageId, svcLostEventId, nodeId, ipAddr, serviceId, ifLostService) values (" + outageId + ", ?, ?, ?, ?, ?)";
                Object[] values = new Object[]{dbId, nodeId, ipAddr, serviceId, DefaultQueryManager.convertEventTimeToTimeStamp(time)};
                Updater updater = new Updater(this.m_dataSource, sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Throwable e) {
                if (attempt > 1) {
                    LOG.error("openOutage: Second and final attempt failed opening outage for {}:{}:{}", new Object[]{nodeId, ipAddr, svcName, e});
                    continue;
                }
                LOG.info("openOutage: First attempt failed opening outage for {}:{}:{}", new Object[]{nodeId, ipAddr, svcName, e});
            }
        }
    }

    @Override
    public void resolveOutage(int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                LOG.info("resolving outage for {}:{}:{} with resolution {}:{}", new Object[]{nodeId, ipAddr, svcName, dbId, time});
                int serviceId = this.getServiceID(svcName);
                String sql = "update outages set svcRegainedEventId=?, ifRegainedService=? where nodeId = ? and ipAddr = ? and serviceId = ? and ifRegainedService is null";
                Object[] values = new Object[]{dbId, DefaultQueryManager.convertEventTimeToTimeStamp(time), nodeId, ipAddr, serviceId};
                Updater updater = new Updater(this.m_dataSource, sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Throwable e) {
                if (attempt > 1) {
                    LOG.error("resolveOutage: Second and final attempt failed resolving outage for {}:{}:{}", new Object[]{nodeId, ipAddr, svcName, e});
                    continue;
                }
                LOG.info("resolveOutage: first attempt failed resolving outage for {}:{}:{}", new Object[]{nodeId, ipAddr, svcName, e});
            }
        }
    }

    @Override
    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        try {
            LOG.info("reparenting outages for {}:{} to new node {}", new Object[]{oldNodeId, ipAddr, newNodeId});
            String sql = "update outages set nodeId = ? where nodeId = ? and ipaddr = ?";
            Object[] values = new Object[]{newNodeId, oldNodeId, ipAddr};
            Updater updater = new Updater(this.m_dataSource, sql);
            updater.execute(values);
        }
        catch (Throwable e) {
            LOG.error(" Error reparenting outage for {}:{} to {}", new Object[]{oldNodeId, ipAddr, newNodeId, e});
        }
    }

    public int getServiceID(String serviceName) {
        if (serviceName == null) {
            return -1;
        }
        SingleResultQuerier querier = new SingleResultQuerier(this.m_dataSource, "select serviceId from service where serviceName = ?");
        querier.execute(new Object[]{serviceName});
        Integer result = (Integer)querier.getResult();
        return result == null ? -1 : result;
    }

    @Override
    public List<String[]> getNodeServices(int nodeId) {
        final LinkedList<String[]> servicemap = new LinkedList<String[]>();
        Querier querier = new Querier(this.m_dataSource, SQL_FETCH_INTERFACES_AND_SERVICES_ON_NODE){

            public void processRow(ResultSet rs) throws SQLException {
                String[] row = new String[]{rs.getString(1), rs.getString(2)};
                servicemap.add(row);
            }
        };
        querier.execute(new Object[]{nodeId});
        return servicemap;
    }

    @Override
    public void closeOutagesForUnmanagedServices() {
        Timestamp closeTime = new Timestamp(new Date().getTime());
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_SERVICES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))");
        svcUpdater.execute(new Object[]{closeTime});
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_INTERFACES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater ifUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))");
        ifUpdater.execute(new Object[]{closeTime});
    }

    @Override
    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_NODE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId});
    }

    @Override
    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_IFACE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId, ipAddr});
    }

    @Override
    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_SERVICE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId, ipAddr, serviceName});
    }

    @Override
    public void updateServiceStatus(int nodeId, String ipAddr, String serviceName, String status) {
        String sql = "UPDATE ifservices SET status = ? WHERE id  IN (SELECT ifs.id FROM ifservices AS ifs JOIN service AS svc ON ifs.serviceid = svc.serviceid  WHERE ifs.nodeId = ? AND ifs.ipAddr = ? AND svc.servicename = ?)";
        Updater updater = new Updater(this.m_dataSource, "UPDATE ifservices SET status = ? WHERE id  IN (SELECT ifs.id FROM ifservices AS ifs JOIN service AS svc ON ifs.serviceid = svc.serviceid  WHERE ifs.nodeId = ? AND ifs.ipAddr = ? AND svc.servicename = ?)");
        updater.execute(new Object[]{status, nodeId, ipAddr, serviceName});
    }
}

