/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsIsSystemObjectGroup
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IsIsSystemObjectGroup.class);
    public static final String ISIS_SYS_ID_ALIAS = "isisSysID";
    public static final String ISIS_SYS_ID_OID = ".1.3.6.1.2.1.138.1.1.1.3";
    public static final String ISIS_SYS_ADMIN_STATE_ALIAS = "isisSysAdminState";
    public static final String ISIS_SYS_ADMIN_STATE_OID = ".1.3.6.1.2.1.138.1.1.1.8";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String ISIS_SYS_OBJ_OID = ".1.3.6.1.2.1.138.1.1.1";
    private SnmpStore m_store;
    private InetAddress m_address;

    public IsIsSystemObjectGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    public IsIsElement.IsisAdminState getIsisSysAdminState() {
        return IsIsElement.IsisAdminState.get((Integer)this.m_store.getInt32(ISIS_SYS_ADMIN_STATE_ALIAS));
    }

    public String getIsisSysId() {
        return this.m_store.getHexString(ISIS_SYS_ID_ALIAS);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving lldpLocalGroup from {}. {}", (Object)this.m_address, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving lldpLocalGroup from {}. {}", (Object)this.m_address, (Object)msg);
    }

    static {
        ms_elemList = new NamedSnmpVar[2];
        int ndx = 0;
        IsIsSystemObjectGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", ISIS_SYS_ID_ALIAS, ISIS_SYS_ID_OID);
        IsIsSystemObjectGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", ISIS_SYS_ADMIN_STATE_ALIAS, ISIS_SYS_ADMIN_STATE_OID);
    }
}

