/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.snmp.LldpHelper;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpRemTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpRemTableTracker.class);
    public static final SnmpObjId LLDP_REM_TABLE_ENTRY = SnmpObjId.get((String)".1.0.8802.1.1.2.1.4.1.1");
    public static final SnmpObjId LLDP_REM_CHASSIS_ID_SUBTYPE = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId LLDP_REM_CHASSIS_ID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId LLDP_REM_PORT_ID_SUBTYPE = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId LLDP_REM_PORT_ID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId LLDP_REM_PORT_DESCR = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId LLDP_REM_SYSNAME = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId[] s_lldpremtable_elemList = new SnmpObjId[]{LLDP_REM_CHASSIS_ID_SUBTYPE, LLDP_REM_CHASSIS_ID, LLDP_REM_PORT_ID_SUBTYPE, LLDP_REM_PORT_ID, LLDP_REM_PORT_DESCR, LLDP_REM_SYSNAME};

    public LldpRemTableTracker() {
        super(s_lldpremtable_elemList);
    }

    public LldpRemTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_lldpremtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new LldpRemRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processLldpRemRow((LldpRemRow)row);
    }

    public void processLldpRemRow(LldpRemRow row) {
    }

    public static class LldpRemRow
    extends SnmpRowResult {
        public LldpRemRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getLldpRemLocalPortNum() {
            return this.getInstance().getSubIdAt(1);
        }

        public Integer getLldpRemChassisidSubtype() {
            return this.getValue(LLDP_REM_CHASSIS_ID_SUBTYPE).toInt();
        }

        public SnmpValue getLldpRemChassisId() {
            return this.getValue(LLDP_REM_CHASSIS_ID);
        }

        public Integer getLldpRemPortidSubtype() {
            return this.getValue(LLDP_REM_PORT_ID_SUBTYPE).toInt();
        }

        public SnmpValue getLldpRemPortid() {
            return this.getValue(LLDP_REM_PORT_ID);
        }

        public String getLldpRemPortDescr() {
            if (this.getValue(LLDP_REM_PORT_DESCR) != null) {
                return this.getValue(LLDP_REM_PORT_DESCR).toDisplayString();
            }
            return "";
        }

        public String getLldpRemSysname() {
            return this.getValue(LLDP_REM_SYSNAME).toDisplayString();
        }

        public LldpLink getLldpLink(LldpLocPortGetter lldpLocPort) {
            LOG.info("getLldpLink: row count: {}", (Object)this.getColumnCount());
            LOG.info("getLldpLink: row local port num: {}", (Object)this.getLldpRemLocalPortNum());
            LldpLink lldpLink = lldpLocPort.get(this.getLldpRemLocalPortNum());
            LOG.info("getLldpLink: row local port id: {}", (Object)lldpLink.getLldpPortId());
            LOG.info("getLldpLink: row local port subtype: {}", (Object)LldpLink.LldpPortIdSubType.getTypeString((Integer)lldpLink.getLldpPortIdSubType().getValue()));
            lldpLink.setLldpRemChassisId(LldpHelper.decodeLldpChassisId(this.getLldpRemChassisId(), this.getLldpRemChassisidSubtype()));
            LOG.info("getLldpLink: row rem lldp identifier: {}", (Object)lldpLink.getLldpRemChassisId());
            lldpLink.setLldpRemChassisIdSubType(LldpElement.LldpChassisIdSubType.get((Integer)this.getLldpRemChassisidSubtype()));
            LOG.info("getLldpLink: row rem lldp chassis id subtype: {}", (Object)LldpElement.LldpChassisIdSubType.getTypeString((Integer)this.getLldpRemChassisidSubtype()));
            lldpLink.setLldpRemSysname(this.getLldpRemSysname());
            LOG.info("getLldpLink: row rem lldp sysname: {}", (Object)lldpLink.getLldpRemSysname());
            lldpLink.setLldpRemPortId(LldpHelper.decodeLldpLink(this.getLldpRemPortidSubtype(), this.getLldpRemPortid()));
            LOG.info("getLldpLink: row rem lldp port id: {}", (Object)lldpLink.getLldpRemPortId());
            lldpLink.setLldpRemPortIdSubType(LldpLink.LldpPortIdSubType.get((Integer)this.getLldpRemPortidSubtype()));
            LOG.info("getLldpLink: row rem lldp port id subtype: {}", (Object)LldpLink.LldpPortIdSubType.getTypeString((Integer)this.getLldpRemPortidSubtype()));
            lldpLink.setLldpRemPortDescr(this.getLldpRemPortDescr());
            return lldpLink;
        }
    }
}

