/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryLldp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryLldp.class);

    public NodeDiscoveryLldp(EnhancedLinkd linkd, LinkableSnmpNode node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        String trackerName = "lldpLocalGroup";
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        LOG.info("run: collecting {} on: {}", (Object)trackerName, (Object)InetAddressUtils.str((InetAddress)this.getTarget()));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)lldpLocalGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Lldp Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Lldp Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Lldp Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (lldpLocalGroup.getLldpLocChassisid() == null) {
            LOG.info("lldp mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        LOG.info("found lldp identifier : {}", (Object)lldpLocalGroup.getLldpElement());
        this.m_linkd.getQueryManager().store(this.getNodeId(), lldpLocalGroup.getLldpElement());
        final LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(this.getPeer());
        trackerName = "lldpRemTable";
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            @Override
            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                NodeDiscoveryLldp.this.m_linkd.getQueryManager().store(NodeDiscoveryLldp.this.getNodeId(), row.getLldpLink(lldpLocPort));
            }
        };
        LOG.info("run: collecting {} on: {}", (Object)trackerName, (Object)InetAddressUtils.str((InetAddress)this.getTarget()));
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)lldpRemTable);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        this.m_linkd.getQueryManager().reconcileLldp(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable:LldpLinkNodeDiscovery node: " + this.getNodeId() + " ip:" + InetAddressUtils.str((InetAddress)this.getTarget()) + " package:" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "LldpLinkDiscovery";
    }
}

