/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.protocols.ntp.NtpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NtpPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NtpPlugin.class);
    private static final String PROTOCOL_NAME = "NTP";
    private static final int DEFAULT_PORT = 123;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress nserver, int port, int retries, int timeout) {
        boolean isAServer = false;
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            byte[] data = new byte[512];
            for (int count = 0; count < retries && !isAServer; ++count) {
                try {
                    byte[] buf = new NtpMessage().toByteArray();
                    DatagramPacket outpkt = new DatagramPacket(buf, buf.length, nserver, port);
                    socket.send(outpkt);
                    DatagramPacket inpkt = new DatagramPacket(data, data.length);
                    socket.receive(inpkt);
                    if (!inpkt.getAddress().equals(nserver)) continue;
                    new NtpMessage(inpkt.getData());
                    isAServer = true;
                    continue;
                }
                catch (InterruptedIOException ex) {
                    // empty catch block
                }
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 123, 3, 3000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int port = 123;
        int timeout = 3000;
        int retries = 3;
        if (qualifiers != null) {
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)123);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)3000);
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)ParameterMap.getKeyedInteger(qualifiers, (String)"retries", (int)3));
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", port);
        }
        return result;
    }
}

