/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import antlr.StringUtils;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostResourceSwRunPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(HostResourceSwRunPlugin.class);
    private static final String PROTOCOL_NAME = "HOST-RESOURCES";
    private static final String HOSTRESOURCE_SW_NAME_OID = ".1.3.6.1.2.1.25.4.2.1.2";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    @Override
    public boolean isProtocolSupported(InetAddress ipaddr, Map<String, Object> parameters) {
        boolean status = false;
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String serviceNameOid = ParameterMap.getKeyedString(parameters, (String)"service-name-oid", (String)HOSTRESOURCE_SW_NAME_OID);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", null);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("capsd: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("HostResourceSwRunMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            if (serviceName == null) {
                LOG.warn("HostResourceSwRunMonitor.poll: No Service Name Defined! ");
                return status;
            }
            Map nameResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (SnmpObjId)SnmpObjId.get((String)serviceNameOid));
            for (SnmpInstId nameInstance : nameResults.keySet()) {
                if (!this.match(serviceName, this.stripExtraQuotes(((SnmpValue)nameResults.get(nameInstance)).toString()))) continue;
                LOG.debug("poll: HostResourceSwRunMonitor poll succeeded, addr={} service name={} value={}", new Object[]{InetAddressUtils.str((InetAddress)ipaddr), serviceName, nameResults.get(nameInstance)});
                status = true;
                break;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Number operator used on a non-number {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid SNMP Criteria: {}", (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception during SNMP poll of interface {}", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)t);
        }
        return status;
    }

    private boolean match(String expectedText, String currentText) {
        if (expectedText.startsWith("~")) {
            return currentText.matches(expectedText.replaceFirst("~", ""));
        }
        return currentText.equalsIgnoreCase(expectedText);
    }

    private String stripExtraQuotes(String string) {
        return StringUtils.stripFrontBack((String)string, (String)"\"", (String)"\"");
    }
}

