/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.opennms.netmgt.provision.ServiceDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDetector
implements ServiceDetector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDetector.class);
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int DEFAULT_RETRIES = 1;
    private int m_port;
    private int m_retries;
    private int m_timeout;
    private String m_ipMatch;
    private String m_serviceName;

    protected AbstractDetector(String serviceName, int port, int timeout, int retries) {
        this.m_serviceName = serviceName;
        this.m_port = port;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    protected AbstractDetector(String serviceName, int port) {
        this(serviceName, port, 2000, 1);
    }

    @Override
    public final void init() {
        if (this.m_serviceName == null || this.m_timeout < -1) {
            throw new IllegalStateException(String.format("ServiceName is null or timeout of %d is invalid. Timeout must be > -1", this.m_timeout));
        }
        this.onInit();
    }

    protected abstract void onInit();

    @Override
    public abstract void dispose();

    @Override
    public final void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public final int getPort() {
        return this.m_port;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getRetries() {
        return this.m_retries;
    }

    @Override
    public final void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    @Override
    public final int getTimeout() {
        return this.m_timeout;
    }

    @Override
    public final void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public final String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public String getIpMatch() {
        return this.m_ipMatch;
    }

    @Override
    public void setIpMatch(String ipMatch) {
        this.m_ipMatch = ipMatch;
    }
}

