/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.wmi;

import java.io.File;
import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.collectd.wmi.WmiResourceType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiMultiInstanceCollectionResource
extends WmiCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(WmiMultiInstanceCollectionResource.class);
    private final String m_inst;
    private String m_resourceLabel;
    private final WmiResourceType m_resourceType;

    public WmiMultiInstanceCollectionResource(CollectionAgent agent, String instance, WmiResourceType type) {
        super(agent);
        this.m_inst = instance;
        this.m_resourceType = type;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_resourceType.getPersistenceSelectorStrategy().shouldPersist((CollectionResource)this);
    }

    public File getResourceDir(RrdRepository repository) {
        String resourcePath = this.m_resourceType.getStorageStrategy().getRelativePathForAttribute(this.getParent(), this.getInterfaceLabel());
        File resourceDir = new File(repository.getRrdBaseDir(), resourcePath);
        LOG.debug("getResourceDir: {}", (Object)resourceDir);
        return resourceDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceType.getName();
    }

    @Override
    public String getInstance() {
        return this.m_inst;
    }

    public String toString() {
        return "Node[" + this.m_agent.getNodeId() + "]/type[" + this.getResourceTypeName() + "]/instance[" + this.m_inst + "]";
    }

    public String getInterfaceLabel() {
        return this.m_resourceLabel == null ? this.m_resourceType.getStorageStrategy().getResourceNameFromIndex((CollectionResource)this) : this.m_resourceLabel;
    }
}

