/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSourceResourceType
implements OnmsResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(NodeSourceResourceType.class);
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public NodeSourceResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Foreign Source";
    }

    public String getName() {
        return "nodeSource";
    }

    public List<OnmsResource> getResourcesForNodeSource(String nodeSource, int nodeId) {
        return null;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        return null;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return null;
    }

    public boolean isResourceTypeOnNodeSource(String nodeSource, int nodeId) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return false;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    public OnmsResource createChildResource(String nodeSource) {
        if (!nodeSource.contains(":")) {
            LOG.warn("'%s' is not in the format foreignSource:foreignId.", (Object)nodeSource);
            throw new IllegalArgumentException("Node definition '" + nodeSource + "' is invalid, it should be in the format: 'foreignSource:foreignId'.");
        }
        String[] ident = nodeSource.split(":", 2);
        if (ident.length != 2) {
            LOG.warn("'%s' is not in the format foreignSource:foreignId.", (Object)nodeSource);
            throw new IllegalArgumentException("Node definition '" + nodeSource + "' is invalid, it should be in the format: 'foreignSource:foreignId'.");
        }
        OnmsNode node = this.m_nodeDao.findByForeignId(ident[0], ident[1]);
        if (node == null) {
            LOG.debug("Failed to locate node by foreign ID '%s:%s'", (Object)ident[0], (Object)ident[1]);
            return null;
        }
        String label = ident[0] + ":" + node.getLabel();
        NodeSourceChildResourceLoader loader = new NodeSourceChildResourceLoader(nodeSource, node.getId());
        OnmsResource resource = new OnmsResource(nodeSource, label, (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader));
        loader.setParent(resource);
        return resource;
    }

    public class NodeSourceChildResourceLoader
    implements LazyList.Loader<OnmsResource> {
        private String m_nodeSource;
        private int m_nodeId;
        private OnmsResource m_parent;

        public NodeSourceChildResourceLoader(String nodeSource, int nodeId) {
            this.m_nodeSource = nodeSource;
            this.m_nodeId = nodeId;
        }

        public void setParent(OnmsResource parent) {
            this.m_parent = parent;
        }

        public List<OnmsResource> load() {
            LinkedList<OnmsResource> children = new LinkedList<OnmsResource>();
            for (OnmsResourceType resourceType : this.getResourceTypesForNodeSource(this.m_nodeSource)) {
                for (OnmsResource resource : resourceType.getResourcesForNodeSource(this.m_nodeSource, this.m_nodeId)) {
                    resource.setParent(this.m_parent);
                    children.add(resource);
                    LOG.debug("load: adding resource {}", (Object)resource.toString());
                }
            }
            return children;
        }

        private Collection<OnmsResourceType> getResourceTypesForNodeSource(String nodeSource) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : NodeSourceResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnNodeSource(nodeSource, this.m_nodeId)) continue;
                resourceTypes.add(resourceType);
                LOG.debug("getResourceTypesForNodeSource: adding type {}", (Object)resourceType.getName());
            }
            return resourceTypes;
        }
    }
}

