/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.SIUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public class InterfaceSnmpResourceType
implements OnmsResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceSnmpResourceType.class);
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public InterfaceSnmpResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getName() {
        return "interfaceSnmp";
    }

    public String getLabel() {
        return "SNMP Interface Data";
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.isResourceTypeOnParentResource(Integer.toString(nodeId));
    }

    private boolean isResourceTypeOnParentResource(String parentResource) {
        File parent = this.getParentResourceDirectory(parentResource, false);
        if (!parent.isDirectory()) {
            return false;
        }
        return parent.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER).length > 0;
    }

    private File getParentResourceDirectory(String parentResource, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File parent = new File(snmp, parentResource);
        if (verify && !parent.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No parent resource directory exists for " + parentResource + ": " + parent));
        }
        return parent;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)Integer.toString(nodeId), "Could not find node with node ID " + nodeId, null);
        }
        File parent = this.getParentResourceDirectory(Integer.toString(nodeId), true);
        return OnmsResource.sortIntoResourceList(this.populateResourceList(parent, null, node, false));
    }

    private List<OnmsResource> populateResourceList(File parent, File relPath, OnmsNode node, Boolean isForeign) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        File[] intfDirs = parent.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Set snmpInterfaces = node.getSnmpInterfaces();
        HashMap<String, OnmsSnmpInterface> intfMap = new HashMap<String, OnmsSnmpInterface>();
        for (OnmsSnmpInterface snmpInterface : snmpInterfaces) {
            String[] keys;
            if (snmpInterface.getIfDescr() != null && Pattern.matches(".*-cef.*", snmpInterface.getIfDescr())) continue;
            String replacedIfName = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfName(), (char)'_');
            String replacedIfDescr = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfDescr(), (char)'_');
            for (String key : keys = new String[]{replacedIfName + "-", replacedIfDescr + "-", replacedIfName + "-" + snmpInterface.getPhysAddr(), replacedIfDescr + "-" + snmpInterface.getPhysAddr()}) {
                if (intfMap.containsKey(key)) continue;
                intfMap.put(key, snmpInterface);
            }
        }
        for (File intfDir : intfDirs) {
            String label;
            String name;
            String key;
            String desc = name = intfDir.getName();
            String mac = "";
            int dashIndex = name.lastIndexOf(45);
            if (dashIndex >= 0) {
                desc = name.substring(0, dashIndex);
                mac = name.substring(dashIndex + 1, name.length());
            }
            key = desc + "-" + mac;
            OnmsSnmpInterface snmpInterface = (OnmsSnmpInterface)intfMap.get(key);
            Long ifSpeed = null;
            String ifSpeedFriendly = null;
            if (snmpInterface == null) {
                label = name + " (*)";
            } else {
                StringBuffer descr = new StringBuffer();
                StringBuffer parenString = new StringBuffer();
                if (snmpInterface.getIfAlias() != null) {
                    parenString.append(snmpInterface.getIfAlias());
                }
                for (OnmsIpInterface ipif : snmpInterface.getIpInterfaces()) {
                    String ipaddr = InetAddressUtils.str((InetAddress)ipif.getIpAddress());
                    if ("0.0.0.0".equals(ipaddr)) continue;
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(ipaddr);
                }
                if (snmpInterface.getIfSpeed() != null && snmpInterface.getIfSpeed() != 0L) {
                    ifSpeed = snmpInterface.getIfSpeed();
                    ifSpeedFriendly = SIUtils.getHumanReadableIfSpeed((long)ifSpeed);
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(ifSpeedFriendly);
                }
                if (snmpInterface.getIfName() != null) {
                    descr.append(snmpInterface.getIfName());
                } else if (snmpInterface.getIfDescr() != null) {
                    descr.append(snmpInterface.getIfDescr());
                } else {
                    descr.append(name);
                }
                if (parenString.length() > 0) {
                    descr.append(" (");
                    descr.append(parenString);
                    descr.append(")");
                }
                label = descr.toString();
            }
            OnmsResource resource = null;
            resource = isForeign != false ? this.getResourceByNodeSourceAndInterface(relPath.toString(), intfDir.getName(), label, ifSpeed, ifSpeedFriendly) : this.getResourceByNodeAndInterface(node.getId(), intfDir.getName(), label, ifSpeed, ifSpeedFriendly);
            if (snmpInterface != null) {
                Set ipInterfaces = snmpInterface.getIpInterfaces();
                if (ipInterfaces.size() > 0) {
                    int id = ((OnmsIpInterface)ipInterfaces.iterator().next()).getId();
                    resource.setLink("element/interface.jsp?ipinterfaceid=" + id);
                } else {
                    int ifIndex = snmpInterface.getIfIndex();
                    if (ifIndex > -1) {
                        resource.setLink("element/snmpinterface.jsp?node=" + node.getNodeId() + "&ifindex=" + ifIndex);
                    }
                }
                resource.setEntity((OnmsEntity)snmpInterface);
            } else {
                LOG.debug("populateResourceList: snmpInterface is null");
            }
            LOG.debug("populateResourceList: adding resource toString {}", (Object)resource.toString());
            resources.add(resource);
        }
        return resources;
    }

    private OnmsResource getResourceByNodeAndInterface(int nodeId, String intf, String label, Long ifSpeed, String ifSpeedFriendly) throws DataAccessException {
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(Integer.toString(nodeId), intf, ifSpeed, ifSpeedFriendly));
        return new OnmsResource(intf, label, (OnmsResourceType)this, (Set)set);
    }

    private OnmsResource getResourceByNodeSourceAndInterface(String relPath, String intf, String label, Long ifSpeed, String ifSpeedFriendly) throws DataAccessException {
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(relPath, intf, ifSpeed, ifSpeedFriendly));
        return new OnmsResource(intf, label, (OnmsResourceType)this, (Set)set);
    }

    private String getRelativePathForResource(String parent, String resource) {
        return "snmp" + File.separator + parent + File.separator + resource;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return this.getQueryableInterfacesForDomain(domain).size() > 0;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        List<String> ifaces = this.getQueryableInterfacesForDomain(domain);
        for (String iface : ifaces) {
            OnmsResource resource = this.getResourceByDomainAndInterface(domain, iface);
            try {
                resource.setLink("element/nodeList.htm?listInterfaces=true&snmpParm=ifAlias&snmpParmMatchType=contains&snmpParmValue=" + URLEncoder.encode(iface, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("URLEncoder.encode complained about UTF-8. " + e, e);
            }
            resources.add(resource);
        }
        return OnmsResource.sortIntoResourceList(resources);
    }

    private List<String> getQueryableInterfacesForDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<String> intfs = new ArrayList<String>();
        File snmp = new File(this.m_resourceDao.getRrdDirectory(), "snmp");
        File domainDir = new File(snmp, domain);
        if (!domainDir.exists() || !domainDir.isDirectory()) {
            throw new IllegalArgumentException("No such directory: " + domainDir);
        }
        File[] intfDirs = domainDir.listFiles(RrdFileConstants.DOMAIN_INTERFACE_DIRECTORY_FILTER);
        if (intfDirs != null && intfDirs.length > 0) {
            intfs.ensureCapacity(intfDirs.length);
            for (int i = 0; i < intfDirs.length; ++i) {
                intfs.add(intfDirs[i].getName());
            }
        }
        return intfs;
    }

    private OnmsResource getResourceByDomainAndInterface(String domain, String intf) {
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(domain, intf, null, null));
        return new OnmsResource(intf, intf, (OnmsResourceType)this, (Set)set);
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public boolean isResourceTypeOnNodeSource(String nodeSource, int nodeId) {
        File parent = ResourceTypeUtils.getRelativeNodeSourceDirectory((String)nodeSource);
        return this.isResourceTypeOnParentResource(parent.toString());
    }

    public List<OnmsResource> getResourcesForNodeSource(String nodeSource, int nodeId) {
        String[] ident = nodeSource.split(":");
        OnmsNode node = this.m_nodeDao.findByForeignId(ident[0], ident[1]);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeSource, "Could not find node with nodeSource " + nodeSource, null);
        }
        File relPath = new File("fs", ident[0] + File.separator + ident[1]);
        File parent = this.getParentResourceDirectory(relPath.toString(), true);
        return OnmsResource.sortIntoResourceList(this.populateResourceList(parent, relPath, node, true));
    }

    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private String m_parent;
        private String m_resource;
        private Long m_ifSpeed;
        private String m_ifSpeedFriendly;

        public AttributeLoader(String parent, String resource, Long ifSpeed, String ifSpeedFriendly) {
            this.m_parent = parent;
            this.m_resource = resource;
            this.m_ifSpeed = ifSpeed;
            this.m_ifSpeedFriendly = ifSpeedFriendly;
        }

        public Set<OnmsAttribute> load() {
            Set attributes = ResourceTypeUtils.getAttributesAtRelativePath((File)InterfaceSnmpResourceType.this.m_resourceDao.getRrdDirectory(), (String)InterfaceSnmpResourceType.this.getRelativePathForResource(this.m_parent, this.m_resource));
            if (this.m_ifSpeed != null) {
                attributes.add(new ExternalValueAttribute("ifSpeed", this.m_ifSpeed.toString()));
            }
            if (this.m_ifSpeedFriendly != null) {
                attributes.add(new ExternalValueAttribute("ifSpeedFriendly", this.m_ifSpeedFriendly));
            }
            return attributes;
        }
    }
}

