/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.InputStream;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdFileConstants;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultRrdDao
implements RrdDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRrdDao.class);
    private RrdStrategy<?, ?> m_rrdStrategy;
    private File m_rrdBaseDirectory;
    private String m_rrdBinaryPath;

    public double getPrintValue(OnmsAttribute attribute, String cf, long start, long end) {
        return this.getPrintValues(attribute, cf, start, end, new String[0])[0];
    }

    public double[] getPrintValues(OnmsAttribute attribute, String rraConsolidationFunction, long startTimeInMillis, long endTimeInMillis, String ... printFunctions) {
        String[] printLines;
        RrdGraphDetails graphDetails;
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.notNull((Object)rraConsolidationFunction, (String)"rraConsolicationFunction argument must not be null");
        Assert.isTrue((endTimeInMillis > startTimeInMillis ? 1 : 0) != 0, (String)"end argument must be after start argument");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        if (printFunctions.length < 1) {
            printFunctions = new String[]{rraConsolidationFunction};
        }
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        Object[] command = new String[]{this.m_rrdBinaryPath, "graph", "-", "--start=" + startTimeInMillis / 1000L, "--end=" + endTimeInMillis / 1000L, "DEF:ds=" + RrdFileConstants.escapeForGraphing((String)rrdAttribute.getRrdRelativePath()) + ":" + attribute.getName() + ":" + rraConsolidationFunction};
        Object[] printDefs = new String[printFunctions.length];
        for (int i = 0; i < printFunctions.length; ++i) {
            printDefs[i] = "PRINT:ds:" + printFunctions[i] + ":\"%le\"";
        }
        String commandString = StringUtils.arrayToDelimitedString((Object[])command, (String)" ") + ' ' + StringUtils.arrayToDelimitedString((Object[])printDefs, (String)" ");
        LOG.debug("commandString: {}", (Object)commandString);
        try {
            graphDetails = this.m_rrdStrategy.createGraphReturnDetails(commandString, this.m_rrdBaseDirectory);
        }
        catch (Throwable e) {
            throw new DataAccessResourceFailureException("Failure when generating graph to get data with command '" + commandString + "'", e);
        }
        try {
            printLines = graphDetails.getPrintLines();
        }
        catch (Throwable e) {
            throw new DataAccessResourceFailureException("Failure to get print lines from graph after graphing with command '" + commandString + "'", e);
        }
        if (printLines.length != printFunctions.length) {
            throw new DataAccessResourceFailureException("Returned number of print lines should be " + printFunctions.length + ", but was " + printLines.length + " from command: " + commandString);
        }
        double[] values = new double[printLines.length];
        for (int i = 0; i < printLines.length; ++i) {
            if (printLines[i].toLowerCase().endsWith("nan")) {
                values[i] = Double.NaN;
                continue;
            }
            try {
                values[i] = Double.parseDouble(printLines[i].replace(",", "."));
                continue;
            }
            catch (NumberFormatException e) {
                throw new DataAccessResourceFailureException("Value of line " + (i + 1) + " of output from RRD is not a valid floating point number: '" + printLines[i] + "'");
            }
        }
        return values;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_rrdStrategy != null ? 1 : 0) != 0, (String)"property rrdStrategy must be set and be non-null");
        Assert.state((this.m_rrdBaseDirectory != null ? 1 : 0) != 0, (String)"property rrdBaseDirectory must be set and be non-null");
        Assert.state((this.m_rrdBinaryPath != null ? 1 : 0) != 0, (String)"property rrdBinaryPath must be set and be non-null");
    }

    public RrdStrategy<?, ?> getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public void setRrdStrategy(RrdStrategy<?, ?> rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    public File getRrdBaseDirectory() {
        return this.m_rrdBaseDirectory;
    }

    public void setRrdBaseDirectory(File rrdBaseDirectory) {
        this.m_rrdBaseDirectory = rrdBaseDirectory;
    }

    public String getRrdBinaryPath() {
        return this.m_rrdBinaryPath;
    }

    public void setRrdBinaryPath(String rrdBinaryPath) {
        this.m_rrdBinaryPath = rrdBinaryPath;
    }

    public InputStream createGraph(String command, File workDir) throws DataRetrievalFailureException {
        try {
            return this.m_rrdStrategy.createGraph(command, workDir);
        }
        catch (Throwable e) {
            throw new DataRetrievalFailureException("Could not create graph: " + e, e);
        }
    }

    public int getGraphTopOffsetWithText() {
        return this.m_rrdStrategy.getGraphTopOffsetWithText();
    }

    public int getGraphLeftOffset() {
        return this.m_rrdStrategy.getGraphLeftOffset();
    }

    public int getGraphRightOffset() {
        return this.m_rrdStrategy.getGraphRightOffset();
    }

    public Double getLastFetchValue(OnmsAttribute attribute, int interval) throws DataAccessResourceFailureException {
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval argument must be greater than zero");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        File rrdFile = new File(this.m_rrdBaseDirectory, rrdAttribute.getRrdRelativePath());
        try {
            return this.m_rrdStrategy.fetchLastValue(rrdFile.getAbsolutePath(), attribute.getName(), interval);
        }
        catch (Throwable e) {
            throw new DataAccessResourceFailureException("Failure to fetch last value from file '" + rrdFile + "' with interval " + interval, e);
        }
    }

    public Double getLastFetchValue(OnmsAttribute attribute, int interval, int range) throws DataAccessResourceFailureException {
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval argument must be greater than zero");
        Assert.isTrue((range > 0 ? 1 : 0) != 0, (String)"range argument must be greater than zero");
        Assert.isAssignable(attribute.getClass(), RrdGraphAttribute.class, (String)"attribute argument must be assignable to RrdGraphAttribute");
        RrdGraphAttribute rrdAttribute = (RrdGraphAttribute)attribute;
        File rrdFile = new File(this.m_rrdBaseDirectory, rrdAttribute.getRrdRelativePath());
        try {
            return this.m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), attribute.getName(), interval, range);
        }
        catch (Throwable e) {
            throw new DataAccessResourceFailureException("Failure to fetch last value from file '" + rrdFile + "' with interval " + interval + " and range " + range, e);
        }
    }
}

