/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.api.VlanDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsVlan;

public class VlanDaoHibernate
extends AbstractDaoHibernate<OnmsVlan, Integer>
implements VlanDao {
    public VlanDaoHibernate() {
        super(OnmsVlan.class);
    }

    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsVlan vlan : this.findMatching(criteria)) {
            vlan.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(vlan);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        for (OnmsVlan item : this.findMatching(criteria)) {
            item.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(item);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE)));
        for (OnmsVlan item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    public void setStatusForNode(Integer nodeId, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        for (OnmsVlan item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public OnmsVlan findByNodeAndVlan(Integer nodeId, Integer vlanId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"vlanId", (Object)vlanId));
        List objects = this.findMatching(criteria);
        if (objects != null && objects.size() > 0) {
            return (OnmsVlan)objects.get(0);
        }
        return null;
    }
}

