/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.TopologyDao;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TopologyDaoHibernate
extends HibernateDaoSupport
implements TopologyDao {
    public OnmsNode getDefaultFocusPoint() {
        String query1 = "select dli.nodeParentId from DataLinkInterface as dli group by dli.nodeParentId order by count(*) desc";
        String query2 = "select node.id from OnmsSnmpInterface as snmp join snmp.node as node group by node order by sum(snmp.ifSpeed) desc";
        OnmsNode focusNode = (OnmsNode)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<OnmsNode>(){

            public OnmsNode doInHibernate(Session session) throws HibernateException, SQLException {
                Integer nodeParentId = (Integer)session.createQuery("select dli.nodeParentId from DataLinkInterface as dli group by dli.nodeParentId order by count(*) desc").setMaxResults(1).uniqueResult();
                return TopologyDaoHibernate.this.getNode(nodeParentId, session);
            }
        });
        if (focusNode == null) {
            focusNode = (OnmsNode)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<OnmsNode>(){

                public OnmsNode doInHibernate(Session session) throws HibernateException, SQLException {
                    Integer nodeId = (Integer)session.createQuery("select node.id from OnmsSnmpInterface as snmp join snmp.node as node group by node order by sum(snmp.ifSpeed) desc").setMaxResults(1).uniqueResult();
                    return TopologyDaoHibernate.this.getNode(nodeId, session);
                }
            });
        }
        return focusNode;
    }

    private OnmsNode getNode(Integer nodeId, Session session) {
        if (nodeId != null) {
            Query q = session.createQuery("from OnmsNode as n where n.id = :nodeId");
            q.setInteger("nodeId", nodeId.intValue());
            return (OnmsNode)q.uniqueResult();
        }
        return null;
    }
}

