/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.api.StpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsStpInterface;

public class StpInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsStpInterface, Integer>
implements StpInterfaceDao {
    public StpInterfaceDaoHibernate() {
        super(OnmsStpInterface.class);
    }

    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsStpInterface stpIface : this.findMatching(criteria)) {
            stpIface.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(stpIface);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(item);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE)));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public OnmsStpInterface findByNodeAndVlan(Integer nodeId, Integer bridgePort, Integer vlan) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"bridgePort", (Object)bridgePort));
        criteria.add((Criterion)Restrictions.eq((String)"vlan", (Object)vlan));
        List stpInterfaces = this.findMatching(criteria);
        if (stpInterfaces != null && stpInterfaces.size() > 0) {
            return (OnmsStpInterface)stpInterfaces.get(0);
        }
        return null;
    }
}

