/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.springframework.orm.hibernate3.HibernateCallback;

public class BridgeMacLinkDaoHibernate
extends AbstractDaoHibernate<BridgeMacLink, Integer>
implements BridgeMacLinkDao {
    public BridgeMacLinkDaoHibernate() {
        super(BridgeMacLink.class);
    }

    public List<BridgeMacLink> findByNodeId(Integer id) {
        return this.find("from BridgeMacLink rec where rec.node.id = ?", id);
    }

    public BridgeMacLink getByNodeIdBridgePortMac(Integer id, Integer port, String mac) {
        return (BridgeMacLink)this.findUnique("from BridgeMacLink rec where rec.node.id = ?  and rec.bridgePort = ? and rec.macAddress = ? ", id, port, mac);
    }

    public List<BridgeMacLink> findByMacAddress(String mac) {
        return this.find("from BridgeMacLink rec where rec.macAddress = ?", mac);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (BridgeMacLink elem : this.find("from BridgeMacLink rec where rec.node.id = ? and rec.bridgeMacLinkLastPollTime < ?", nodeId, now)) {
            this.delete(elem);
        }
    }

    public List<BridgeMacTopologyLink> getAllBridgeLinksToIpAddrToNodes() {
        List links = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery("select mlink.*,ntm.netaddress, ip.ipaddr, ip.nodeid as targetnodeid, node.nodelabel, ntm.sourceIfIndex from bridgemaclink as mlink left join ipnettomedia as ntm on mlink.macaddress = ntm.physaddress left join ipinterface ip on ip.ipaddr = ntm.netaddress left join node on ip.nodeid = node.nodeid order by bridgeport;").list();
            }
        });
        ArrayList<BridgeMacTopologyLink> topoLinks = new ArrayList<BridgeMacTopologyLink>();
        for (Object[] link : links) {
            topoLinks.add(new BridgeMacTopologyLink((Integer)link[0], (Integer)link[1], (Integer)link[2], (Integer)link[3], (Integer)link[4], (Integer)link[5], (String)link[6], (String)link[9], (String)link[10], (Integer)link[11], (String)link[12], (Integer)link[13]));
        }
        return topoLinks;
    }
}

